/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.fx;

import ext.lib.fx.layout.FxBorderPane;
import ext.module.xsod.common.XsodUtil;
import ext.module.xsod.fx.XsodController;
import ext.module.xsod.fx.XsodUiFactory;
import ext.module.xsod.model.XsodCategory;
import ext.module.xsod.model.XsodMenuData;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

public class XsodCategory2Pane
extends FxBorderPane {
    VBox menuBox = XsodUiFactory.getInstance().createVBox();
    String category1Code;

    public XsodCategory2Pane() throws Exception {
        this.setComponent();
    }

    protected void setComponent() throws Exception {
        this.menuBox.setPadding(new Insets(10.0, 20.0, 10.0, 20.0));
        this.menuBox.setSpacing(20.0);
        StackPane baseStackPane = XsodUiFactory.getInstance().createBackgrondNode((Node)this.menuBox, Color.PLUM);
        this.setCenter((Node)baseStackPane);
    }

    protected void setCategoryList(String category1Code, List<XsodCategory> categoryList) throws Exception {
        this.category1Code = category1Code;
        this.menuBox.getChildren().clear();
        XsodMenuData menuData = XsodController.getInstance().getMenuData();
        int i = 0;
        while (i < categoryList.size()) {
            XsodCategory category = categoryList.get(i);
            String categoryName = XsodUtil.getName(category, XsodController.getInstance().langCode, true);
            Button button = XsodUiFactory.getInstance().createButton2(categoryName);
            button.setOnAction(this.actionEventHandler);
            button.setUserData((Object)category.code);
            this.menuBox.getChildren().add((Object)button);
            ++i;
        }
        if (categoryList.size() <= 0) {
            XsodController.getInstance().category2Selected(category1Code);
        } else {
            XsodCategory category = categoryList.get(0);
            XsodController.getInstance().category2Selected(category.code);
        }
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() instanceof Button) {
            Button button = (Button)ev.getSource();
            String categoryCode = (String)button.getUserData();
            XsodController.getInstance().category2Selected(categoryCode);
        }
    }
}

