/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xmmd.fx;

import ext.base.log.BcLogUtil;
import ext.base.table.BcTableColumnModel;
import ext.lib.datasource.util.DtsWordManager;
import ext.lib.fx.table.FxTableRow;
import ext.lib.fx.table.FxTableUtil;
import ext.lib.fx.table.FxTableView;
import ext.module.xdts.common.XdtsUtil;
import ext.module.xmmd.common.XmmdConstants;
import ext.module.xmmd.common.XmmdUtil;
import ext.module.xmmd.fx.XmmdEventHandler;
import ext.module.xmmd.fx.XmmdFieldTableModel;
import ext.module.xmmd.model.XmmdField;
import ext.module.xmmd.model.XmmdModel;
import ext.scf4.fx.HfxLoadableTablePane;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;

public class XmmdFieldListPane
extends BorderPane {
    XmmdModel xmmdModel;
    XmmdFieldTableModel fieldTableModel;
    FxTableView tableView;
    List<XmmdEventHandler> mmdEventHandlerList = new ArrayList<XmmdEventHandler>();
    DtsWordManager wordManager;

    public void setData(XmmdModel xmmdModel, DtsWordManager wordManager) throws Exception {
        this.xmmdModel = xmmdModel;
        this.wordManager = wordManager;
        BcTableColumnModel tableColumnModel = XdtsUtil.createColumnDefineTableColumnModel();
        this.tableView = new InnerTableView();
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        FxTableUtil.createColumn(tableColumnModel, this.tableView, null);
        List<String> fieldNameList = XmmdUtil.toFieldNameList(xmmdModel.fieldList);
        this.fieldTableModel = new XmmdFieldTableModel(xmmdModel.logicalName, fieldNameList, xmmdModel.fieldNameMap, wordManager);
        ObservableList rowObservableList = FXCollections.observableArrayList();
        int i = 0;
        while (i < this.fieldTableModel.getRowCount()) {
            FxTableRow tableRow = new FxTableRow(i, this.fieldTableModel);
            rowObservableList.add((Object)tableRow);
            ++i;
        }
        this.tableView.setItems(rowObservableList);
        HfxLoadableTablePane loadableTablePane = new HfxLoadableTablePane();
        loadableTablePane.setTableView(this.tableView);
        loadableTablePane.setMainContent((Node)this.tableView);
        this.setCenter((Node)loadableTablePane);
    }

    public void addEventHandler(XmmdEventHandler eventHandler) {
        this.mmdEventHandlerList.add(eventHandler);
    }

    public boolean removeEventHandler(XmmdEventHandler eventHandler) {
        return this.mmdEventHandlerList.remove(eventHandler);
    }

    class InnerTableView
    extends FxTableView {
        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged((FxTableView)this, rowIdList, prevRowId, nextRowId);
            ObservableList tableViewItems = this.getItems();
            String columnName = (String)FxTableUtil.getCellValue((TableView)this, nextRowId, XmmdConstants.TableColmnName.xmmd_field__column_name.value);
            XmmdField mmdField = XmmdFieldListPane.this.xmmdModel.getFieldByName(columnName);
            Object[] eventHandlers = XmmdFieldListPane.this.mmdEventHandlerList.toArray();
            int i = 0;
            while (i < eventHandlers.length) {
                XmmdEventHandler eventHandler = (XmmdEventHandler)eventHandlers[i];
                try {
                    eventHandler.mmdSelected(mmdField);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
                ++i;
            }
        }
    }
}

