/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xmmd.dao;

import ext.base.core.BcStringUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xmmd.model.XmmdScreen;
import java.util.List;

public class XmmdScreenDAO
extends OrmAbstractDAO<XmmdScreen> {
    private XmmdScreenDAO() {
        super(new XmmdScreen[0]);
        this.setTableName("xmmd_screen");
    }

    public static XmmdScreenDAO getInstance() {
        return SingletonHolder.instance;
    }

    public List<XmmdScreen> getEntityList(DtsSession dtsSession, Integer schemaId, String modelName) throws Exception {
        SqlWhereElement whereElement;
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectSql selectSql = new SqlSelectSql();
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(null));
        selectSql.setFromClause(this.tableName);
        if (schemaId != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("schema_id = " + schemaId);
            selectSql.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(modelName)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("model_name " + sqlContext.toCondition_string("=", modelName));
            selectSql.addWhereElement(whereElement);
        }
        selectSql.getOrderByList().add("schema_id");
        selectSql.getOrderByList().add("model_name");
        String query = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, query);
    }

    public XmmdScreen getByName(DtsSession dtsSession, Integer schemaId, String modelName) throws Exception {
        List<XmmdScreen> profileList = this.getEntityList(dtsSession, schemaId, modelName);
        XmmdScreen profile = null;
        if (profileList.size() > 0) {
            profile = profileList.get(0);
        }
        return profile;
    }

    /* synthetic */ XmmdScreenDAO(XmmdScreenDAO xmmdScreenDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XmmdScreenDAO instance = new XmmdScreenDAO(null);

        private SingletonHolder() {
        }
    }
}

