/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xmmd.dao;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xmmd.model.XmmdModel;
import java.util.List;

public class XmmdModelDAO
extends OrmAbstractDAO<XmmdModel> {
    public static final int MODE_default = 1;

    private XmmdModelDAO() {
        super(new XmmdModel[0]);
        this.setTableName("xmmd_model");
    }

    public static XmmdModelDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectSql createSelectSql(SqlContext sqlContext, int mode, String alias, Integer schemaId, String tableName2) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectSql selectSql = new SqlSelectSql();
        if (schemaId != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("schema_id = " + schemaId);
            selectSql.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(tableName2)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("table_name " + sqlContext.toCondition_string("=", tableName2));
            selectSql.addWhereElement(whereElement);
        }
        selectSql.setFromClause(String.valueOf(this.getTableName()) + BcStringUtil.appendCaseOfTestDataNotEmpty(alias, " AS " + alias));
        if (mode == 1) {
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "schema_id");
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "table_name");
        }
        return selectSql;
    }

    public List<XmmdModel> getList(DtsSession dtsSession, Integer schemaId, String modelName) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = null;
        SqlSelectSql selectSql = this.createSelectSql(sqlContext, 1, alias, schemaId, modelName);
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, query);
    }

    public XmmdModel getByName(DtsSession dtsSession, Integer schemaId, String modelName) throws Exception {
        List<XmmdModel> entityList = this.getList(dtsSession, schemaId, modelName);
        return BcCollectionUtil.getFirst(entityList);
    }

    public long deleteByModelName(DtsSession dtsSession, String tableName2) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "DELETE FROM " + this.getTableName() + " WHERE table_name" + sqlContext.toCondition_string("=", tableName2);
        BcLogUtil.debug("query=" + query);
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    /* synthetic */ XmmdModelDAO(XmmdModelDAO xmmdModelDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XmmdModelDAO instance = new XmmdModelDAO(null);

        private SingletonHolder() {
        }
    }
}

