/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xmmd.dao;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xmmd.model.XmmdField;
import java.util.List;

public class XmmdFieldDAO
extends OrmAbstractDAO<XmmdField> {
    public static final int MODE_default = 1;

    private XmmdFieldDAO() {
        super(new XmmdField[0]);
        this.setTableName("xmmd_field");
    }

    public static XmmdFieldDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectSql createSelectSql(SqlContext sqlContext, int mode, String alias, Integer schemaId, String tableName2) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectSql selectSql = new SqlSelectSql();
        if (schemaId != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("schema_id = " + schemaId);
            selectSql.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(tableName2)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("table_name " + sqlContext.toCondition_string("=", tableName2));
            selectSql.addWhereElement(whereElement);
        }
        selectSql.setFromClause(String.valueOf(this.getTableName()) + BcStringUtil.appendCaseOfTestDataNotEmpty(alias, " AS " + alias));
        if (mode == 1) {
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "schema_id");
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "table_name");
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "ordinal_position");
        }
        return selectSql;
    }

    public List<XmmdField> getList(DtsSession dtsSession, Integer schemaId, String tableName2) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = null;
        SqlSelectSql selectSql = this.createSelectSql(sqlContext, 1, alias, schemaId, tableName2);
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, query);
    }

    public long deleteByModelName(DtsSession dtsSession, Integer schemaId, String tableName2) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "DELETE FROM " + this.getTableName() + " WHERE schema_id = " + schemaId + " AND table_name" + sqlContext.toCondition_string("=", tableName2);
        BcLogUtil.debug("query=" + query);
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    /* synthetic */ XmmdFieldDAO(XmmdFieldDAO xmmdFieldDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XmmdFieldDAO instance = new XmmdFieldDAO(null);

        private SingletonHolder() {
        }
    }
}

