/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xjps.fx;

import ext.base.core.BcBooleanUtil;
import ext.base.core.BcTimeUtil;
import ext.base.io.BcFileCircuiter;
import ext.base.io.BcFileFilter;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableModel;
import ext.lib.sourceparser.JspAbstractVisitor;
import ext.lib.sourceparser.JspParseUtil;
import ext.lib.sourceparser.JspSourceParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class XjpsJavaParser {
    JspSourceParser sourceParser = new JspSourceParser();
    JspAbstractVisitor astVisitor = new InnerVisitor();
    BcTableColumnModel tableColumnModel;
    BcTableModel tableModel;
    File currentFile;

    public XjpsJavaParser() throws Exception {
        this.init();
    }

    public void init() throws Exception {
        this.tableColumnModel = this.createTableColumnModel();
        this.tableModel = new BcTableModel();
    }

    public void parse(File file) throws Exception {
        long startTime = System.currentTimeMillis();
        if (file.isFile()) {
            if (this.isJavaFile(file.getName())) {
                this.currentFile = file;
                this.sourceParser.setVisitor(this.astVisitor);
                this.sourceParser.parse(file);
            }
        } else {
            BcFileFilter fileFilter = new BcFileFilter();
            fileFilter.setHiddenEnable(false);
            fileFilter.addAcceptPattern(".*");
            ArrayList<File> fileList = new ArrayList<File>();
            InnerFileCircuiter fileCircuit = new InnerFileCircuiter(fileList);
            fileCircuit.setFileFilter(fileFilter);
            this.setStatus("\u51e6\u7406\u5bfe\u8c61\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u7d22\u4e2d...");
            fileCircuit.start(file);
            this.parse(fileList);
            long elapsedTime = System.currentTimeMillis() - startTime;
            String elapsedTimeStr = BcTimeUtil.getTermString(elapsedTime);
            this.setStatus("\u89e3\u6790\u7d42\u4e86\uff08\u7d4c\u904e\u6642\u9593" + elapsedTimeStr + ")");
        }
    }

    public void parse(Collection<? extends File> fileCollection) throws Exception {
        int cnt = 0;
        for (File file : fileCollection) {
            this.setStatus("\u89e3\u6790\u4e2d..(" + ++cnt + "/" + fileCollection.size() + ")" + "\n" + file.getPath() + "\n" + file.getName());
            this.parse(file);
        }
    }

    public boolean isJavaFile(String fileNmae) throws Exception {
        return fileNmae.endsWith(".java");
    }

    public void setStatus(String status) throws Exception {
    }

    protected BcTableColumnModel createTableColumnModel() {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        MmdField mmdField = null;
        BcTableColumn tableColumn = null;
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.displayName = "Package";
        mmdField.columnCount = 18;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.displayName = "Class Modifiers";
        mmdField.columnCount = 14;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.displayName = "Class Name";
        mmdField.columnCount = 20;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.displayName = "Is Constructor";
        mmdField.columnCount = 10;
        mmdField.horizonalAlignment = 0;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.displayName = "Method Modifiers";
        mmdField.columnCount = 14;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.displayName = "Method Name";
        mmdField.columnCount = 20;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Integer.class;
        mmdField.displayName = "Parameters Size";
        mmdField.columnCount = 10;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.displayName = "Parameters";
        mmdField.columnCount = 60;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.displayName = "Return Value";
        mmdField.columnCount = 16;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Integer.class;
        mmdField.displayName = "Line Number";
        mmdField.columnCount = 8;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.displayName = "File Directory";
        mmdField.columnCount = 24;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.displayName = "File Name";
        mmdField.columnCount = 16;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.displayName = "File Last Modified";
        mmdField.columnCount = 12;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Long.class;
        mmdField.displayName = "File Size(Byte)";
        mmdField.columnCount = 8;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static void main(String[] args) {
        try {
            File file = new File("Y:/temp/java_source");
            XjpsJavaParser jpsParser = new XjpsJavaParser();
            jpsParser.parse(file);
            System.out.println("Done !");
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            System.out.println("File " + args[0] + " not found.");
        }
    }

    class InnerFileCircuiter
    extends BcFileCircuiter {
        List<File> fileList;

        public InnerFileCircuiter(List<File> fileList) {
            this.fileList = fileList;
        }

        @Override
        public void fileWasFound(File file, int dirCount, int fileCount) throws Exception {
            if (XjpsJavaParser.this.isJavaFile(file.getName())) {
                XjpsJavaParser.this.setStatus("\u51e6\u7406\u5bfe\u8c61\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u7d22\u4e2d... (" + this.fileList.size() + ")" + "\n" + file.getParentFile().getPath() + "\n" + file.getName());
                this.fileList.add(file);
            }
        }
    }

    class InnerVisitor
    extends JspAbstractVisitor {
        PackageDeclaration packageDeclaration;
        TypeDeclaration typeDeclaration;

        @Override
        public boolean visit(PackageDeclaration packageDeclaration) {
            this.packageDeclaration = packageDeclaration;
            return super.visit(packageDeclaration);
        }

        @Override
        public boolean visit(TypeDeclaration typeDeclaration) {
            this.typeDeclaration = typeDeclaration;
            return super.visit(typeDeclaration);
        }

        @Override
        public boolean visit(MethodDeclaration methodDeclaration) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(this.packageDeclaration.getName().getFullyQualifiedName());
            row.add(JspParseUtil.toModifiersText(this.typeDeclaration.modifiers()));
            row.add(this.typeDeclaration.getName().getIdentifier());
            row.add(BcBooleanUtil.toYN(methodDeclaration.isConstructor()));
            row.add(JspParseUtil.toModifiersText(methodDeclaration.modifiers()));
            row.add(methodDeclaration.getName().getFullyQualifiedName());
            row.add(methodDeclaration.parameters().size());
            row.add(JspParseUtil.toParametersText(methodDeclaration.parameters()));
            row.add(methodDeclaration.getReturnType2());
            row.add(this.compilationUnit.getLineNumber(methodDeclaration.getStartPosition()));
            row.add(XjpsJavaParser.this.currentFile.getParentFile().getPath());
            row.add(XjpsJavaParser.this.currentFile.getName());
            row.add(BcTimeUtil.toString(BcTimeUtil.toCalendar(XjpsJavaParser.this.currentFile.lastModified()), "yyyy/MM/dd HH:mm:ss"));
            row.add(XjpsJavaParser.this.currentFile.length());
            XjpsJavaParser.this.tableModel.addRow(row);
            return super.visit(methodDeclaration);
        }
    }
}

