/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.swg;

import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcWords;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgTableView;
import ext.lib.swg.SwgTableViewUtil;
import ext.module.wbs1.model.Wbs1ArticleCondition;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xfil.rmo.XfilFileListRMO;
import ext.scf5.swg.IswgAbstractDataViewPanel;
import ext.scf5.swg.IswgLoadableTablePanel;
import ext.scf5.swg.IswgPrintConditionPanel;
import ext.scf6.swg.JswgAbstractDataViewPanel_FxCondition;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javax.swing.event.ListSelectionEvent;

public class XfilFileListPanel
extends JswgAbstractDataViewPanel_FxCondition {
    private static final long serialVersionUID = 5883833440954133335L;
    IswgPrintConditionPanel printCondtionPane;

    public XfilFileListPanel() throws Exception {
        super(IswgAbstractDataViewPanel.Style.Default);
        Parent conditionNode = this.createConditionNode(-1, null);
        this.setConditionNode(conditionNode);
    }

    @Override
    public String getTitle() throws Exception {
        return "\u30d5\u30a1\u30a4\u30eb\u30ea\u30b9\u30c8";
    }

    @Override
    protected Parent createConditionNode(int tabIndex, Node preConditionNode) throws Exception {
        InnerConditionPane conditionPane = new InnerConditionPane();
        if (preConditionNode != null) {
            InnerConditionPane innerConditionPane = (InnerConditionPane)preConditionNode;
        }
        FxUtil.defaultInitialize((Node)conditionPane);
        return conditionPane;
    }

    @Override
    protected RmiRequest createRequest() throws Exception {
        InnerConditionPane conditionPane = (InnerConditionPane)this.getConditionNode();
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XfilFileListRMO.class.getName());
        rmiReq.setMethodName("fileList");
        rmiReq.addData(new Wbs1ArticleCondition());
        return rmiReq;
    }

    @Override
    public IswgLoadableTablePanel createTablePanel() throws Exception {
        InnerTablePanel tablePanel = new InnerTablePanel();
        return tablePanel;
    }

    class InnerConditionPane
    extends FxFlowPane {
        public InnerConditionPane() throws Exception {
            super(21);
        }
    }

    class InnerTablePanel
    extends IswgLoadableTablePanel {
        SwgButton openButton;
        SwgButton printButton;

        public InnerTablePanel() throws Exception {
            this.openButton = new SwgButton(BcWords.getInstance().preview);
            this.printButton = new SwgButton(BcWords.getInstance().print);
            this.setVisualSaveEnavled(true);
            this.openButton.addActionListener(this.actionListener);
            this.tableControlPanel.addControl3(this.openButton);
            this.openButton.setEnabled(false);
            this.printButton.addActionListener(this.actionListener);
            this.tableControlPanel.addControl3(this.printButton);
            this.printButton.setEnabled(false);
        }

        @Override
        protected void tableSelectionChanged(ListSelectionEvent ev) throws Exception {
            super.tableSelectionChanged(ev);
            if (!ev.getValueIsAdjusting()) {
                SwgTableView tableView = this.getTableView();
                if (tableView.getSelectedRows().length > 0) {
                    this.openButton.setEnabled(true);
                    this.printButton.setEnabled(true);
                } else {
                    this.openButton.setEnabled(false);
                    this.printButton.setEnabled(false);
                }
            }
        }

        @Override
        protected void tableMouseClicked(MouseEvent ev) throws Exception {
            super.tableMouseClicked(ev);
            if (ev.getClickCount() != 2) {
                return;
            }
            SwgTableView tableView = this.getTableView();
            int rowId = tableView.rowAtPoint(ev.getPoint());
            List<List> rowList = SwgTableViewUtil.getRowList(tableView, rowId, "xfil_file_attribute.id", "xfil_file_attribute.directory_", "xfil_file_attribute.file_name");
            List<XfilUriEntity> fileAttributeList = this.toFileAttributeList(rowList);
            this.openFile(fileAttributeList);
        }

        @Override
        protected void actionPerformed2(ActionEvent ev) throws Exception {
            super.actionPerformed2(ev);
            if (ev.getSource() == this.openButton) {
                List<XfilUriEntity> fileAttributeList = this.getFileAttributeList();
                this.openFile(fileAttributeList);
            } else {
                ev.getSource();
            }
        }

        protected List<XfilUriEntity> getFileAttributeList() throws Exception {
            SwgTableView tableView = this.getTableView();
            List<List> rowList = SwgTableViewUtil.getSelectedRowList(tableView, "xfil_file_attribute.id", "xfil_file_attribute.directory_", "xfil_file_attribute.file_name");
            return this.toFileAttributeList(rowList);
        }

        protected List<XfilUriEntity> toFileAttributeList(List rowList) throws Exception {
            ArrayList<XfilUriEntity> fileAttributeList = new ArrayList<XfilUriEntity>();
            int i = 0;
            while (i < rowList.size()) {
                List row = (List)rowList.get(i);
                XfilUriEntity fileAttribute = new XfilUriEntity();
                fileAttribute.id = (Long)row.get(0);
                fileAttribute.path = (String)row.get(1);
                fileAttribute.name = (String)row.get(2);
                fileAttribute.extention = BcFileUtil.getExtention(fileAttribute.name);
                fileAttributeList.add(fileAttribute);
                ++i;
            }
            return fileAttributeList;
        }

        protected void openFile(Collection<XfilUriEntity> fileAttributeCollection) throws Exception {
            for (XfilUriEntity fileAttribute : fileAttributeCollection) {
                File file = new File(fileAttribute.path, fileAttribute.name);
                BcLogUtil.debug("openFile:file=" + file.getPath());
                Desktop.getDesktop().open(file);
            }
        }
    }
}

