/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.rmo;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.wbs1.model.Wbs1ArticleCondition;
import ext.module.xfil.dao.XfilUriEntityDAO;
import ext.scf3.rmo.ScfSqlUtil;
import ext.scf3.server.ScfSqlTask;
import ext.scf8.util.KscfKeywordUtil;
import java.util.ArrayList;

public class XfilFileListRMO
extends RmiAbstractRMO {
    public static final String METHOD_fileList = "fileList";
    DtsSession dtsSession;
    SqlContext sqlContext;
    SqlSelectSql selectSql;
    Wbs1ArticleCondition eventCondition;

    public Wbs1ArticleCondition getEventCondition() {
        return this.eventCondition;
    }

    public void setEventCondition(Wbs1ArticleCondition eventCondition) {
        this.eventCondition = eventCondition;
    }

    public void fileList(RmiRmoArgument rmoArg) throws Exception {
        this.eventCondition = (Wbs1ArticleCondition)rmoArg.getRequest().getData();
        ScfSqlTask sqlTask = ScfSqlUtil.createSqlTask(rmoArg);
        this.dtsSession = sqlTask.dtsSession;
        this.sqlContext = this.dtsSession.getSqlContext();
        this.selectSql = new SqlSelectSql();
        this.parseCondition();
        this.getFromClause();
        this.setColumnNameList();
        this.setOrderByPhrase();
        sqlTask.sql = this.sqlContext.buildSelectSql(this.selectSql);
        BcLogUtil.debug("query=" + sqlTask.sql);
        sqlTask.tableColumnNameList = this.selectSql.getSelectColumnList();
        sqlTask.tableContext.setConditionList(this.selectSql.getConditionList());
        ScfSqlUtil.generalListNew(sqlTask, (Object)this);
    }

    public void parseCondition() throws Exception {
        SqlContext sqlContext = this.dtsSession.getSqlContext();
        if (!BcStringUtil.isEmpty(this.eventCondition.keyword)) {
            String keywords = KscfKeywordUtil.conv(this.eventCondition.keyword);
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(String.valueOf(this.eventCondition.tableName) + ".subject" + sqlContext.toKeyword(keywords));
            sb.append(" OR ");
            sb.append(String.valueOf(this.eventCondition.tableName) + ".body" + sqlContext.toKeyword(keywords));
            sb.append(")");
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sb);
            this.selectSql.addWhereElement(whereElement);
        }
    }

    public void setColumnNameList() throws Exception {
        ArrayList<String> selectColumnNameList = new ArrayList<String>();
        selectColumnNameList.add("*");
        this.selectSql.getSelectColumnList().addAll(selectColumnNameList);
    }

    public void getFromClause() throws Exception {
        String tmpFromClause = this.selectSql.getFromClause();
        StringBuilder sb = new StringBuilder();
        sb.append(XfilUriEntityDAO.getInstance().getTableName());
        this.selectSql.setFromClause(sb.toString());
    }

    public void setOrderByPhrase() {
    }
}

