/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.swg;

import ext.base.core.BcStringUtil;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgComponentUnit;
import ext.lib.swg.SwgDecoratePanel;
import ext.lib.swg.SwgDialog;
import ext.lib.swg.SwgFileChooser;
import ext.lib.swg.SwgFormLayout;
import ext.lib.swg.SwgLabel;
import ext.lib.swg.SwgTextField;
import ext.lib.swg.SwgUtil;
import ext.module.impt.swg.ImptImportPanelInterfase;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

class XdtsLogicalNameExportPanel
extends SwgDecoratePanel {
    public static final int EXPORT = 1;
    public static final int IMPORT = 2;
    SwgLabel filePathLabel;
    SwgTextField filePathField;
    SwgButton fileChooseButton;
    SwgFileChooser fileChooser;
    int mode;
    boolean resValue;
    String windowTitle;
    Window window;
    ImptImportPanelInterfase importPanelInterfase01;

    public XdtsLogicalNameExportPanel(int mode) throws Exception {
        this.filePathLabel = new SwgLabel(BcWords.getInstance().destination);
        this.filePathField = new SwgTextField();
        this.fileChooseButton = new SwgButton(BcWords.getInstance().browse);
        this.fileChooser = new SwgFileChooser();
        this.setBorderSize(10, 40, 8, 8);
        this.setLine();
        this.setOkButton(BcWords.getInstance().completion);
        this.setCancelButton(BcWords.getInstance().cancel);
        SwgFormLayout formLayout = new SwgFormLayout();
        this.centerPanel.setLayout(formLayout);
        this.filePathField.setPreferredSize(SwgUtil.getTextFieldSize(this.getFont(), 80));
        SwgComponentUnit componentUnit = new SwgComponentUnit((Component)this.filePathLabel, this.filePathField, this.fileChooseButton);
        formLayout.componentUnitList.add(componentUnit);
        this.fileChooseButton.addActionListener(this.actionListener);
        switch (mode) {
            case 1: {
                String explanation = String.valueOf(BcWords.getInstance().destination) + "\u3092\u8a2d\u5b9a\u5f8c\u3001\u300c\u5b9f\u884c\u300d\u30dc\u30bf\u30f3\u62bc\u4e0b\u306b\u3088\u308a\u51e6\u7406\u3092\u958b\u59cb\u3057\u307e\u3059\u3002";
                this.setDescription(explanation, -1);
                this.filePathLabel.setText(BcWords.getInstance().destination);
                break;
            }
            case 2: {
                String explanation = "\u5165\u529b\u5148\u3092\u8a2d\u5b9a\u5f8c\u3001\u300c\u5b9f\u884c\u300d\u30dc\u30bf\u30f3\u62bc\u4e0b\u306b\u3088\u308a\u51e6\u7406\u3092\u958b\u59cb\u3057\u307e\u3059\u3002";
                this.setDescription(explanation, -1);
                this.filePathLabel.setText("\u5165\u529b\u5148");
            }
        }
    }

    @Override
    protected void okButtonAction() throws Exception {
        this.resValue = true;
        this.close();
    }

    @Override
    public void cancelButtonAction() {
        this.close();
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.fileChooseButton) {
            this.fileChooser.resetChoosableFileFilters();
            if (!BcStringUtil.isEmpty(this.filePathField.getText())) {
                this.fileChooser.setSelectedFile(new File(this.filePathField.getText()));
            }
            switch (this.fileChooser.showDialog(this, BcWords.getInstance().select)) {
                case 0: {
                    this.filePathField.setText(this.fileChooser.getSelectedFile().getPath());
                    break;
                }
            }
        }
    }

    @Override
    public void close() {
        this.window.dispose();
    }

    public boolean showAsDialog(Component ownerCompo) throws Exception {
        this.resValue = false;
        SwgDialog dialog = SwgUtil.createDialog(ownerCompo);
        this.window = dialog;
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                XdtsLogicalNameExportPanel.this.cancelButtonAction();
            }
        });
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.getContentPane().add((Component)this, "Center");
        if (this.mode == 1) {
            dialog.setIconImage(AwtImageHelper.getImage("export_64x64.png"));
        } else if (this.mode == 2) {
            dialog.setIconImage(AwtImageHelper.getImage("import_64x64.png"));
        }
        dialog.setTitle(this.windowTitle);
        SwgUtil.setCenter(this.window, 840.0, 260.0);
        this.window.setVisible(true);
        return this.resValue;
    }
}

