/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.swg;

import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.context.SqlContextFactory;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgOptionPane;
import ext.lib.swg.SwgUtil;
import ext.module.xdts.common.XdtsUtil;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.XdtsConditionBasePane;
import ext.module.xdts.fx.XdtsFxLauncher;
import ext.module.xdts.fx.XdtsSqlEditPane;
import ext.module.xdts.model.XdtsCustomSql;
import ext.module.xdts.model.XdtsProcessCondition;
import ext.module.xdts.model.v0001.XdtsExtractionCondition;
import ext.module.xdts.rmo.XdtsDataViewRMO;
import ext.module.xdts.stub.XdtsExtractionConditionStub;
import ext.module.xdts.swg.XdtsAbstractDataViewPanel;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javafx.scene.Node;
import javafx.scene.Parent;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class XdtsDataViewPanel_Sql
extends XdtsAbstractDataViewPanel {
    private static final long serialVersionUID = 4460877028057492016L;
    XdtsSqlEditPane sqlEditPanel1;
    protected SwgButton saveButton;
    protected SwgButton saveAsNewButton;
    protected SwgButton createConditionButton;
    private XdtsCustomSql customSql;

    public XdtsDataViewPanel_Sql() throws Exception {
        this.saveButton = new SwgButton(XdtsWords.getInstance().saveSql);
        this.saveAsNewButton = new SwgButton(XdtsWords.getInstance().saveAsNewSql);
        this.createConditionButton = new SwgButton("\u62bd\u51fa\u6761\u4ef6\u4f5c\u6210");
    }

    @Override
    protected Parent createConditionNode(int tabIndex, Node preConditionNode) throws Exception {
        XdtsConditionBasePane conditionBasePane1 = new XdtsConditionBasePane();
        this.sqlEditPanel1 = new XdtsSqlEditPane();
        if (preConditionNode == null) {
            if (this.customSql == null) {
                this.customSql = new XdtsCustomSql();
            }
            this.sqlEditPanel1.setSql(this.customSql.sql);
        } else {
            XdtsConditionBasePane conditionBasePane2 = (XdtsConditionBasePane)preConditionNode;
            XdtsSqlEditPane sqlEditPanel2 = (XdtsSqlEditPane)conditionBasePane2.getCenter();
            this.sqlEditPanel1.setSql(sqlEditPanel2.getSql());
        }
        this.setTitle(this.customSql.name);
        conditionBasePane1.setCenter((Node)this.sqlEditPanel1);
        FxUtil.defaultInitialize((Node)conditionBasePane1);
        return conditionBasePane1;
    }

    @Override
    protected void optionControlSetup(JPanel conditionControlPanel) throws Exception {
        super.optionControlSetup(conditionControlPanel);
        this.saveButton.addActionListener(this.actionListener);
        this.saveButton.setIcon(new ImageIcon(AwtImageHelper.getImage_icon("floppy_disk_64x64.png")));
        conditionControlPanel.add(this.saveButton);
        if (this.customSql.getDataId() > 0) {
            this.saveAsNewButton.addActionListener(this.actionListener);
            this.saveAsNewButton.setIcon(new ImageIcon(AwtImageHelper.getImage_icon("floppy_disk_64x64.png")));
            conditionControlPanel.add(this.saveAsNewButton);
        }
        this.createConditionButton.addActionListener(this.actionListener);
        this.createConditionButton.setIcon(new ImageIcon(AwtImageHelper.getImage_icon("form_64x64.png")));
        conditionControlPanel.add(this.createConditionButton);
    }

    @Override
    protected boolean validateCondition() throws Exception {
        BcResult result = XdtsUtil.validateSql(this.sqlEditPanel1.getSql());
        if (result.hasError()) {
            Component msgComponent = SwgUtil.createMessageComponent(null, result.getErrorList());
            SwgOptionPane.showMessageDialog(this, msgComponent, BcWords.getInstance().error, 0);
            return false;
        }
        return true;
    }

    @Override
    protected RmiRequest createRequest() throws Exception {
        XdtsProcessCondition processCondition = new XdtsProcessCondition();
        processCondition.profileId = this.getProfile().getDataId();
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsDataViewRMO.class.getName());
        rmiReq.setMethodName("dataView");
        rmiReq.addData(processCondition);
        rmiReq.addData(this.sqlEditPanel1.getSql());
        return rmiReq;
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.saveButton) {
            this.customSql.profileId = this.getProfile().getDataId();
            XdtsFxLauncher.customSqlPane(this.customSql, null);
        } else if (ev.getSource() == this.saveAsNewButton) {
            XdtsCustomSql customSql2 = (XdtsCustomSql)this.customSql.clone();
            customSql2.setObjectId(-1L);
            customSql2.setDataId(-1);
            XdtsFxLauncher.customSqlPane(customSql2, null);
        } else if (ev.getSource() == this.createConditionButton) {
            SqlContext sqlContext = SqlContextFactory.getSqlContext(this.getProfile().productId);
            BcResult result = XdtsExtractionConditionStub.getInstance().createExtractionCondition(this.getProfile().getDataId(), this.sqlEditPanel1.getSql());
            if (result.hasError()) {
                Component msgComponent = SwgUtil.createMessageComponent(null, result.getErrorList());
                SwgOptionPane.showMessageDialog(this, msgComponent, BcWords.getInstance().error, 0);
                return;
            }
            XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)result.getUserObject();
            XdtsFxLauncher.extractionCondition(sqlContext, extractionCondition);
        }
    }

    @Override
    protected void windowOpened(WindowEvent ev) throws Exception {
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                XdtsDataViewPanel_Sql.this.sqlEditPanel1.sqlTextArea.requestFocus();
            }
        });
    }

    @Override
    protected String getConditionTitle() throws Exception {
        return String.valueOf(BcWords.getInstance().extractionCondition) + "(SQL)";
    }

    @Override
    protected Image getIconImage() throws Exception {
        return AwtImageHelper.getImage("sql_48x48.png");
    }

    public XdtsCustomSql getCustomSql() throws Exception {
        return this.customSql;
    }

    public void setCustomSql(XdtsCustomSql customSql) throws Exception {
        this.customSql = customSql;
        this.setTitle(customSql.name);
    }

    class InnerConditionPane
    extends FxFlowPane {
        XdtsSqlEditPane sqlEditPanel;

        public InnerConditionPane() throws Exception {
            super(11);
            this.sqlEditPanel = new XdtsSqlEditPane();
        }
    }
}

