/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.server;

import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLoggableObject;
import ext.lib.datasource.DtsConnectionManager;
import ext.lib.datasource.DtsConnectionManagerImpl;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlUtil;
import ext.libx.etc.model.EtcWord;
import ext.libx.etc.util.EtcWordUtil;
import ext.module.xdts.dao.XdtsProfileDAO;
import ext.module.xdts.dao.XdtsWordDAO;
import ext.module.xdts.model.XdtsProfile;
import java.io.File;
import java.sql.Driver;
import java.util.List;

public class XdtsSessionFactoryManager
extends BcLoggableObject {
    private static XdtsSessionFactoryManager instance = new XdtsSessionFactoryManager();

    private XdtsSessionFactoryManager() {
    }

    public static XdtsSessionFactoryManager getInstance() {
        return instance;
    }

    public DtsSessionFactory createSessionFactory(XdtsProfile profile) throws Exception {
        profile.dtsProps.setProperty(SqlConstants.DatasourceProperty.user.name(), profile.user);
        if (BcStringUtil.isEmpty(profile.password)) {
            profile.dtsProps.remove(SqlConstants.DatasourceProperty.password.name());
        } else {
            profile.dtsProps.setProperty(SqlConstants.DatasourceProperty.password.name(), profile.password);
        }
        Driver driver = null;
        if (BcStringUtil.isEmpty(profile.driverFilePath)) {
            driver = SqlUtil.createDriver(profile.driver);
        } else {
            File file = new File(profile.driverFilePath);
            BcFileUtil.notEexistsException(file);
            driver = SqlUtil.createDriver(file, profile.driver);
        }
        DtsConnectionManagerImpl connectionManager = new DtsConnectionManagerImpl();
        ((DtsConnectionManager)connectionManager).setup(driver, profile.url, profile.dtsProps);
        profile.productId = ((DtsConnectionManager)connectionManager).getSqlContext().getDatabaseProduct().id;
        ((DtsConnectionManager)connectionManager).closeAllConnection();
        String datasourceName = this.createDatasourceName(profile.getDataId());
        DtsSessionFactory dtsSessionFactory = new DtsSessionFactory(datasourceName, connectionManager);
        return dtsSessionFactory;
    }

    public DtsSessionFactory getSessionFactory(DtsSession dtsSession, int profileId, boolean doCreate) throws Exception {
        String datasourceName = this.createDatasourceName(profileId);
        DtsSessionFactory dtsSessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactory(datasourceName);
        if (dtsSessionFactory != null) {
            return dtsSessionFactory;
        }
        if (!doCreate) {
            return null;
        }
        XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getById(dtsSession, profileId);
        if (profile == null) {
            String msg = String.format("\u30d7\u30ed\u30d5\u30a1\u30a4\u30ebID %d \u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", profileId);
            throw new Exception(msg);
        }
        dtsSessionFactory = this.createSessionFactory(profile);
        if (profile.getDataId() > 0) {
            List<EtcWord> wordList = XdtsWordDAO.getInstance().getListByProfileId(dtsSession, profile.getDataId());
            EtcWordUtil.setWordCollection(dtsSessionFactory.wordManager, wordList);
        }
        DtsSessionFactoryManegaer.getInstance().addSessionFactory(dtsSessionFactory);
        return dtsSessionFactory;
    }

    public DtsSessionFactory getSessionFactory(DtsSession dtsSession, int profileId) throws Exception {
        return this.getSessionFactory(dtsSession, profileId, false);
    }

    public void disconnect(int profileId) throws Exception {
        String msg;
        String datasourceName = this.createDatasourceName(profileId);
        DtsSessionFactory dtsSessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactory(datasourceName);
        if (dtsSessionFactory != null) {
            msg = String.format("Disconnecting... datasourceName=%s", dtsSessionFactory.getName());
            this.getLogger().info(msg);
            dtsSessionFactory.close();
            DtsSessionFactory dtsSessionFactory2 = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMap().remove(datasourceName);
            if (dtsSessionFactory2 == null) {
                msg = String.format("Does not exist in map. datasourceName=%s", dtsSessionFactory.getName());
                throw new Exception(msg);
            }
        } else {
            throw new Exception("SessionFactory is exits. profileId=" + profileId);
        }
        msg = String.format("Disconnected. datasourceName=%s", dtsSessionFactory.getName());
        this.getLogger().info(msg);
    }

    public String createDatasourceName(long profileId) throws Exception {
        return "xsys-" + profileId;
    }
}

