/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.server;

import ext.base.core.BcConstants;
import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLogger;
import ext.base.mmd.MmdModel;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableModel;
import ext.base.util.BcThrowableUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.util.DtsWordManagerImpl;
import ext.lib.sql.context.SqlContext;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.common.XdtsUtil;
import ext.module.xdts.model.XdtsProcessCondition;
import ext.module.xdts.model.XdtsSchemaObject;
import ext.module.xdts.server.XsysTableCopyTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class XdtsServerUtil {
    private XdtsServerUtil() {
    }

    public static XdtsServerUtil getInstance() {
        return SingletonHolder.instance;
    }

    public void copyRows(XdtsProcessCondition processCondition, DtsSession dtsSession1, DtsSession dtsSession2, BcLogger logger) throws Exception {
        File errorFile = new File(processCondition.errorFilePath);
        logger.info("errorFile=" + errorFile.getPath());
        BcFileUtil.makeParent(errorFile);
        Object writer1 = null;
        OutputStreamWriter errorWriter = null;
        errorWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(errorFile, false), BcConstants.baseCharset.name());
        this.copyRows_L2(processCondition, dtsSession1, dtsSession2, errorWriter, logger);
        if (processCondition.commitMode == XdtsConstants.CommitMode.FINAL) {
            dtsSession2.commit();
        }
    }

    public void copyRows_L2(XdtsProcessCondition processCondition, DtsSession dtsSession1, DtsSession dtsSession2, Writer errorWriter, BcLogger logger) throws Exception {
        logger.info("\u5bfe\u8c61\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u6570=" + processCondition.schemaObjectList.size());
        int i = 0;
        while (i < processCondition.schemaObjectList.size()) {
            XdtsSchemaObject schemaObject = processCondition.schemaObjectList.get(i);
            this.copyRows_L3(processCondition, dtsSession1, dtsSession2, schemaObject, errorWriter, logger);
            if (processCondition.commitMode == XdtsConstants.CommitMode.TABLE) {
                dtsSession2.commit();
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void copyRows_L3(XdtsProcessCondition processCondition, DtsSession dtsSession1, DtsSession dtsSession2, XdtsSchemaObject schemaObject, Writer errorWriter, BcLogger logger) throws Exception {
        block16: {
            logger.info("schemaObject.name1=" + schemaObject.name1);
            tableName2 = schemaObject.name1;
            if (!BcStringUtil.isEmpty(schemaObject.name2)) {
                tableName2 = schemaObject.name2;
            } else if (!BcStringUtil.isEmpty(processCondition.newTableName)) {
                tableName2 = processCondition.newTableName.replace("${tableName}", schemaObject.name1);
            }
            sqlContext1 = dtsSession1.getSqlContext();
            sqlContext2 = dtsSession2.getSqlContext();
            mmdModel1 = sqlContext1.createModelMetaData(dtsSession1.getConnection(), tableName2);
            mmdModel2 = (MmdModel)mmdModel1.clone();
            if (!BcStringUtil.isEmpty(tableName2)) {
                mmdModel2.tableName = tableName2;
            }
            existTable = sqlContext2.existTable(dtsSession2.getConnection(), mmdModel2.tableName);
            logger.info("existTable=" + existTable);
            doCreateTable = false;
            if (existTable) {
                if (processCondition.recreateTable) {
                    logger.info("\u65e2\u5b58\u30c6\u30fc\u30d6\u30eb\u3092\u524a\u9664\u4e2d... \u30c6\u30fc\u30d6\u30eb\u540d=" + mmdModel2.tableName);
                    cnt = sqlContext2.dropTable(dtsSession2.getConnection(), mmdModel2.tableName);
                    doCreateTable = true;
                }
            } else {
                doCreateTable = true;
            }
            if (doCreateTable) {
                logger.info("\u30c6\u30fc\u30d6\u30eb\u3092\u4f5c\u6210\u4e2d... \u30c6\u30fc\u30d6\u30eb\u540d=" + mmdModel2.tableName);
                try {
                    cnt = sqlContext2.createTable(dtsSession2.getConnection(), mmdModel2, logger);
                }
                catch (Exception ex) {
                    stackTrace = BcThrowableUtil.getStackTrace(ex);
                    errorWriter.append(stackTrace);
                    if (processCondition.iqnoreException) ** GOTO lbl39
                    throw ex;
                }
            } else if (processCondition.truncateTable) {
                logger.info("\u8907\u5199\u5148\u65e2\u5b58\u30c6\u30fc\u30d6\u30eb\u3092TRUNCATE\u4e2d... \u30c6\u30fc\u30d6\u30eb\u540d=" + mmdModel2.tableName);
                cnt = sqlContext2.truncateTable(dtsSession2.getConnection(), mmdModel2.tableName);
                logger.info("\u4ef6\u6570=" + cnt);
            }
lbl39:
            // 5 sources

            if (processCondition.copyRows) {
                tableCopyTask = new XsysTableCopyTask();
                tableCopyTask.setLogger(logger);
                tableCopyTask.setCondition(dtsSession1);
                tableCopyTask.setCondition(dtsSession2, processCondition, mmdModel1, mmdModel2);
                tableCopyTask.taskProcess();
            }
            if (doCreateTable) {
                logger.info("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3092\u4f5c\u6210\u4e2d... \u30c6\u30fc\u30d6\u30eb\u540d=" + mmdModel2.tableName);
                try {
                    tableCopyTask = sqlContext2.createIndex(dtsSession2.getConnection(), mmdModel2, logger);
                }
                catch (Exception ex) {
                    stackTrace = BcThrowableUtil.getStackTrace(ex);
                    errorWriter.append(stackTrace);
                    if (processCondition.iqnoreException) break block16;
                    throw ex;
                }
            }
        }
    }

    public BcTableModel toTableModel(DtsWordManagerImpl wordManager) throws Exception {
        BcTableColumnModel tableColumnModel = XdtsUtil.createWordTableColumnModel();
        BcTableModel tableModel = new BcTableModel(tableColumnModel);
        Iterator<Map.Entry<String, Map<String, String>>> iterator1 = wordManager.wordMap.entrySet().iterator();
        int cnt = 0;
        for (Map.Entry<String, Map<String, String>> mapEntry1 : wordManager.wordMap.entrySet()) {
            if (++cnt % 100 == 0) {
                BcLogUtil.info("cnt=" + cnt);
            }
            String wordCode = mapEntry1.getKey();
            Map<String, String> langMap = mapEntry1.getValue();
            for (Map.Entry<String, String> mapEntry2 : langMap.entrySet()) {
                String wordValue = mapEntry2.getValue();
                ArrayList<String> row = new ArrayList<String>();
                row.add(wordCode);
                row.add(mapEntry2.getKey());
                row.add(mapEntry2.getValue());
                row.add("\u5099\u8003");
                tableModel.addRow(row);
            }
        }
        return tableModel;
    }

    public Map<String, MmdModel> createMmdModelMap(DtsSession dtsSession, Collection<String> tableNameCollection) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        TreeMap<String, MmdModel> mmdMap = new TreeMap<String, MmdModel>();
        for (String tableName : tableNameCollection) {
            MmdModel mmdModel = sqlContext.createModelMetaData(dtsSession.getConnection(), tableName, true);
            mmdMap.put(tableName, mmdModel);
        }
        return mmdMap;
    }

    /* synthetic */ XdtsServerUtil(XdtsServerUtil xdtsServerUtil) {
        this();
    }

    private static final class SingletonHolder {
        private static final XdtsServerUtil instance = new XdtsServerUtil(null);

        private SingletonHolder() {
        }
    }
}

