/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.rmo;

import ext.base.core.BcTimeUtil;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcResult;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.rmi.common.RmiRemoteMethod;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.dao.XdtsProfileDAO;
import ext.module.xdts.model.XdtsProfile;
import ext.module.xdts.server.XdtsSessionFactoryManager;
import ext.scf3.rmo.ScfSqlUtil;
import ext.scf3.server.ScfSqlTask;
import ext.scf5.dao.ScfSchemaVersionDAO;
import ext.scf5.model.ScfSchemaVersion;
import java.util.List;

public class XdtsProfileRMO
extends RmiAbstractRMO {
    public void putProfile(RmiRmoArgument rmoArg) throws Exception {
        XdtsProfile profile1 = (XdtsProfile)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        BcResult result = new BcResult();
        XdtsProfile profile2 = (XdtsProfile)XdtsProfileDAO.getInstance().getByName(dtsSession, profile1.name);
        if (profile2 != null && profile1.getDataId() != profile2.getDataId()) {
            String msg = BcMessageCreator.getInstance().bindMessage(XdtsWords.getInstance().\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u540d_0_\u306f\u767b\u9332\u6e08\u3067\u3059, profile1.name);
            result.addError(msg);
        }
        if (!result.hasError()) {
            XdtsProfileDAO.getInstance().putEntity(dtsSession, profile1);
        }
        result.setUserObject(profile1);
        rmoArg.getRespons().addData(result);
    }

    public void deleteProfile(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getById(dtsSession, profileId);
        int cnt = XdtsProfileDAO.getInstance().deleteEntity(dtsSession, profile);
        rmoArg.getRespons().addData(profile);
    }

    public void getProfileById(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getById(dtsSession, profileId);
        rmoArg.getRespons().addData(profile);
    }

    public void getProfileByName(RmiRmoArgument rmoArg) throws Exception {
        String profileName = rmoArg.getRequest().getDataAsString();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getByName(dtsSession, profileName);
        rmoArg.getRespons().addData(profile);
    }

    public void getProfileList(RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        List profileList = XdtsProfileDAO.getInstance().getList(dtsSession, XdtsProfileDAO.Mode.group, null, null);
        rmoArg.getRespons().addData(profileList);
    }

    public void connectByProfileId(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getById(dtsSession, profileId);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, profileId, true);
        DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);
        profile.productId = dtsSessionWk1.getSqlContext().getDatabaseProduct().id;
        profile.connectionTimestamp = BcTimeUtil.createCalendar();
        ++profile.connectionCount;
        XdtsProfileDAO.getInstance().putEntity(dtsSession, profile);
        rmoArg.getRespons().addData(profile);
    }

    public void disconnect(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        XdtsSessionFactoryManager.getInstance().disconnect(profileId);
    }

    public void getSchemaVersion(RmiRmoArgument rmoArg) throws Exception {
        XdtsProfile profile = (XdtsProfile)rmoArg.getRequest().getData();
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().createSessionFactory(profile);
        DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);
        ScfSchemaVersion schemaVersion = null;
        if (ScfSchemaVersionDAO.getInstance().existTable(dtsSessionWk1)) {
            schemaVersion = ScfSchemaVersionDAO.getInstance().getLatest(dtsSessionWk1);
        }
        rmoArg.getRespons().addData(schemaVersion);
    }

    public void profileList(RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.createDtsSession();
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectSql selectSql = XdtsProfileDAO.getInstance().createSelectSql(sqlContext, XdtsProfileDAO.Mode.group, null, null, null);
        selectSql.getSelectColumnList().add(XdtsConstants.xdts_profile.id.tableColumnName());
        selectSql.getSelectColumnList().add(XdtsConstants.xdts_profile.group_.tableColumnName());
        selectSql.getSelectColumnList().add(XdtsConstants.xdts_profile.name.tableColumnName());
        selectSql.getSelectColumnList().add("xdts_profile.driver");
        selectSql.getSelectColumnList().add("xdts_profile.url_");
        selectSql.getSelectColumnList().add("xdts_profile.user_");
        selectSql.getSelectColumnList().add("xdts_profile.parameters_");
        selectSql.getSelectColumnList().add("xdts_profile.note_");
        selectSql.getSelectColumnList().add("xdts_profile.connection_count");
        String sql = sqlContext.buildSelectSql(selectSql);
        ScfSqlTask sqlTask = ScfSqlUtil.createSqlTask(rmoArg, dtsSession);
        sqlTask.sql = sql;
        sqlTask.rowLimit = XdtsConstants.LIMIT_recordCount;
        ScfSqlUtil.generalListNew(sqlTask, (Object)this);
    }

    public static enum Method implements RmiRemoteMethod
    {
        putProfile,
        deleteProfile,
        getProfileById,
        getProfileByName,
        getProfileList,
        profileList,
        connectByProfileId,
        disconnect,
        getSchemaVersion;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

