/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.rmo;

import ext.base.log.BcLogUtil;
import ext.base.log.BcLogger;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdModel;
import ext.base.mmd.MmdUtil;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcObjectConvertor;
import ext.base.util.BcParseEventHandler;
import ext.lib.datasource.DtsSession;
import ext.lib.sql.context.SqlContext;
import ext.module.impt.common.ImptAbstractRecordParser;
import ext.module.impt.common.ImptImportDataParser;
import ext.module.impt.model.ImptImportDefine;
import ext.module.xdts.common.XdtsWorkbookParser;
import ext.module.xdts.model.XdtsImportContext;
import java.io.FileInputStream;
import java.sql.PreparedStatement;
import java.util.List;

class XdtsImportProcess2
implements BcParseEventHandler {
    BcLogger logger;
    MmdModel mmdModel;
    ImptImportDefine importDefine;
    XdtsImportContext importContext;
    DtsSession dtsSession;
    SqlContext sqlContext;
    PreparedStatement ppst;

    public void setup(BcLogger logger, DtsSession dtsSession) throws Exception {
        this.logger = logger;
        this.dtsSession = dtsSession;
        this.sqlContext = dtsSession.getSqlContext();
    }

    public void doParse(XdtsImportContext importContext) throws Exception {
        ImptAbstractRecordParser recordParser;
        this.importContext = importContext;
        this.mmdModel = importContext.mmdModel;
        this.importDefine = importContext.importDefine;
        if (this.importDefine.datasourceType == 11 || this.importDefine.datasourceType == 21) {
            recordParser = new ImptImportDataParser();
            recordParser.addEventHandler(this);
        } else if (this.importDefine.datasourceType == 31) {
            recordParser = new XdtsWorkbookParser(importContext);
            recordParser.addEventHandler(this);
        } else {
            throw new Exception("importDefine.formatType=" + this.importDefine.datasourceType);
        }
        String insertQuery = this.sqlContext.createInsertSqlForPrepareStatement(importContext.mmdModel);
        this.logger.info("insertQuery=" + insertQuery);
        this.ppst = this.dtsSession.getConnection().prepareStatement(insertQuery);
        try {
            FileInputStream fileInputStream = new FileInputStream(importContext.file);
            recordParser.doParse(this.importDefine, fileInputStream);
        }
        finally {
            this.ppst.close();
        }
    }

    @Override
    public void parseStarted() throws Exception {
    }

    @Override
    public void parseFinished() throws Exception {
    }

    @Override
    public void parsedRow(int page, int rowNo, int totalCnt, List<String> valueList) throws Exception {
        try {
            this.parsedRow2(page, rowNo, totalCnt, valueList);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            BcLogUtil.debug("valueList=" + valueList);
        }
    }

    protected void parsedRow2(int page, int rowNo, int totalCnt, List valueList) throws Exception {
        if (rowNo < this.importDefine.headerRow) {
            return;
        }
        int mmdModelIndex = -1;
        if (this.importDefine.rowNumberEnabled) {
            int colmunIndex = ++mmdModelIndex + 1;
            int newRowNbr = totalCnt;
            if (this.importDefine.headerRow > 0) {
                newRowNbr -= this.importDefine.headerRow;
            }
            this.ppst.setObject(colmunIndex, newRowNbr);
        }
        BcCollectionUtil.fill(valueList, this.mmdModel.getFieldCount());
        int i = 0;
        while (i < valueList.size()) {
            int colmunIndex = ++mmdModelIndex + 1;
            Object value = valueList.get(i);
            MmdField mmdField = this.mmdModel.getField(mmdModelIndex);
            String strVal = "";
            if (value != null) {
                strVal = value.toString();
            }
            switch (mmdField.sqlTypeId) {
                case -1: {
                    this.sqlContext.set_LONGVARCHAR(this.ppst, colmunIndex, strVal);
                    break;
                }
                case -4: {
                    break;
                }
                case 2004: {
                    break;
                }
                default: {
                    if (value == null) {
                        this.ppst.setNull(colmunIndex, mmdField.sqlTypeId);
                        break;
                    }
                    Class javaClassType = MmdUtil.toJavaType(mmdField.sqlTypeId);
                    Object value2 = BcObjectConvertor.objectConvert(value, javaClassType);
                    this.ppst.setObject(colmunIndex, value2);
                }
            }
            ++i;
        }
        this.ppst.executeUpdate();
    }

    @Override
    public void characterDecodingException(int page, int row, int totalCnt, int columnIndex, byte[] bytes, Throwable throwable) throws Exception {
        BcLogUtil.error(throwable);
    }
}

