/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.rmo;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLogger;
import ext.base.mmd.MmdField;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.util.DtsWordManager;
import ext.lib.datasource.util.ScfMmdServerUtil;
import ext.lib.rmi.common.RmiRemoteMethod;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.context.SqlContext;
import ext.libx.etc.util.EtcEnumStrUtil;
import ext.libx.etc.util.EtcWordUtil;
import ext.module.xdts.common.XdtsSqlParser;
import ext.module.xdts.common.XdtsSqlParserUtil;
import ext.module.xdts.common.XdtsUtil;
import ext.module.xdts.dao.XdtsExtractionConditionDAO;
import ext.module.xdts.model.v0001.XdtsExtractionCondition;
import ext.module.xdts.server.XdtsSessionFactoryManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class XdtsExtractionConditionRMO
extends RmiAbstractRMO {
    public static final String METHOD_putEntity = "putEntity";
    public static final String METHOD_getEntity = "getEntity";
    String namePrefix;

    public XdtsExtractionConditionRMO() {
        this.namePrefix = String.valueOf(BcWords.getInstance().extractionCondition) + "-";
    }

    public void putEntity(RmiRmoArgument rmoArg) throws Exception {
        XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        extractionCondition.name = BcStringUtil.trim(extractionCondition.name);
        extractionCondition.group = XdtsUtil.reformPath(extractionCondition.group);
        XdtsExtractionConditionDAO.getInstance().putEntity(dtsSession, extractionCondition);
        if (BcStringUtil.isEmpty(extractionCondition.name)) {
            extractionCondition.name = this.createName(dtsSession, extractionCondition.profileId, extractionCondition.id, null, this.namePrefix);
            XdtsExtractionConditionDAO.getInstance().putEntity(dtsSession, extractionCondition);
        }
        rmoArg.getRespons().addData(extractionCondition);
    }

    public void deleteEntity(RmiRmoArgument rmoArg) throws Exception {
        Collection entityIdCollection = (Collection)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsExtractionCondition extractionCondition = new XdtsExtractionCondition();
        int cnt = 0;
        for (Integer entityId : entityIdCollection) {
            extractionCondition.id = entityId;
            cnt += XdtsExtractionConditionDAO.getInstance().deleteEntity(dtsSession, extractionCondition);
        }
        rmoArg.getRespons().addData(cnt);
    }

    public void getEntity(RmiRmoArgument rmoArg) throws Exception {
        int entityId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsExtractionCondition extractionCondition = XdtsExtractionConditionDAO.getInstance().getById(dtsSession, entityId);
        rmoArg.getRespons().addData(extractionCondition);
    }

    public void getList(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        List extractionConditionList = XdtsExtractionConditionDAO.getInstance().getList(dtsSession, profileId);
        rmoArg.getRespons().addData(extractionConditionList);
    }

    public void copyQueryContext(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        Collection extractionConditionIdCollection = (Collection)rmoArg.getRequest().getData();
        String group = rmoArg.getRequest().getDataAsString();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ArrayList<XdtsExtractionCondition> extractionConditionList = new ArrayList<XdtsExtractionCondition>();
        Iterator iterator = extractionConditionIdCollection.iterator();
        while (iterator.hasNext()) {
            int extractionConditionId = (Integer)iterator.next();
            XdtsExtractionCondition extractionCondition = XdtsExtractionConditionDAO.getInstance().getById(dtsSession, extractionConditionId);
            extractionCondition.name = this.createName(dtsSession, extractionCondition.profileId, extractionCondition.id, extractionCondition.name, this.namePrefix);
            extractionCondition.id = -1;
            extractionCondition.profileId = profileId;
            extractionCondition.group = group;
            XdtsExtractionConditionDAO.getInstance().putEntity(dtsSession, extractionCondition);
            extractionConditionList.add(extractionCondition);
        }
        rmoArg.getRespons().addData(extractionConditionList);
    }

    public String createName(DtsSession dtsSession, int profileId, int entityId, String origName, String namePrefix) throws Exception {
        if (BcStringUtil.isEmpty(origName)) {
            origName = String.valueOf(namePrefix) + entityId;
        }
        String newName = BcStringUtil.toStringNotNull(origName);
        String baseName = null;
        int tryCnt = 0;
        while (true) {
            BcLogUtil.debug("newName=" + newName);
            XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)XdtsExtractionConditionDAO.getInstance().getByName(dtsSession, profileId, newName);
            if (extractionCondition == null) break;
            if (BcStringUtil.isEmpty(baseName) && BcStringUtil.isEmpty(baseName = EtcWordUtil.getBaseName(origName))) {
                baseName = origName;
            }
            newName = String.valueOf(baseName) + EtcEnumStrUtil.toElement(++tryCnt);
        }
        return newName;
    }

    public void createExtractionCondition(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        String sql = rmoArg.getRequest().getDataAsString();
        DtsSession dtsSessionMain = rmoArg.getDtsSession(this);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSessionMain, profileId);
        DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);
        SqlContext sqlContextWk1 = dtsSessionWk1.getSqlContext();
        BcResult result = this.createExtractionCondition_L2(dtsSessionWk1, sql, BcLogUtil.getDefaultLogger());
        if (!result.hasError()) {
            XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)result.getUserObject();
            extractionCondition.profileId = profileId;
        }
        rmoArg.getRespons().addData(result);
    }

    public BcResult createExtractionCondition_L2(DtsSession dtsSession, String sql, BcLogger logger) throws Exception {
        BcResult result = XdtsUtil.validateSql(sql);
        if (result.hasError()) {
            return result;
        }
        List<MmdField> mmdFieldList = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            stmt.setMaxRows(1);
            ResultSet rs = stmt.executeQuery(sql);
            List<String> columnNameList = null;
            Map<String, MmdField> mmdFieldMap = null;
            DtsWordManager wordManager = dtsSession.getSessionFactory().wordManager;
            mmdFieldList = ScfMmdServerUtil.createMmdFieldList(rs.getMetaData(), columnNameList, mmdFieldMap, wordManager, Locale.getDefault());
            rs.close();
        }
        BcLogUtil.debug("mmdFieldList.size()=" + mmdFieldList.size());
        int i = 0;
        while (i < mmdFieldList.size()) {
            MmdField mmdField = mmdFieldList.get(i);
            BcLogUtil.debug("mmdField.tableColumnName=" + mmdField.tableColumnName);
            ++i;
        }
        XdtsSqlParser sqlParser = new XdtsSqlParser();
        XdtsExtractionCondition extractionCondition = sqlParser.createExtractionCondition(sql);
        XdtsSqlParserUtil.createExtractionCondition(extractionCondition, mmdFieldList, logger);
        result.setUserObject(extractionCondition);
        return result;
    }

    public static enum Method implements RmiRemoteMethod
    {
        deleteEntity,
        getList,
        copyQueryContext,
        createExtractionCondition;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

