/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.table.BcTableColumnModel;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.table.FxTableRowList;
import ext.lib.fx.table.FxTableUtil;
import ext.lib.fx.table.FxTableView;
import ext.lib.fx.util.FxUtil;
import ext.module.xdts.common.XdtsUtil;
import ext.module.xdts.fx.XdtsTaskMenuPane;
import ext.module.xdts.fx.XdtsTimerTableModel;
import ext.module.xdts.model.XdtsTimer;
import ext.module.xdts.stub.XdtsTimerStub;
import javafx.collections.ObservableList;
import javafx.scene.Node;

class XdtsTimerTablePane
extends FxBorderPane {
    XdtsTimerTableModel timerTableModel = new XdtsTimerTableModel();
    InnerTableView tableView;
    Object selectedValue;
    XdtsTaskMenuPane taskMenuPane;

    public XdtsTimerTablePane(XdtsTaskMenuPane taskMenuPane) throws Exception {
        this.taskMenuPane = taskMenuPane;
        this.setComponent();
        this.doLoad();
    }

    protected void setComponent() throws Exception {
        FxUtil.defaultInitialize((Node)this);
    }

    protected void doLoad() throws Exception {
        this.timerTableModel.timerList = XdtsTimerStub.getInstance().getTimerList();
        FxTableRowList tableRowList = new FxTableRowList(this.timerTableModel);
        this.tableView = new InnerTableView();
        BcTableColumnModel tableColumnModel = XdtsUtil.createTimerTableColumnModel();
        FxTableUtil.createColumn(tableColumnModel, this.tableView, null);
        this.tableView.setItems(tableRowList);
        this.setCenter((Node)this.tableView);
    }

    class InnerTableView<S>
    extends FxTableView<S> {
        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged((FxTableView)this, rowIdList, prevRowId, nextRowId);
            XdtsTimer timer = XdtsTimerTablePane.this.timerTableModel.timerList.get(nextRowId);
            try {
                XdtsTimerTablePane.this.taskMenuPane.setTimer(timer);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }
}

