/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.log.BcLogUtil;
import ext.base.util.BcInstanceManager;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.swg.SwgUtil;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.XdtsProductChoicePane;
import ext.module.xdts.fx.XdtsProfileGeneralEditPane;
import ext.module.xdts.model.XdtsProfile;
import ext.module.xdts.stub.XdtsProfileStub;
import ext.module.xsys.validation.XwebValidator;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XdtsProfileWizard {
    FxBorderPane borderPane = new FxBorderPane();
    XdtsProductChoicePane productChoicePane;
    XdtsProfileGeneralEditPane profileGeneralEditPane;
    XdtsProfile profile1;
    XdtsProfile resProfile;
    String title;
    Stage stage;

    protected void setProfile(XdtsProfile profile) throws Exception {
        this.profile1 = profile;
        this.title = profile.getDataId() <= 0 ? XdtsWords.getInstance().addProfile : XdtsWords.getInstance().editProfile;
        this.step1();
    }

    protected void step1() throws Exception {
        this.profileGeneralEditPane = new XdtsProfileGeneralEditPane(this);
        this.profileGeneralEditPane.setProfile(this.profile1);
        this.borderPane.setCenter((Node)this.profileGeneralEditPane);
    }

    protected void step_finish() throws Exception {
        Object object = BcInstanceManager.getInstance().remove(this.getClass(), this.profile1.getDataId());
        BcLogUtil.debug("close:object=" + object);
        BcResult result = this.validateInputValue(this.profile1);
        if (result.hasError()) {
            String message = BcMessageCreator.getInstance().createMessage(result.getErrorList()).toString();
            FxOptionPane.showMessageDialog((Window)this.stage, (Object)message, BcWords.getInstance().warning, 2);
            return;
        }
        BcLogUtil.debug("step_finish:storeData:profile1.note=" + this.profile1.note);
        BcResult result2 = XdtsProfileStub.getInstance().putProfile(this.profile1);
        if (result2.hasError()) {
            String message = BcMessageCreator.getInstance().createMessage(result2.getErrorList()).toString();
            FxOptionPane.showMessageDialog((Window)this.stage, (Object)message, BcWords.getInstance().warning, 2);
            return;
        }
        this.resProfile = (XdtsProfile)result2.getUserObject();
        this.close();
    }

    protected BcResult validateInputValue(XdtsProfile profile3) throws Exception {
        XwebValidator validator = XwebValidator.getInstance();
        BcResult result = validator.validateForGui(profile3);
        return result;
    }

    protected void closeConfirm() {
        this.close();
    }

    protected void close() {
        this.stage.close();
        BcInstanceManager.getInstance().remove(XdtsProfileWizard.class, this.profile1.getDataId());
    }

    public XdtsProfile show(XdtsProfile profile, Window ownerWindow) throws Exception {
        this.setProfile(profile);
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.APPLICATION_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XdtsProfileWizard.this.close();
                }
                catch (Exception ex) {
                    XdtsProfileWizard.this.handleException(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this.borderPane);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(900.0);
        this.stage.setHeight(380.0);
        this.stage.setResizable(false);
        this.stage.setTitle(this.title);
        this.stage.getIcons().add((Object)FxImageHelper.getImage("db_add_64x64.png"));
        this.stage.showAndWait();
        return this.resProfile;
    }

    public static XdtsProfile show2(XdtsProfile profile, Window ownerWindow) throws Exception {
        XdtsProfileWizard profileWizard = (XdtsProfileWizard)BcInstanceManager.getInstance().get(XdtsProfileWizard.class, profile.getDataId());
        if (profileWizard != null) {
            profileWizard.stage.toFront();
            return null;
        }
        profileWizard = new XdtsProfileWizard();
        BcInstanceManager.getInstance().put(profile.getDataId(), profileWizard);
        return profileWizard.show(profile, ownerWindow);
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }
}

