/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.event.BcEventHandlerList;
import ext.base.util.BcInstanceManager;
import ext.base.util.BcWords;
import ext.lib.datasource.util.DtsWordManager;
import ext.lib.datasource.util.DtsWordManagerImpl;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxTabPane;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlWords;
import ext.lib.sql.context.SqlContext;
import ext.libx.etc.model.EtcWord;
import ext.libx.etc.util.EtcWordUtil;
import ext.libx.fx.FxxAbstractDesktopPane;
import ext.module.xdts.common.XdtsUtil;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.XdtsDataImportWizard;
import ext.module.xdts.fx.XdtsDatasourcePane;
import ext.module.xdts.fx.XdtsProfileTreePane;
import ext.module.xdts.fx.XdtsTableInfoPane;
import ext.module.xdts.model.XdtsCustomSql;
import ext.module.xdts.model.XdtsProfile;
import ext.module.xdts.stub.XdtsProfileStub;
import ext.module.xdts.stub.XdtsWordStub;
import ext.module.xdts.swg.XdtsDataViewPanel_Sql;
import ext.module.xdts.swg.XdtsLogicalNamePanel;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XdtsProfilePane
extends FxxAbstractDesktopPane {
    FxBorderPane borderPane1 = new FxBorderPane();
    XdtsDatasourcePane datasourcePane = new XdtsDatasourcePane(XdtsDatasourcePane.Mode.display);
    FxFlowPane controlPane = new FxFlowPane(21);
    FxButton sqlButton;
    FxButton logicalNameButton;
    FxButton dataImportButton;
    SplitPane splitPane;
    XdtsProfileTreePane profileTreePane;
    FxTabPane tabPane1;
    XdtsProfile profile;
    SqlContext sqlContext;
    MenuItem closeMenuItem;
    DtsWordManager wordManager;
    BcEventHandlerList eventHandlerList;

    public XdtsProfilePane() throws Exception {
        this.sqlButton = new FxButton(SqlWords.getInstance().sql);
        this.logicalNameButton = new FxButton();
        this.dataImportButton = new FxButton();
        this.splitPane = new SplitPane();
        this.profileTreePane = new XdtsProfileTreePane(this);
        this.tabPane1 = new FxTabPane();
        this.closeMenuItem = new MenuItem(BcWords.getInstance().close);
        this.eventHandlerList = new BcEventHandlerList();
    }

    protected void setContents() throws Exception {
        FxUtil.setEditable((Node)this.datasourcePane, false);
        this.borderPane1.setLeft((Node)this.datasourcePane);
        this.sqlButton.setOnAction(this.actionEventHandler);
        this.sqlButton.setGraphic((Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
        this.sqlButton.setTooltip(new Tooltip(XdtsWords.getInstance().TOOL_TIP_queryButton));
        FxNodeUnit nodeUnit = new FxNodeUnit(null, new Node[]{this.sqlButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.logicalNameButton.setOnAction(this.actionEventHandler);
        this.logicalNameButton.setText(XdtsWords.getInstance().logicalNameTable);
        this.logicalNameButton.setGraphic((Node)FxImageHelper.createImageView_icon("dictionary_64x64.png"));
        this.logicalNameButton.setTooltip(new Tooltip(XdtsWords.getInstance().TOOL_TIP_logicalNameTable));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.logicalNameButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.dataImportButton.setOnAction(this.actionEventHandler);
        this.dataImportButton.setText(BcWords.getInstance().dataImport);
        this.dataImportButton.setGraphic((Node)FxImageHelper.createImageView_icon("import_64x64.png"));
        this.dataImportButton.setTooltip(new Tooltip(XdtsWords.getInstance().TOOL_TIP_dataImport));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.dataImportButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.borderPane1.setCenter((Node)this.controlPane);
        this.setTop((Node)this.borderPane1);
        this.tabPane1.setSide(Side.TOP);
        this.splitPane.getItems().addAll((Object[])new Node[]{this.profileTreePane, this.tabPane1});
        SplitPane.setResizableWithParent((Node)this.profileTreePane, (Boolean)Boolean.FALSE);
        this.setContentNode((Node)this.splitPane);
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setProfile(XdtsProfile profile) throws Exception {
        this.profile = profile;
        this.datasourcePane.setProfile(profile);
        this.wordManager = new DtsWordManagerImpl();
        List<EtcWord> wordList = XdtsWordStub.getInstance().getWordList(profile.getDataId());
        EtcWordUtil.setWordCollection(this.wordManager, wordList);
        this.profileTreePane.treeView.setProfile(profile, this.wordManager);
    }

    public void addTable(String tableName, int index) throws Exception {
        Tab tab = FxUtil.findTabByName(this.tabPane1, tableName);
        if (tab != null) {
            this.tabPane1.getSelectionModel().select((Object)tab);
            return;
        }
        XdtsTableInfoPane tableInfoPane = new XdtsTableInfoPane(this.profile, tableName, this.wordManager);
        tab = new Tab();
        tab.setText(XdtsUtil.apendLogicalName(this.wordManager, tableName));
        tab.setGraphic((Node)FxImageHelper.createImageView_icon("table_64x64.png"));
        tab.setContent((Node)tableInfoPane);
        if (index < 0) {
            this.tabPane1.getTabs().add((Object)tab);
            this.tabPane1.getSelectionModel().select((Object)tab);
        } else {
            this.tabPane1.getTabs().add(index, (Object)tab);
        }
    }

    public void reflesh(String tableName) throws Exception {
        Tab tab = FxUtil.findTabByName(this.tabPane1, tableName);
        if (tab == null) {
            return;
        }
        int index = this.tabPane1.getTabs().indexOf((Object)tab);
        Tab selectedTab = (Tab)this.tabPane1.getSelectionModel().getSelectedItem();
        boolean isSelected = tab == selectedTab;
        this.tabPane1.getTabs().remove((Object)tab);
        this.addTable(tab.getText(), index);
        if (isSelected) {
            tab = FxUtil.findTabByName(this.tabPane1, tableName);
            this.tabPane1.getSelectionModel().select((Object)tab);
        }
    }

    public void reflesh() throws Exception {
        ObservableList tabList = this.tabPane1.getTabs();
        int i = 0;
        while (i < tabList.size()) {
            Tab tab = (Tab)tabList.get(i);
            this.reflesh(tab.getText());
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.closeMenuItem) {
            this.closeAction(ev);
        } else if (ev.getSource() == this.sqlButton) {
            SqlConstants.DatabaseProduct databaseProduct = SqlConstants.DatabaseProduct.getById(this.profile.productId);
            XdtsCustomSql customSql = new XdtsCustomSql();
            XdtsDataViewPanel_Sql dataViewPanel = new XdtsDataViewPanel_Sql();
            dataViewPanel.setProfile(this.profile);
            dataViewPanel.setCustomSql(customSql);
            dataViewPanel.setTitle("SQL : " + this.profile.name + " [" + databaseProduct.productName + "]");
            dataViewPanel.init();
            dataViewPanel.showAsFrame();
        } else if (ev.getSource() == this.logicalNameButton) {
            XdtsLogicalNamePanel logicalNamePanel = new XdtsLogicalNamePanel();
            logicalNamePanel.showAsFrame(this.profile);
        } else if (ev.getSource() == this.dataImportButton) {
            XdtsDataImportWizard dataImportWizard = new XdtsDataImportWizard();
            dataImportWizard.show(this.profile, null);
        }
    }

    protected void closeAction(ActionEvent ev) throws Exception {
        this.close();
    }

    public void close() throws Exception {
        try {
            this.profileTreePane.destruct();
            XdtsProfileStub.getInstance().disconnect(this.profile.getDataId());
        }
        catch (Exception ex) {
            FxOptionPane.showMessageDialog((Window)this.stage, (Object)ex.toString(), BcWords.getInstance().error, 0);
        }
        this.stage.close();
        Object obj = BcInstanceManager.getInstance().remove(((Object)((Object)this)).getClass(), this.profile.getDataId());
    }

    protected void show(XdtsProfile profile, Window ownerWindow) throws Exception {
        this.setProfile(profile);
        this.init();
        this.setContents();
        this.createStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        this.stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XdtsProfilePane.this.close();
                }
                catch (Exception ex) {
                    XdtsProfilePane.this.handleException(ex);
                }
            }
        });
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                double leftWidth = 240.0;
                double ratio = leftWidth / XdtsProfilePane.this.splitPane.getWidth();
                XdtsProfilePane.this.splitPane.setDividerPositions(new double[]{ratio});
            }
        });
        this.stage.setResizable(true);
        this.stage.setTitle(profile.name);
        Image image = FxImageHelper.getImage("db_64x64.png");
        this.stage.getIcons().add((Object)image);
        FxUtil.setWindowCenter((Window)this.stage, 0.8f);
        this.stage.show();
    }

    public static void show2(int profileId, Window ownerWindow) throws Exception {
        XdtsProfilePane profilePane = (XdtsProfilePane)((Object)BcInstanceManager.getInstance().get(XdtsProfilePane.class, profileId));
        if (profilePane != null) {
            profilePane.stage.toFront();
            return;
        }
        XdtsProfile profile = null;
        profile = XdtsProfileStub.getInstance().connectByProfileId(profileId);
        profilePane = new XdtsProfilePane();
        BcInstanceManager.getInstance().put(profileId, (Object)profilePane);
        profilePane.show(profile, ownerWindow);
    }
}

