/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.log.BcLogUtil;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcWords;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.table.FxTableColumn;
import ext.lib.fx.table.FxTableUtil;
import ext.lib.fx.table.FxTableView;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.rmi.model.RmiRequest;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.XdtsProfileMenuPane;
import ext.module.xdts.fx.XdtsProfilePane;
import ext.module.xdts.fx.XdtsProfileWizard;
import ext.module.xdts.model.XdtsProfile;
import ext.module.xdts.rmo.XdtsProfileRMO;
import ext.module.xdts.stub.XdtsProfileStub;
import ext.scf4.fx.HfxLoadableTablePane;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XdtsProfileListPane
extends FxDecoratePane {
    InnerTablePane tablePane = new InnerTablePane();
    FxFlowPane controlPane = new FxFlowPane(22);
    FxButton addButton;
    FxButton editButton;
    FxButton deleteButton;
    FxButton connectionButton;
    FxButton closeButton;
    FxStage stage;
    Mode mode;
    int profileId;
    XdtsProfileMenuPane profileMenuPane;
    String[] tableColumnNames;

    public XdtsProfileListPane(Mode mode, XdtsProfileMenuPane profileMenuPane) throws Exception {
        this.addButton = new FxButton(BcWords.getInstance().add);
        this.editButton = new FxButton(BcWords.getInstance().edit);
        this.deleteButton = new FxButton(BcWords.getInstance().delete);
        this.connectionButton = new FxButton(BcWords.getInstance().connection);
        this.closeButton = new FxButton(BcWords.getInstance().close);
        this.tableColumnNames = new String[]{XdtsConstants.xdts_profile.group_.tableColumnName(), XdtsConstants.xdts_profile.name.tableColumnName()};
        this.mode = mode;
        this.profileMenuPane = profileMenuPane;
        this.setComponant();
    }

    protected void setComponant() throws Exception {
        this.addButton.setOnAction(this.actionEventHandler);
        this.addButton.setGraphic((Node)FxImageHelper.createImageView_icon("db_add_64x64.png"));
        FxNodeUnit nodeUnit = new FxNodeUnit(null, new Node[]{this.addButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.editButton.setOnAction(this.actionEventHandler);
        this.editButton.setGraphic((Node)FxImageHelper.createImageView_icon("db_gear_64x64.png"));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.editButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.deleteButton.setOnAction(this.actionEventHandler);
        this.deleteButton.setGraphic((Node)FxImageHelper.createImageView_icon("db_delete_64x64.png"));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.deleteButton});
        this.controlPane.addNodeUnit(nodeUnit);
        this.connectionButton.setOnAction(this.actionEventHandler);
        this.connectionButton.setGraphic((Node)FxImageHelper.createImageView_icon("db_connection_64x64.png"));
        nodeUnit = new FxNodeUnit(null, new Node[]{this.connectionButton});
        this.controlPane.addNodeUnit(nodeUnit);
        if (this.mode == Mode.defaullt) {
            this.closeButton.setOnAction(this.actionEventHandler);
            this.closeButton.setGraphic((Node)FxImageHelper.createImageView_icon("delete_64x64.png"));
            nodeUnit = new FxNodeUnit(null, new Node[]{this.closeButton});
            this.controlPane.addNodeUnit(nodeUnit);
        }
        this.controlPane.setPrefHeight(36.0);
        this.setBottom((Node)this.controlPane);
        this.setCenter((Node)this.tablePane);
        FxUtil.defaultInitialize((Node)this);
    }

    public void doLoad() throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsProfileRMO.class.getName());
        rmiReq.setMethodName(XdtsProfileRMO.Method.profileList.getMethodName());
        this.tablePane.doLoad(rmiReq);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.addButton) {
            XdtsProfileWizard profileWizard = new XdtsProfileWizard();
            XdtsProfile profile = new XdtsProfile();
            XdtsProfile profile2 = profileWizard.show(profile, this.getScene().getWindow());
            if (profile2 != null) {
                this.profileMenuPane.profileUpdated();
            }
        } else if (ev.getSource() == this.editButton) {
            XdtsProfile profile = XdtsProfileStub.getInstance().getProfile(this.profileId);
            BcLogUtil.debug("profile=" + profile);
            XdtsProfileWizard profileWizard = new XdtsProfileWizard();
            XdtsProfile profile2 = XdtsProfileWizard.show2(profile, this.getScene().getWindow());
            if (profile2 != null) {
                this.profileMenuPane.profileUpdated();
            }
        } else if (ev.getSource() == this.deleteButton) {
            XdtsProfile profile2;
            XdtsProfile profile = XdtsProfileStub.getInstance().getProfile(this.profileId);
            String msg = String.format("%s '%s' \u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", XdtsWords.getInstance().profile, profile.name);
            if (FxOptionPane.showConfirmDialog(this.getScene().getWindow(), (Object)msg, BcWords.getInstance().confirm, 3) == 0 && (profile2 = XdtsProfileStub.getInstance().deleteProfile(profile.getDataId())) != null) {
                this.profileMenuPane.profileUpdated();
            }
        } else if (ev.getSource() == this.connectionButton) {
            XdtsProfilePane.show2(this.profileId, null);
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    public boolean isSelectColumn(String tableColumnName) throws Exception {
        int i = 0;
        while (i < this.tableColumnNames.length) {
            if (this.tableColumnNames[i].equalsIgnoreCase(tableColumnName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void close() throws Exception {
        this.stage.close();
        this.profileMenuPane.profileListClosed();
    }

    protected void show() throws Exception {
        this.stage = new FxStage();
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene(scene);
        this.stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XdtsProfileListPane.this.close();
                }
                catch (Exception ex) {
                    XdtsProfileListPane.this.handleException(ex);
                }
            }
        });
        this.stage.setResizable(true);
        this.stage.setTitle(XdtsWords.getInstance().profileList);
        Image image = FxImageHelper.getImage("db_64x64.png");
        this.stage.getIcons().add((Object)image);
        FxUtil.setWindowLocation((Window)this.stage, 50.0, 50.0, 1200.0, 600.0);
        this.stage.show();
    }

    class InnerTablePane
    extends HfxLoadableTablePane {
        @Override
        protected void loadPreCommon() throws Exception {
            super.loadPreCommon();
            XdtsProfileListPane.this.editButton.setDisable(true);
            XdtsProfileListPane.this.deleteButton.setDisable(true);
            XdtsProfileListPane.this.connectionButton.setDisable(true);
        }

        @Override
        protected TableView createTableView() throws Exception {
            InnerTableView2 tableView = new InnerTableView2();
            tableView.setItems(FXCollections.observableArrayList());
            return tableView;
        }
    }

    class InnerTableView2
    extends FxTableView {
        public InnerTableView2() throws Exception {
            TableView.TableViewSelectionModel selectionModel = this.getSelectionModel();
            selectionModel.setSelectionMode(SelectionMode.SINGLE);
        }

        @Override
        public void rowSelected(FxTableView tableView, ObservableList<TablePosition> tablePositionList, MouseEvent ev, boolean doubleClicked) throws Exception {
            TablePosition tablePosition = BcCollectionUtil.getFirst(tablePositionList);
            XdtsProfileListPane.this.editButton.setDisable(true);
            XdtsProfileListPane.this.deleteButton.setDisable(true);
            XdtsProfileListPane.this.connectionButton.setDisable(true);
            if (tablePosition != null) {
                XdtsProfileListPane.this.profileId = (Integer)FxTableUtil.getCellValue((TableView)this, tablePosition.getRow(), XdtsConstants.xdts_profile.id.tableColumnName());
                XdtsProfileListPane.this.editButton.setDisable(false);
                XdtsProfileListPane.this.deleteButton.setDisable(false);
                XdtsProfileListPane.this.connectionButton.setDisable(false);
                if (doubleClicked) {
                    XdtsProfilePane.show2(XdtsProfileListPane.this.profileId, null);
                }
            }
        }

        @Override
        protected void columnChanged(ListChangeListener.Change change) throws Exception {
            super.columnChanged(change);
            if (XdtsProfileListPane.this.mode == Mode.select) {
                for (Object obj : XdtsProfileListPane.this.tablePane.getTableView().getColumns()) {
                    FxTableColumn tableColumn = (FxTableColumn)((Object)obj);
                    tableColumn.setVisible(XdtsProfileListPane.this.isSelectColumn(tableColumn.mmdField.tableColumnName));
                }
            }
        }
    }

    public static enum Mode {
        defaullt,
        select;

    }
}

