/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.core.BcBooleanUtil;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLoggableObject;
import ext.lib.fx.control.FxNumberField;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlWherecClauseSql;
import ext.libx.etc.model.EtcColumnCondition;
import ext.libx.fx.FxxPeriodPane;
import ext.libx.fx.FxxRadioButtonControl;
import ext.module.xdts.common.EtcSqlConditionUtil;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.fx.XdtsControlUnit;
import ext.module.xdts.fx.XdtsFxCondition;
import ext.module.xdts.fx.XdtsSelectColumnPane;
import ext.module.xdts.model.XdtsControlContext;
import ext.module.xdts.model.XdtsUserSetting;
import ext.module.xdts.model.v0001.XdtsExtractionCondition;
import ext.module.xdts.model.v0001.XdtsSelectColumn;
import ext.module.xdts.model.v0001.XdtsSelectContext;
import ext.module.xdts.model.v0001.XdtsSelectElemet;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextInputControl;

public class XdtsFxToConditionModel
extends BcLoggableObject {
    public void storeData(SqlContext sqlContext, XdtsExtractionCondition extractionCondition, XdtsFxCondition fxCondition, XdtsUserSetting userSetting) throws Exception {
        int i = 0;
        while (i < extractionCondition.selectContextList.size()) {
            XdtsSelectContext selectContext = extractionCondition.selectContextList.get(i);
            List<XdtsControlUnit> controlUnitList1 = fxCondition.controlUnitMap1.get(selectContext.id);
            this.storeData_L2(sqlContext, selectContext, controlUnitList1, userSetting);
            ++i;
        }
    }

    public void storeData_L2(SqlContext sqlContext, XdtsSelectContext selectContext, Collection<XdtsControlUnit> controlUnitCollection, XdtsUserSetting userSetting) throws Exception {
        selectContext.wherecClauseSql = new SqlWherecClauseSql();
        for (XdtsControlUnit controlUnit : controlUnitCollection) {
            Node controlNode = controlUnit.nodeUnit.getRightNodeList().get(0);
            this.storeData_L3(sqlContext, selectContext, controlUnit.controlContext, controlNode, userSetting);
        }
    }

    public void storeData_L3(SqlContext sqlContext, XdtsSelectContext selectContext, XdtsControlContext controlContext, Node controlNode, XdtsUserSetting userSetting) throws Exception {
        if (controlContext.contextType == XdtsConstants.ContextType.Select) {
            XdtsSelectColumnPane selectColumnPane = (XdtsSelectColumnPane)controlNode;
            selectContext.selectColumnList.clear();
            int i = 0;
            while (i < selectColumnPane.tableModel.getRowCount()) {
                XdtsSelectColumn selectColumn = new XdtsSelectColumn();
                selectColumn.tableColumnName = new XdtsSelectElemet();
                selectColumn.tableColumnName.template = (String)selectColumnPane.tableModel.getValueAt(i, 0);
                selectColumn.alias = (String)selectColumnPane.tableModel.getValueAt(i, 1);
                selectColumn.order = (Integer)selectColumnPane.tableModel.getValueAt(i, 2);
                selectContext.selectColumnList.add(selectColumn);
                ++i;
            }
        } else if (controlContext.contextType == XdtsConstants.ContextType.From) {
            TextInputControl textInputControl = (TextInputControl)controlNode;
            XdtsSelectElemet elemet = new XdtsSelectElemet();
            elemet.template = textInputControl.getText();
            selectContext.from = elemet;
        } else if (controlContext.contextType == XdtsConstants.ContextType.Where) {
            TextInputControl textInputControl = (TextInputControl)controlNode;
            selectContext.whereBase.template = textInputControl.getText();
        } else if (controlContext.contextType == XdtsConstants.ContextType.OrderBy) {
            TextInputControl textInputControl = (TextInputControl)controlNode;
            selectContext.orderBy = textInputControl.getText();
        } else if (controlContext.contextType == XdtsConstants.ContextType.RowLimit) {
            FxNumberField numberField = (FxNumberField)controlNode;
            selectContext.rowLimit = -1L;
            if (numberField.getBigDecimal() != null && numberField.getBigDecimal().longValue() >= 0L) {
                selectContext.rowLimit = numberField.getBigDecimal().longValue();
                controlContext.inputValueList.add(Long.toString(selectContext.rowLimit));
            }
        } else if (controlContext.contextType == XdtsConstants.ContextType.General) {
            EtcColumnCondition columnCondition = this.createColumnCondition(controlContext, controlNode);
            controlContext.inputValueList.add(columnCondition.value);
            EtcSqlConditionUtil.createWhereClause_L2(sqlContext, selectContext.wherecClauseSql, columnCondition);
            if (userSetting != null) {
                userSetting.addEntry(controlContext.name, BcStringUtil.toString(columnCondition.value));
            }
        }
    }

    public EtcColumnCondition createColumnCondition(XdtsControlContext controlContext, Node controlNode) throws Exception {
        EtcColumnCondition columnCondition = new EtcColumnCondition();
        columnCondition.tableColumnName = controlContext.tableColumnName;
        columnCondition.sqlTypeId = controlContext.sqlTypeId;
        columnCondition.isAnd = controlContext.isAnd;
        columnCondition.patternMatch = controlContext.patternMatch;
        this.createColumnCondition_L2(columnCondition, controlNode);
        return columnCondition;
    }

    public void createColumnCondition_L2(EtcColumnCondition columnCondition, Node controlNode) throws Exception {
        if (controlNode instanceof TextInputControl) {
            TextInputControl textInputControl = (TextInputControl)controlNode;
            columnCondition.value = textInputControl.getText();
        } else if (controlNode instanceof ComboBox) {
            ComboBox comboBox = (ComboBox)controlNode;
            Object value = comboBox.getValue();
            columnCondition.value = BcStringUtil.toString(value);
        } else if (controlNode instanceof FxxPeriodPane) {
            FxxPeriodPane periodPane = (FxxPeriodPane)controlNode;
            Calendar calendar = periodPane.dateTimePane1.getCalendar();
            columnCondition.value = BcTimeUtil.toString(calendar, "yyyy/MM/dd");
        } else if (controlNode instanceof FxxRadioButtonControl) {
            FxxRadioButtonControl radioButtonControl = (FxxRadioButtonControl)controlNode;
            String strValue = radioButtonControl.getInputText();
            columnCondition.value = null;
            if (!BcStringUtil.isEmpty(strValue)) {
                Boolean bool = BcBooleanUtil.parseBoolean(strValue, false);
                columnCondition.value = bool.toString();
            }
        }
    }
}

