/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.util.BcWords;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxComboBox;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxPasswordField;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import ext.lib.sql.SqlWords;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.XdtsProfileSelectPane;
import ext.module.xdts.model.XdtsProfile;
import java.io.File;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.stage.FileChooser;

public class XdtsDatasourcePane
extends FxBorderPane {
    protected Mode mode;
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField nameTextField = new FxTextField();
    FxTextField driverTextField = new FxTextField();
    FxComboBox<String> driverComboBox = new FxComboBox();
    FxTextField urlTextField = new FxTextField();
    FxComboBox<String> urlComboBox = new FxComboBox();
    FxTextField userTextField = new FxTextField();
    FxPasswordField passwordField = new FxPasswordField();
    FxTextField groupTextField = new FxTextField();
    FxTextField noteTextField = new FxTextField();
    FxTextField driverFilePathField = new FxTextField();
    FxButton fileBrowsButton = new FxButton("", (Node)FxImageHelper.createImageView_icon("find_64x64.png"));
    FileChooser fileChooser = new FileChooser();
    FxButton profileBrowsButton = new FxButton("", (Node)FxImageHelper.createImageView_icon("find_64x64.png"));
    XdtsProfile profile;

    public XdtsDatasourcePane(Mode mode) throws Exception {
        this.mode = mode;
        this.setCenter((Node)this.centerPane);
        switch (mode) {
            case edit: {
                this.setComponant_edit();
                break;
            }
            case destination: {
                this.setComponant_edit();
                break;
            }
            case display: {
                this.setComponant_display();
                break;
            }
            case displaySimple: {
                this.setComponant_display_simple();
            }
        }
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setComponant_edit() throws Exception {
        this.nameTextField.setPrefColumnCount(80);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().profileName), new Node[]{this.nameTextField});
        if (this.mode == Mode.destination) {
            this.profileBrowsButton.setOnAction(this.actionEventHandler);
            nodeUnit.addRightNodes(new Node[]{this.profileBrowsButton});
            this.nameTextField.setEditable(false);
        }
        this.centerPane.addNodeUnit(nodeUnit);
        this.driverComboBox.columnCount.set(100);
        this.driverComboBox.setEditable(true);
        this.driverComboBox.getItems().add((Object)"org.h2.Driver");
        this.driverComboBox.getItems().add((Object)"org.postgresql.Driver");
        this.driverComboBox.getItems().add((Object)"com.mysql.jdbc.Driver");
        this.driverComboBox.getItems().add((Object)"com.microsoft.sqlserver.jdbc.SQLServerDriver");
        this.driverComboBox.getItems().add((Object)"oracle.jdbc.driver.OracleDriver");
        this.driverComboBox.getItems().add((Object)"sun.jdbc.odbc.JdbcOdbcDriver");
        nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().driver), new Node[]{this.driverComboBox});
        this.centerPane.addNodeUnit(nodeUnit);
        this.urlComboBox.columnCount.set(100);
        this.urlComboBox.setEditable(true);
        this.urlComboBox.getItems().add((Object)"jdbc:h2:file:C:\\hoge");
        this.urlComboBox.getItems().add((Object)"jdbc:postgresql://localhost/hoge");
        this.urlComboBox.getItems().add((Object)"jdbc:mysql://localhost:3306/hoge");
        this.urlComboBox.getItems().add((Object)"jdbc:sqlserver://localhost;databaseName=hoge");
        this.urlComboBox.getItems().add((Object)"jdbc:oracle:thin:@");
        this.urlComboBox.getItems().add((Object)"jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=");
        nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().jdbcUrl), new Node[]{this.urlComboBox});
        this.centerPane.addNodeUnit(nodeUnit);
        this.userTextField.setPrefColumnCount(40);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().user), new Node[]{this.userTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.passwordField.setPrefColumnCount(40);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().password), new Node[]{this.passwordField});
        nodeUnit.arrangement = 1;
        this.centerPane.addNodeUnit(nodeUnit);
        this.driverFilePathField.setPrefColumnCount(100);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().\u30c9\u30e9\u30a4\u30d0\u30d5\u30a1\u30a4\u30eb), new Node[]{this.driverFilePathField});
        this.fileBrowsButton.setOnAction(this.actionEventHandler);
        nodeUnit.addRightNodes(new Node[]{this.fileBrowsButton});
        this.centerPane.addNodeUnit(nodeUnit);
        if (this.mode == Mode.edit) {
            this.groupTextField.setPrefColumnCount(40);
            nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().group), new Node[]{this.groupTextField});
            this.centerPane.addNodeUnit(nodeUnit);
            this.noteTextField.setPrefColumnCount(100);
            nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().note), new Node[]{this.noteTextField});
            this.centerPane.addNodeUnit(nodeUnit);
        }
        if (this.mode == Mode.edit) {
            this.setPrefSize(620.0, 160.0);
        }
        if (this.mode == Mode.destination) {
            this.setPrefSize(860.0, 140.0);
        }
    }

    protected void setComponant_display() throws Exception {
        this.nameTextField.setPrefColumnCount(40);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().profileName), new Node[]{this.nameTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.urlTextField.setPrefColumnCount(80);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().jdbcUrl), new Node[]{this.urlTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.userTextField.setPrefColumnCount(20);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().user), new Node[]{this.userTextField});
        this.groupTextField.setPrefColumnCount(20);
        nodeUnit.addRightNodes(new Node[]{new FxLabel(BcWords.getInstance().group), this.groupTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.noteTextField.setPrefColumnCount(80);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().note), new Node[]{this.noteTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setPrefSize(680.0, 110.0);
    }

    protected void setComponant_display_simple() throws Exception {
        this.nameTextField.setPrefColumnCount(40);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().profileName), new Node[]{this.nameTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.urlTextField.setPrefColumnCount(60);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().jdbcUrl), new Node[]{this.urlTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.userTextField.setPrefColumnCount(20);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().user), new Node[]{this.userTextField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setPrefSize(560.0, 80.0);
    }

    public XdtsProfile getProfile() throws Exception {
        return this.profile;
    }

    public void setProfile(XdtsProfile profile) throws Exception {
        this.profile = profile;
        if (profile == null) {
            this.nameTextField.setText(null);
            this.driverTextField.setText(null);
            this.driverComboBox.setValue(null);
            this.urlTextField.setText(null);
            this.urlComboBox.setValue(null);
            this.userTextField.setText(null);
            this.passwordField.setText(null);
            this.groupTextField.setText(null);
            this.noteTextField.setText(null);
            this.driverFilePathField.setText(null);
        } else {
            this.nameTextField.setText(profile.name);
            this.driverTextField.setText(profile.driver);
            this.driverComboBox.setValue(profile.driver);
            this.urlTextField.setText(profile.url);
            this.urlComboBox.setValue(profile.url);
            this.userTextField.setText(profile.user);
            this.passwordField.setText(profile.password);
            this.groupTextField.setText(profile.group);
            this.noteTextField.setText(profile.note);
            this.driverFilePathField.setText(profile.driverFilePath);
        }
    }

    public void storeData(XdtsProfile profile) throws Exception {
        profile.name = this.nameTextField.getText();
        profile.driver = (String)this.driverComboBox.getValue();
        profile.url = (String)this.urlComboBox.getValue();
        profile.user = this.userTextField.getText();
        profile.password = this.passwordField.getText();
        profile.group = this.groupTextField.getText();
        profile.note = this.noteTextField.getText();
        profile.driverFilePath = this.driverFilePathField.getText();
    }

    public void storeData() throws Exception {
        this.storeData(this.profile);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        XdtsProfileSelectPane profileSelectPane;
        XdtsProfile profile2;
        super.actionPerformed(ev);
        if (ev.getSource() == this.fileBrowsButton) {
            FxUtil.initFileChooser(this.fileChooser, this.driverFilePathField.getText());
            File file = this.fileChooser.showOpenDialog(this.getScene().getWindow());
            if (file != null) {
                this.driverFilePathField.setText(file.getPath());
            }
        } else if (ev.getSource() == this.profileBrowsButton && (profile2 = (profileSelectPane = new XdtsProfileSelectPane()).show(this.getScene().getWindow())) != null) {
            this.setProfile(profile2);
        }
    }

    public static enum Mode {
        edit(1),
        destination(2),
        display(21),
        displaySimple(22);

        public final int id;

        private Mode(int id) {
            this.id = id;
        }
    }
}

