/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.core.BcStringUtil;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxCheckBox;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextArea;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.util.FxUtil;
import ext.lib.sql.SqlWords;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.XdtsCommitModeComboBox;
import ext.module.xdts.fx.XdtsProductComboBox;
import ext.module.xdts.model.XdtsProcessCondition;
import ext.scf5.model.ZScfIntProperties;
import ext.scf5.stub.ScfPropertyStub;
import java.io.File;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

class XdtsAbstractConditionPane
extends FxBorderPane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField destFilePathField = new FxTextField();
    FxButton destFileChooseButton = FxUtil.createBrowsButton(null);
    FxTextField destDirPathField = new FxTextField();
    FxButton destDirChooseButton = FxUtil.createBrowsButton(null);
    FxTextField errorFilePathField = new FxTextField();
    FxButton errorFileChooseButton = FxUtil.createBrowsButton(null);
    FileChooser fileChooser = new FileChooser();
    DirectoryChooser directoryChooser = new DirectoryChooser();
    FxCheckBox executeQueryCheckBox = new FxCheckBox();
    XdtsCommitModeComboBox commitModeComboBox = new XdtsCommitModeComboBox();
    FxCheckBox ignoreExceptionCheckBox = new FxCheckBox();
    FxCheckBox recreateTableCheckBox = new FxCheckBox();
    FxCheckBox truncateCheckBox = new FxCheckBox();
    FxCheckBox copyRowsCheckBox = new FxCheckBox();
    FxTextArea conditionTextArea = new FxTextArea();
    XdtsProductComboBox productComboBox = new XdtsProductComboBox();
    FxTextField newTableNameField = new FxTextField("${tableName}");
    Stage stage;

    public XdtsAbstractConditionPane(Stage stage) throws Exception {
        this.stage = stage;
        this.setCenter((Node)this.centerPane);
        this.executeQueryCheckBox.setOnAction(this.actionEventHandler);
        this.executeQueryCheckBox.setSelected(true);
    }

    protected void setDestFile() throws Exception {
        this.destFilePathField.setPrefColumnCount(100);
        this.destFileChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().sqlOutputFile), new Node[]{this.destFilePathField, this.destFileChooseButton});
        this.centerPane.addNodeUnit(nodeUnit);
        String propVal = ScfPropertyStub.getInstance().getProperty(XdtsConstants.TableName.xdts_property.name(), 1011);
        File destFile = null;
        destFile = BcStringUtil.isEmpty(propVal) ? new File(System.getProperty("user.home"), "rydeen_sql.txt") : new File(propVal);
        this.destFilePathField.setText(destFile.getPath());
    }

    protected void setDestDir() throws Exception {
        this.destDirPathField.setPrefColumnCount(100);
        this.destDirChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().sqlOutputDir), new Node[]{this.destDirPathField, this.destDirChooseButton});
        this.centerPane.addNodeUnit(nodeUnit);
        String propVal = ScfPropertyStub.getInstance().getProperty(XdtsConstants.TableName.xdts_property.name(), 1012);
        File destFile = null;
        destFile = BcStringUtil.isEmpty(propVal) ? new File(System.getProperty("user.home")) : new File(propVal);
        this.destDirPathField.setText(destFile.getPath());
    }

    protected void setErrorFile() throws Exception {
        this.errorFilePathField.setPrefColumnCount(100);
        this.errorFileChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().exceptionOutputFile), new Node[]{this.errorFilePathField, this.errorFileChooseButton});
        this.centerPane.addNodeUnit(nodeUnit);
        String propVal = ScfPropertyStub.getInstance().getProperty(XdtsConstants.TableName.xdts_property.name(), 1031);
        File destFile = null;
        destFile = BcStringUtil.isEmpty(propVal) ? new File(System.getProperty("user.home"), "rydeen_error.txt") : new File(propVal);
        this.errorFilePathField.setText(destFile.getPath());
    }

    protected void setExecuteSql() throws Exception {
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().executeSql), new Node[]{this.executeQueryCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
    }

    protected void setCommitMode() throws Exception {
        this.commitModeComboBox.getSelectionModel().select(0);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().commitMode), new Node[]{this.commitModeComboBox});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().ignoreSqlException), new Node[]{this.ignoreExceptionCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
    }

    protected void setRowCopyOption() throws Exception {
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().recreateTable), new Node[]{this.recreateTableCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().sql_TRUNCATE), new Node[]{this.truncateCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().copyRows), new Node[]{this.copyRowsCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
    }

    protected void setTargetProdct() throws Exception {
        this.productComboBox.getSelectionModel().select(0);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().targetProduct), new Node[]{this.productComboBox});
        this.centerPane.addNodeUnit(nodeUnit);
    }

    protected void storeCondition(XdtsProcessCondition processCondition) throws Exception {
        processCondition.destFilePath = this.destFilePathField.getText();
        processCondition.destDirPath = this.destDirPathField.getText();
        processCondition.errorFilePath = this.errorFilePathField.getText();
        processCondition.executeQuery = this.executeQueryCheckBox.isSelected();
        processCondition.commitMode = this.commitModeComboBox.getCommitMode();
        processCondition.recreateTable = this.recreateTableCheckBox.isSelected();
        processCondition.truncateTable = this.truncateCheckBox.isSelected();
        processCondition.copyRows = this.copyRowsCheckBox.isSelected();
        processCondition.iqnoreException = this.ignoreExceptionCheckBox.isSelected();
        processCondition.sql = this.conditionTextArea.getText();
        processCondition.databaseProduct = this.productComboBox.getDatabaseProduct();
        processCondition.newTableName = this.newTableNameField.getText();
        ZScfIntProperties intProps = new ZScfIntProperties();
        intProps.put((Integer)1011, this.destFilePathField.getText());
        intProps.put((Integer)1012, this.destDirPathField.getText());
        intProps.put((Integer)1031, this.errorFilePathField.getText());
        ScfPropertyStub.getInstance().putProperties(XdtsConstants.TableName.xdts_property.name(), intProps);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource().hashCode() == ((Object)((Object)this.destFileChooseButton)).hashCode()) {
            FxUtil.initFileChooser(this.fileChooser, this.destFilePathField.getText());
            File file = this.fileChooser.showSaveDialog((Window)this.stage);
            if (file != null) {
                this.destFilePathField.setText(file.getPath());
            }
        } else if (ev.getSource().hashCode() == ((Object)((Object)this.destDirChooseButton)).hashCode()) {
            FxUtil.initDirectoryChooser(this.directoryChooser, this.destDirPathField.getText());
            File file = this.directoryChooser.showDialog((Window)this.stage);
            if (file != null) {
                this.destDirPathField.setText(file.getPath());
            }
        } else if (ev.getSource().hashCode() == ((Object)((Object)this.errorFileChooseButton)).hashCode()) {
            FxUtil.initFileChooser(this.fileChooser, this.errorFilePathField.getText());
            File file = this.fileChooser.showSaveDialog((Window)this.stage);
            if (file != null) {
                this.errorFilePathField.setText(file.getPath());
            }
        } else if (ev.getSource().hashCode() == ((Object)((Object)this.executeQueryCheckBox)).hashCode()) {
            this.commitModeComboBox.setDisable(!this.executeQueryCheckBox.isSelected());
        }
    }
}

