/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.common;

import ext.base.core.BcBooleanUtil;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.base.mmd.MmdIndexElement;
import ext.base.mmd.MmdUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.util.DtsWordManager;
import ext.lib.poi.PoiWorkbookUtil;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.context.SqlTableMetadata;
import ext.module.xdts.common.XdtsUtil;
import ext.module.xmmd.model.XmmdField;
import ext.module.xmmd.model.XmmdIndex;
import ext.module.xmmd.model.XmmdModel;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class XdtsDefinitionCreator
extends BcLoggableObject {
    public static final String TAG_tableName = "${tableName}";
    public static final String TAG_tableLogicalName = "${tableLogicalName}";
    public static final String TAG_tableRemark = "${tableRemark}";
    public static final String TAG_schemaName = "${schemaName}";
    public static final String TAG_ordinalPosition = "${ordinalPosition}";
    public static final String TAG_columnName = "${columnName}";
    public static final String TAG_dataType = "${dataType}";
    public static final String TAG_dataSize = "${dataSize}";
    public static final String TAG_decimalDigit = "${decimalDigit}";
    public static final String TAG_nullable = "${nullable}";
    public static final String TAG_columnLogicalName = "${columnLogicalName}";
    public static final String TAG_note = "${note}";
    public static final String TAG_indexName = "${indexName}";
    public static final String TAG_indexIsUnique = "${indexIsUnique}";
    public static final String TAG_isPrimaryIndex = "${isPrimaryIndex}";
    public static final String TAG_indexColumnOrdinalPosition = "${indexColumnOrdinalPosition}";
    public static final String TAG_indexColumnName = "${indexColumnName}";
    public static final String TAG_isAscending = "${isAscending}";
    public static final String TAG_createDate = "${createDate}";
    protected DtsWordManager wordManager;
    protected Map<String, SqlTableMetadata> tableMetadataMap;
    String templateSheetName = "TEMPLATE";

    public void create(List<XmmdModel> xmmdList, DtsWordManager wordManager, Map<String, SqlTableMetadata> tableMetadataMap, Workbook workbook) throws Exception {
        this.wordManager = wordManager;
        this.tableMetadataMap = tableMetadataMap;
        boolean isSuccess = false;
        int i = 0;
        while (i < xmmdList.size()) {
            int cnt = i + 1;
            if (cnt % 100 == 0) {
                BcLogUtil.info("cnt=" + cnt);
            }
            XmmdModel xmmd = xmmdList.get(i);
            this.create_L2(xmmd, workbook);
            ++i;
        }
        workbook.removeSheetAt(workbook.getSheetIndex(this.templateSheetName));
    }

    protected void create_L2(XmmdModel xmmdModel, Workbook workbook) throws Exception {
        this.msg("\u30c6\u30fc\u30d6\u30eb\u540d=" + xmmdModel.tableName);
        Sheet templeteHssfSheet = workbook.getSheet(this.templateSheetName);
        int templeteSheetIndex = workbook.getSheetIndex(this.templateSheetName);
        Sheet sheet = PoiWorkbookUtil.cloneSheet(workbook, templeteSheetIndex);
        PoiWorkbookUtil.setSheetName(sheet, xmmdModel.tableName, true);
        PoiWorkbookUtil.replaceText(sheet, TAG_tableName, xmmdModel.tableName);
        String logicalName = this.wordManager.getWord(xmmdModel.tableName, Locale.getDefault().getLanguage());
        PoiWorkbookUtil.replaceText(sheet, TAG_tableLogicalName, logicalName);
        PoiWorkbookUtil.replaceText(sheet, TAG_tableRemark, xmmdModel.note);
        SqlTableMetadata tableMetadata = this.getTableMetadata(xmmdModel.tableName);
        PoiWorkbookUtil.replaceText(sheet, TAG_schemaName, tableMetadata.TABLE_SCHEM);
        Cell cell_ordinalPosition = PoiWorkbookUtil.findCell(sheet, (Object)TAG_ordinalPosition);
        if (cell_ordinalPosition != null) {
            Row row_templete_columnOrdinalPosition = sheet.getRow(cell_ordinalPosition.getRowIndex());
            int i = 0;
            while (i < xmmdModel.getFieldCount()) {
                XmmdField xmmdField = xmmdModel.getField(i);
                this.create_L3(xmmdModel, xmmdField, sheet, row_templete_columnOrdinalPosition);
                ++i;
            }
            this.msg("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u884c\u3092\u524a\u9664\u4e2d...");
            PoiWorkbookUtil.removeRow(sheet, row_templete_columnOrdinalPosition.getRowNum());
        }
        this.createIndexInfo(xmmdModel, sheet);
        Calendar now = BcTimeUtil.createCalendar();
        String dateStr = BcTimeUtil.toString(now, "yyyy/MM/dd");
        PoiWorkbookUtil.replaceText(sheet, TAG_createDate, dateStr);
    }

    protected void create_L3(XmmdModel xmmd, XmmdField xmmdField, Sheet sheet, Row row_templete_columnOrdinalPosition) throws Exception {
        int rowId = row_templete_columnOrdinalPosition.getRowNum() + xmmdField.ordinalPosition;
        Row ssRow2 = PoiWorkbookUtil.insertRow(sheet, rowId);
        PoiWorkbookUtil.copyRow(sheet, row_templete_columnOrdinalPosition, ssRow2, false);
        PoiWorkbookUtil.replaceText(ssRow2, TAG_ordinalPosition, Integer.toString(xmmdField.ordinalPosition));
        PoiWorkbookUtil.replaceText(ssRow2, TAG_columnName, xmmdField.columnName);
        SqlConstants.SqlType sqlType = SqlConstants.SqlType.getById(xmmdField.sqlTypeId);
        PoiWorkbookUtil.replaceText(ssRow2, TAG_dataType, sqlType.name());
        String dataSizeStr = null;
        dataSizeStr = BcNumberUtil.toString(xmmdField.dataSize);
        if (sqlType == SqlConstants.SqlType.NUMERIC) {
            dataSizeStr = String.valueOf(dataSizeStr) + ",";
            dataSizeStr = String.valueOf(dataSizeStr) + Integer.toString(xmmdField.decimalDigit);
        }
        PoiWorkbookUtil.replaceText(ssRow2, TAG_dataSize, dataSizeStr);
        PoiWorkbookUtil.replaceText(ssRow2, TAG_nullable, BcBooleanUtil.toYN(xmmdField.nullable));
        String logicalName = XdtsUtil.getLogicalName(xmmd.logicalName, xmmdField, this.wordManager);
        PoiWorkbookUtil.replaceText(ssRow2, TAG_columnLogicalName, logicalName);
        PoiWorkbookUtil.replaceText(ssRow2, TAG_note, xmmdField.note);
    }

    protected Map<String, Integer> createIndexMap(XmmdModel xmmd, XmmdIndex xmmdIndex) throws Exception {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < xmmdIndex.indexElementList.size()) {
            MmdIndexElement indexElement = xmmdIndex.indexElementList.get(i);
            String tableColumnName = MmdUtil.createTableColumnName(xmmd.logicalName, indexElement.columnName);
            indexMap.put(tableColumnName, i + 1);
            ++i;
        }
        return indexMap;
    }

    protected void createIndexInfo(XmmdModel xmmdModel, Sheet sheet) throws Exception {
        Cell cell1 = PoiWorkbookUtil.findCell(sheet, (Object)TAG_indexName);
        if (cell1 == null) {
            this.getLogger().debug("Not found ${indexName}");
            return;
        }
        Row row_templete_indexName = cell1.getRow();
        Cell cell2 = PoiWorkbookUtil.findCell(sheet, (Object)TAG_indexColumnOrdinalPosition);
        if (cell2 == null) {
            this.getLogger().debug("Not found ${indexColumnOrdinalPosition}");
            return;
        }
        Row row_templete_indexColumnOrdinalPosition = cell2.getRow();
        int gap = row_templete_indexColumnOrdinalPosition.getRowNum() - row_templete_indexName.getRowNum() - 1;
        if (gap < 0) {
            this.getLogger().debug("gap=" + gap);
            return;
        }
        int rowId_insert = row_templete_indexColumnOrdinalPosition.getRowNum() + 1;
        for (Map.Entry<String, XmmdIndex> mapEntry : xmmdModel.indexNameMap.entrySet()) {
            XmmdIndex xmmdIndex = mapEntry.getValue();
            boolean isPrimaryIndex = false;
            if (!BcStringUtil.isEmpty(xmmdModel.primaryIndexName)) {
                isPrimaryIndex = xmmdModel.primaryIndexName.equalsIgnoreCase(xmmdIndex.indexName);
            }
            int rowCount = this.createIndexInfo(xmmdIndex, isPrimaryIndex, sheet, row_templete_indexName, row_templete_indexColumnOrdinalPosition, rowId_insert);
            rowId_insert += rowCount;
            ++rowId_insert;
        }
        PoiWorkbookUtil.removeRow(sheet, row_templete_indexName.getRowNum(), row_templete_indexColumnOrdinalPosition.getRowNum());
    }

    protected int createIndexInfo(XmmdIndex xmmdIndex, boolean isPrimaryIndex, Sheet sheet, Row row_templete_indexName, Row row_templete_indexColumnOrdinalPosition, int rowId_insert) throws Exception {
        List<Row> rowList1 = PoiWorkbookUtil.copyInsertRow(sheet, row_templete_indexName.getRowNum(), row_templete_indexColumnOrdinalPosition.getRowNum() - 1, rowId_insert, true);
        Row row_indexName = BcCollectionUtil.getFirst(rowList1);
        PoiWorkbookUtil.replaceText(row_indexName, TAG_indexName, xmmdIndex.indexName);
        PoiWorkbookUtil.replaceText(row_indexName, TAG_indexIsUnique, BcBooleanUtil.toYN(xmmdIndex.isUnique));
        PoiWorkbookUtil.replaceText(row_indexName, TAG_isPrimaryIndex, BcBooleanUtil.toYN(isPrimaryIndex));
        int gap = row_templete_indexColumnOrdinalPosition.getRowNum() - row_templete_indexName.getRowNum() - 1;
        int i = 0;
        while (i < xmmdIndex.indexElementList.size()) {
            MmdIndexElement mmdIndexElement = xmmdIndex.indexElementList.get(i);
            String msg = " ordinalPosition=" + mmdIndexElement.ordinalPosition + "  columnName=" + mmdIndexElement.columnName + " isAscending=" + mmdIndexElement.isAscending;
            this.msg(msg);
            int rowId = row_indexName.getRowNum() + gap + mmdIndexElement.ordinalPosition;
            Row ssRow2 = PoiWorkbookUtil.copyInsertRow(sheet, row_templete_indexColumnOrdinalPosition.getRowNum(), rowId, false);
            PoiWorkbookUtil.replaceText(ssRow2, TAG_indexColumnOrdinalPosition, Integer.toString(mmdIndexElement.ordinalPosition));
            PoiWorkbookUtil.replaceText(ssRow2, TAG_indexColumnName, mmdIndexElement.columnName);
            PoiWorkbookUtil.replaceText(ssRow2, TAG_isAscending, BcBooleanUtil.toYN(mmdIndexElement.isAscending));
            ++i;
        }
        return rowList1.size() + xmmdIndex.indexElementList.size();
    }

    protected SqlTableMetadata getTableMetadata(String tableName) throws Exception {
        SqlTableMetadata tableMetadata = null;
        if (this.tableMetadataMap != null) {
            tableMetadata = this.tableMetadataMap.get(tableName);
        }
        if (tableMetadata == null) {
            tableMetadata = new SqlTableMetadata();
        }
        return tableMetadata;
    }

    protected void msg(String msg) throws Exception {
        this.getLogger().debug(msg);
    }
}

