/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.common;

import ext.base.core.BcBooleanUtil;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdIndexElement;
import ext.base.mmd.MmdModel;
import ext.base.mmd.MmdUtil;
import ext.lib.sql.SqlConditionParser;
import ext.lib.sql.SqlConditionSpliter;
import ext.lib.sql.SqlConditionUtil;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.lib.sql.model.SqlWherecClauseSql;
import ext.libx.etc.model.EtcColumnCondition;
import ext.libx.etc.model.EtcGeneralCondition;
import java.util.List;

public class EtcSqlConditionUtil {
    private EtcSqlConditionUtil() throws Exception {
    }

    public static String createIndex(MmdIndex mmdIndex) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < mmdIndex.indexElementList.size()) {
            MmdIndexElement indexElement = mmdIndex.indexElementList.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(indexElement.columnName);
            if (!indexElement.isAscending) {
                sb.append(" DESC");
            }
            ++i;
        }
        return sb.toString();
    }

    public static SqlSelectSql createSelectSql(SqlContext sqlContext, MmdModel mmdModel) throws Exception {
        SqlSelectSql selectSql = new SqlSelectSql();
        List<String> tableColumnNameList = MmdUtil.toTableColumnNameList(mmdModel);
        BcLogUtil.debug("tableColumnNameList=" + tableColumnNameList);
        selectSql.getSelectColumnList().addAll(tableColumnNameList);
        selectSql.setFromClause(mmdModel.tableName);
        selectSql.rowLimit = 100;
        return selectSql;
    }

    public static EtcGeneralCondition createCondition(MmdModel mmdModel) throws Exception {
        EtcGeneralCondition condition = new EtcGeneralCondition();
        MmdIndex primaryKey = mmdModel.getPrimaryIndex();
        if (primaryKey != null) {
            condition.orderByColumnNames = EtcSqlConditionUtil.createIndex(primaryKey);
        }
        return condition;
    }

    public static SqlSelectSql createSelectSql(SqlContext sqlContext, EtcGeneralCondition generalCondition) throws Exception {
        SqlSelectSql selectSql = new SqlSelectSql();
        selectSql.getSelectColumnList().addAll(generalCondition.tableColumnNameList);
        selectSql.setFromClause(generalCondition.fromClause);
        EtcSqlConditionUtil.createWhereClause(sqlContext, selectSql, generalCondition);
        if (!BcStringUtil.isEmpty(generalCondition.orderByColumnNames)) {
            List<String> tokenList = BcStringUtil.stringTokenize((CharSequence)generalCondition.orderByColumnNames, BcStringUtil.COMMA_STR, true, true);
            selectSql.getOrderByList().addAll(tokenList);
        }
        if (generalCondition.rowLimit >= 0) {
            selectSql.rowOffset = 0;
            selectSql.rowLimit = generalCondition.rowLimit;
        }
        return selectSql;
    }

    public static void createWhereClause(SqlContext sqlContext, SqlSelectSql selectSql, EtcGeneralCondition generalCondition) throws Exception {
        for (EtcColumnCondition columnCondition : generalCondition.columnConditionList) {
            if (BcStringUtil.isEmpty(columnCondition.value)) continue;
            EtcSqlConditionUtil.createWhereClause_L2(sqlContext, selectSql, columnCondition);
        }
    }

    public static void createWhereClause_L2(SqlContext sqlContext, SqlWherecClauseSql wherecClauseSql, EtcColumnCondition columnCondition) throws Exception {
        if (BcStringUtil.isEmpty(columnCondition.value)) {
            return;
        }
        if (SqlUtil.isNumber(columnCondition.sqlTypeId)) {
            if (columnCondition.sqlTypeId == -7) {
                Boolean bool = BcBooleanUtil.parseBoolean(columnCondition.value, true);
                if (bool != null) {
                    SqlWhereElement whereElement = new SqlWhereElement();
                    whereElement.setLogical_AND();
                    whereElement.setFormula(sqlContext.toCondition_boolean(columnCondition.tableColumnName, bool));
                    wherecClauseSql.addWhereElement(whereElement);
                }
            } else {
                SqlConditionParser.getInstance().parseCondition4Number(wherecClauseSql, sqlContext, columnCondition.tableColumnName, columnCondition.value);
            }
        } else if (SqlUtil.isText(columnCondition.sqlTypeId)) {
            List<String> conditionValueList = SqlConditionSpliter.getInstance().split(columnCondition.value);
            if (conditionValueList.size() > 0) {
                StringBuilder tmpStr = SqlConditionUtil.createPatternMatchClause(sqlContext, columnCondition.tableColumnName, columnCondition.patternMatch, true, false, conditionValueList);
                SqlWhereElement whereElement = new SqlWhereElement();
                if (columnCondition.isAnd) {
                    whereElement.setLogical_AND();
                } else {
                    whereElement.setLogical_OR();
                }
                whereElement.setFormula(tmpStr);
                wherecClauseSql.addWhereElement(whereElement);
            }
        } else {
            BcLogUtil.debug("Not suppoted sqlType. " + columnCondition.sqlTypeId + ":" + (Object)((Object)SqlConstants.SqlType.getById(columnCondition.sqlTypeId)));
        }
    }
}

