/*
 * Decompiled with CFR 0.152.
 */
package ext.module.wbs1.rmo;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.wbs1.common.Wbs1Words;
import ext.module.wbs1.model.Wbs1ArticleCondition;
import ext.module.wbs1.server.Wbs1ServerUtil;
import ext.scf3.rmo.ScfSqlUtil;
import ext.scf3.server.ScfSqlTask;
import ext.scf8.util.KscfKeywordUtil;
import java.util.ArrayList;

public class Wbs1ArticleListRMO
extends RmiAbstractRMO {
    public static final String METHOD_articleList = "articleList";
    Wbs1ArticleCondition articleCondition;

    public void articleList(RmiRmoArgument rmoArg) throws Exception {
        this.articleCondition = (Wbs1ArticleCondition)rmoArg.getRequest().getData();
        DtsSession dtsSession = Wbs1ServerUtil.getInstance().createSession(rmoArg, this);
        SqlContext sqlContext = dtsSession.getSqlContext();
        ScfSqlTask sqlTask = ScfSqlUtil.createSqlTask(rmoArg, dtsSession);
        SqlSelectSql selectSql = new SqlSelectSql();
        this.setColumnNameList(selectSql);
        this.parseCondition(dtsSession, selectSql);
        this.getFromClause(selectSql);
        this.setOrderByPhrase(selectSql);
        sqlTask.sql = sqlContext.buildSelectSql(selectSql);
        BcLogUtil.debug("query=" + sqlTask.sql);
        sqlTask.tableColumnNameList = selectSql.getSelectColumnList();
        sqlTask.tableContext.title = Wbs1Words.getInstance().\u8a18\u4e8b\u30ea\u30b9\u30c8;
        sqlTask.tableContext.setConditionList(selectSql.getConditionList());
        ScfSqlUtil.generalListNew(sqlTask, (Object)this);
    }

    public Wbs1ArticleCondition getEventCondition() {
        return this.articleCondition;
    }

    public void setEventCondition(Wbs1ArticleCondition articleCondition) {
        this.articleCondition = articleCondition;
    }

    public void parseCondition(DtsSession dtsSession, SqlSelectSql selectSql) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        if (!BcStringUtil.isEmpty(this.articleCondition.keyword)) {
            String keywords = KscfKeywordUtil.conv(this.articleCondition.keyword);
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(String.valueOf(this.articleCondition.tableName) + ".text_1" + sqlContext.toKeyword(keywords));
            sb.append(" OR ");
            sb.append(String.valueOf(this.articleCondition.tableName) + ".text_2" + sqlContext.toKeyword(keywords));
            sb.append(")");
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sb);
            selectSql.addWhereElement(whereElement);
        }
    }

    public void setColumnNameList(SqlSelectSql selectSql) throws Exception {
        ArrayList<String> tmpSelectColumnNameList = new ArrayList<String>();
        tmpSelectColumnNameList.addAll(selectSql.getSelectColumnList());
        selectSql.getSelectColumnList().clear();
        selectSql.getSelectColumnList().add(String.valueOf(this.articleCondition.tableName) + ".id");
        selectSql.getSelectColumnList().add(String.valueOf(this.articleCondition.tableName) + ".text_1");
        selectSql.getSelectColumnList().add(String.valueOf(this.articleCondition.tableName) + ".text_2");
        selectSql.getSelectColumnList().addAll(tmpSelectColumnNameList);
    }

    public void getFromClause(SqlSelectSql selectSql) throws Exception {
        String tmpFromClause = selectSql.getFromClause();
        StringBuilder sb = new StringBuilder();
        sb.append(this.articleCondition.tableName);
        selectSql.setFromClause(sb.toString());
    }

    public void setOrderByPhrase(SqlSelectSql selectSql) {
        selectSql.getOrderByList().add(String.valueOf(this.articleCondition.tableName) + ".id");
    }
}

