/*
 * Decompiled with CFR 0.152.
 */
package ext.module.impt.rmo;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.xml.BcXmlUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.model.SqlSelectSql;
import ext.module.impt.common.ImptImportDefineParser;
import ext.module.impt.dao.ImptDefineIndexDAO;
import ext.module.impt.dao.ImptFileResourceDAO;
import ext.module.impt.model.ImptDefineIndex;
import ext.module.impt.model.ImptImportDefine;
import ext.scf3.rmo.ScfSqlUtil;
import ext.scf5.model.ScfFileResource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ImptDefineIndexRMO
extends RmiAbstractRMO {
    public static final String METHOD_putDefineIndex = "putDefineIndex";
    public static final String METHOD_deleteDefineIndex = "deleteDefineIndex";
    public static final String METHOD_getDefineIndex = "getDefineIndex";
    public static final String METHOD_defineIndexTable = "defineIndexTable";

    public void putDefineIndex(RmiRmoArgument rmoArg) throws Exception {
        ImptDefineIndex defineIndex = (ImptDefineIndex)rmoArg.getRequest().getData();
        String fileName = rmoArg.getRequest().getDataAsString();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        if (!BcStringUtil.isEmpty(fileName)) {
            File dir = new File(AfbApplication.getInstance().toReal("${ROOT}temp/"));
            File file = new File(dir, fileName);
            ScfFileResource fileResource = defineIndex.fileResourceId <= 0 ? new ScfFileResource() : ImptFileResourceDAO.getInstance().getFileResource(dtsSession, defineIndex.fileResourceId);
            ImptFileResourceDAO.getInstance().putFileResource(dtsSession, fileResource, file);
            defineIndex.fileResourceId = fileResource.getDataId();
        }
        ImptDefineIndexDAO.getInstance().putDefineIndex(dtsSession, defineIndex);
        rmoArg.getRespons().addData(defineIndex.getDataId());
    }

    public void deleteDefineIndex(RmiRmoArgument rmoArg) throws Exception {
        int defineIndexId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        int cnt = ImptDefineIndexDAO.getInstance().deleteDefineIndex(dtsSession, defineIndexId);
        rmoArg.getRespons().addData(cnt);
    }

    public void getDefineIndex(RmiRmoArgument rmoArg) throws Exception {
        int defineIndexId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ImptDefineIndex defineIndex = ImptDefineIndexDAO.getInstance().getDefineIndex(dtsSession, defineIndexId);
        String fileName = rmoArg.getRequest().getDataAsString();
        rmoArg.getRespons().addData(defineIndex);
    }

    public void defineIndexTable(RmiRmoArgument rmoArg) throws Exception {
        SqlSelectSql selectSql = new SqlSelectSql();
        selectSql.addSelectColumn("impt_define_index.id");
        selectSql.addSelectColumn("impt_define_index.code");
        selectSql.addSelectColumn("impt_define_index.name");
        selectSql.addSelectColumn("impt_define_index.file_resource_id");
        selectSql.addSelectColumn("impt_define_index.class_id");
        selectSql.addSelectColumn("impt_define_index.display_no");
        selectSql.addSelectColumn("impt_define_index.note_");
        selectSql.setFromClause("impt_define_index__vv AS impt_define_index");
        ScfSqlUtil.generalList(rmoArg, selectSql);
    }

    public void getDefineIndexList(RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ArrayList<ImptDefineIndex> importModeList = new ArrayList<ImptDefineIndex>();
        List<ImptDefineIndex> defineIndexList2 = ImptDefineIndexDAO.getInstance().getDefineIndexList(dtsSession);
        importModeList.addAll(defineIndexList2);
        rmoArg.getRespons().addData(importModeList);
    }

    public void getFileResource(RmiRmoArgument rmoArg) throws Exception {
        int fileResourceId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ScfFileResource fileResource = ImptFileResourceDAO.getInstance().getFileResource(dtsSession, fileResourceId);
        rmoArg.getRespons().addData(fileResource);
    }

    public void getImportDefine(RmiRmoArgument rmoArg) throws Exception {
        int fileResourceId = rmoArg.getRequest().getDataAsInteger();
        BcLogUtil.debug("getImportDefine:fileResourceId=" + fileResourceId);
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        byte[] bytes = ImptFileResourceDAO.getInstance().getAsByteArray(dtsSession, fileResourceId);
        ImptImportDefine importDefine = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            InputSource inputSource = new InputSource(is);
            Document domDoc = BcXmlUtil.createDocument(inputSource);
            ImptImportDefineParser importDefineParser = new ImptImportDefineParser();
            importDefine = importDefineParser.parse(domDoc);
        }
        rmoArg.getRespons().addData(importDefine);
    }
}

