/*
 * Decompiled with CFR 0.152.
 */
package ext.module.impt.model;

import ext.base.core.BcStringUtil;
import ext.base.mmd.MmdField;
import ext.module.impt.model.ImptMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ImptImportDefine
implements Serializable {
    private static final long serialVersionUID = -8049519801740732188L;
    public int datasourceType;
    public String charsetName;
    protected List<MmdField> mmdFieldList = new ArrayList<MmdField>();
    protected List<ImptMapper> mapperList = new ArrayList<ImptMapper>();
    protected Map<String, ImptMapper> mapNameMap = new HashMap<String, ImptMapper>();
    public Properties props = new Properties();
    public int headerRow;
    public int dataStartRow;
    public int dataEndRow;
    public int fixedLength;
    public int updateMode;
    public boolean rowNumberEnabled;

    public ImptImportDefine() {
        this.clear();
    }

    public void clear() {
        this.datasourceType = -1;
        this.mmdFieldList.clear();
        this.mapperList.clear();
        this.mapNameMap.clear();
        this.props.clear();
        this.headerRow = -1;
        this.dataStartRow = -1;
        this.dataEndRow = -1;
        this.fixedLength = -1;
        this.updateMode = -1;
        this.rowNumberEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelMetaDataField(MmdField mmdField) {
        List<MmdField> list = this.mmdFieldList;
        synchronized (list) {
            this.mmdFieldList.add(mmdField);
        }
    }

    public MmdField getModelMetaDataField(int idx) {
        MmdField mmdField = this.mmdFieldList.get(idx);
        return mmdField;
    }

    public int getModelMetaDataFieldCount() {
        return this.mmdFieldList.size();
    }

    public int getMapperCount() {
        return this.mapperList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addMapper(ImptMapper mapper) {
        List<MmdField> list = this.mmdFieldList;
        synchronized (list) {
            this.mapperList.add(mapper);
            return this.mapperList.size() - 1;
        }
    }

    public ImptMapper getMapper(int idx) {
        ImptMapper mapper = this.mapperList.get(idx);
        return mapper;
    }

    public ImptMapper getMapperByMapName(String mapName) {
        ImptMapper mapper = this.mapNameMap.get(mapName);
        return mapper;
    }

    public MmdField getMapperBySourceName(String sourceName) {
        int i = 0;
        while (i < this.getModelMetaDataFieldCount()) {
            MmdField mmdField = this.getModelMetaDataField(i);
            if (BcStringUtil.equalsIgnoreCase(mmdField.fieldName, sourceName)) {
                return mmdField;
            }
            ++i;
        }
        return null;
    }

    public void setIndexRow(List valueList) {
        if (this.getModelMetaDataFieldCount() > 0) {
            MmdField mmdField;
            int i = 0;
            while (i < this.getModelMetaDataFieldCount()) {
                mmdField = this.getModelMetaDataField(i);
                mmdField.ordinalPosition = -1;
                ++i;
            }
            i = 0;
            while (i < this.getModelMetaDataFieldCount()) {
                mmdField = this.getModelMetaDataField(i);
                int j = 0;
                while (j < valueList.size()) {
                    String sourceName = BcStringUtil.trim((String)valueList.get(j));
                    if (BcStringUtil.equalsIgnoreCase(mmdField.fieldName, sourceName)) {
                        mmdField.ordinalPosition = j;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < valueList.size()) {
                String sourceName = BcStringUtil.trim((String)valueList.get(i));
                MmdField mmdField = new MmdField();
                mmdField.ordinalPosition = i++;
                mmdField.fieldName = sourceName;
                this.addModelMetaDataField(mmdField);
                ImptMapper itemMapper = new ImptMapper();
                itemMapper.name = sourceName;
                itemMapper.mmdField = mmdField;
                this.addMapper(itemMapper);
            }
        }
        this.packData();
    }

    public void setOrdinalPosition() {
        int i = 0;
        while (i < this.getModelMetaDataFieldCount()) {
            MmdField mmdField = this.getModelMetaDataField(i);
            mmdField.ordinalPosition = i++;
        }
        this.packData();
    }

    public int getIndex(String mapName) {
        ImptMapper mapper = this.getMapperByMapName(mapName);
        if (mapper != null) {
            return mapper.mmdField.ordinalPosition;
        }
        return -1;
    }

    public void packData() {
        int i;
        if (this.datasourceType == 21) {
            this.fixedLength = 0;
            i = 0;
            while (i < this.getModelMetaDataFieldCount()) {
                MmdField mmdField = this.getModelMetaDataField(i);
                mmdField.ordinalPosition = i++;
                this.fixedLength += mmdField.dataSize;
            }
        }
        this.mapNameMap.clear();
        i = 0;
        while (i < this.getMapperCount()) {
            ImptMapper mapper = this.getMapper(i);
            this.mapNameMap.put(mapper.name, mapper);
            ++i;
        }
    }
}

