/*
 * Decompiled with CFR 0.152.
 */
package ext.module.dcmn.swg;

import ext.appfw.common.AfbApplication;
import ext.base.log.BcLogUtil;
import ext.base.thread.BcMonitor;
import ext.base.thread.BcThread;
import ext.base.util.BcWords;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.rmi.model.RmiRespons;
import ext.lib.swg.SwgOptionPane;
import ext.scf.client.ScfClientContainer;
import ext.scf2.client.ScfFileDownloader;
import ext.scf4.swg.HswgProcessingPane;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DcmnDocumentClientHelper {
    List<File> svFileList;
    List<File> localFileList;

    public void sendRequestAndLunchExcel(RmiRequest rmiReq, String title, Component parentComponent) throws Exception {
        HswgProcessingPane processiongPane = new HswgProcessingPane();
        processiongPane.setRequest(rmiReq);
        processiongPane.showAsDiaolg(parentComponent, title);
        RmiRespons rmiRes = processiongPane.getResponse();
        this.svFileList = (List)rmiRes.getData();
        BcLogUtil.debug("svFileList.size()=" + this.svFileList.size());
        if (this.svFileList.size() == 0) {
            return;
        }
        InnerThread downloadThread = new InnerThread();
        downloadThread.startThread();
    }

    protected void fileDownload() throws Exception {
        File localDir = new File(AfbApplication.getInstance().toReal("${ROOT}export/"));
        BcMonitor monitor = new BcMonitor();
        this.localFileList = new ArrayList<File>();
        int i = 0;
        while (i < this.svFileList.size()) {
            File svFile = this.svFileList.get(i);
            File localFile = null;
            if (ScfClientContainer.getInstance().isClient()) {
                localFile = new File(localDir, svFile.getName());
                ScfFileDownloader fileDownloader = new ScfFileDownloader(ScfClientContainer.getInstance().getAgent());
                fileDownloader.download(monitor, svFile, localFile, false);
                monitor.sync();
            } else {
                localFile = svFile;
            }
            this.localFileList.add(localFile);
            ++i;
        }
        BcLogUtil.debug("localFileList.size()=" + this.localFileList.size());
        i = 0;
        while (i < this.localFileList.size()) {
            File localFile = this.localFileList.get(i);
            this.excelTrans_L2(localFile);
            ++i;
        }
    }

    protected void excelTrans_L2(File file) throws Exception {
        BcLogUtil.debug("excelTrans_L2:file.getPath()=" + file.getPath());
        Desktop.getDesktop().open(file);
    }

    class InnerThread
    extends BcThread {
        public InnerThread() {
            this.setPriority(1);
        }

        @Override
        protected void run2() throws Exception {
            try {
                DcmnDocumentClientHelper.this.fileDownload();
                this.stopThread();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                SwgOptionPane.showMessageDialog(null, ex.getMessage(), BcWords.getInstance().error, 0);
            }
        }
    }
}

