/*
 * Decompiled with CFR 0.152.
 */
package ext.module.dcmn.rmo;

import ext.base.io.BcStreamUtil;
import ext.base.log.BcLogUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.model.SqlSelectSql;
import ext.module.dcmn.dao.DcmnDocumentTemplateDAO;
import ext.module.dcmn.dao.DcmnFileResourceDAO;
import ext.module.dcmn.model.DcmnDocumentTemplate;
import ext.module.dcmn.server.DcmnServerUtil;
import ext.scf3.rmo.ScfSqlUtil;
import ext.scf5.model.ScfFileResource;
import java.io.InputStream;

public class DcmnDocumentTemplateRMO
extends RmiAbstractRMO {
    public static final String METHOD_putDocumentTemplate = "putDocumentTemplate";
    public static final String METHOD_deleteDocumentTemplate = "deleteDocumentTemplate";
    public static final String METHOD_getDocumentTemplate = "getDocumentTemplate";
    public static final String METHOD_getDocumentTemplateList = "getDocumentTemplateList";
    public static final String METHOD_getFileResource = "getFileResource";
    public static final String METHOD_getDocForm = "getDocForm";

    public void putDocumentTemplate(RmiRmoArgument rmoArg) throws Exception {
        DcmnDocumentTemplate documentTemplate = (DcmnDocumentTemplate)rmoArg.getRequest().getData();
        String fileName = rmoArg.getRequest().getDataAsString();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        DcmnServerUtil.putDocumentTemplate(dtsSession, documentTemplate, fileName);
        rmoArg.getRespons().addData(documentTemplate);
    }

    public void deleteDocumentTemplate(RmiRmoArgument rmoArg) throws Exception {
        int documentTemplateId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        int cnt = DcmnDocumentTemplateDAO.getInstance().deleteDocumentTemplate(dtsSession, documentTemplateId);
        rmoArg.getRespons().addData(cnt);
    }

    public void getDocumentTemplate(RmiRmoArgument rmoArg) throws Exception {
        int documentTemplateId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        DcmnDocumentTemplate documentTemplate = DcmnDocumentTemplateDAO.getInstance().getDocumentTemplate(dtsSession, documentTemplateId);
        String fileName = rmoArg.getRequest().getDataAsString();
        rmoArg.getRespons().addData(documentTemplate);
    }

    public void getDocumentTemplateList(RmiRmoArgument rmoArg) throws Exception {
        SqlSelectSql selectSql = new SqlSelectSql();
        selectSql.addSelectColumn("dcmn_document_template.id");
        selectSql.addSelectColumn("dcmn_document_template.code");
        selectSql.addSelectColumn("dcmn_document_template.name");
        selectSql.addSelectColumn("dcmn_file_resource.id");
        selectSql.addSelectColumn("dcmn_file_resource.file_name");
        selectSql.setFromClause("dcmn_document_template__v1 AS dcmn_document_template LEFT JOIN dcmn_file_resource ON dcmn_file_resource.id = dcmn_document_template.file_resource_id");
        ScfSqlUtil.generalList(rmoArg, selectSql);
    }

    public void getFileResource(RmiRmoArgument rmoArg) throws Exception {
        long fileResourceId = rmoArg.getRequest().getDataAsLong();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ScfFileResource fileResource = DcmnFileResourceDAO.getInstance().getFileResource(dtsSession, fileResourceId);
        rmoArg.getRespons().addData(fileResource);
    }

    public void getDocForm(RmiRmoArgument rmoArg) throws Exception {
        String fileName = rmoArg.getRequest().getDataAsString();
        String path = "docform/" + fileName;
        BcLogUtil.debug("path=" + path);
        InputStream is = this.getClass().getResourceAsStream("docform/" + fileName);
        byte[] bytes = BcStreamUtil.readWithClose(is);
        rmoArg.getRespons().addData(new String(bytes));
    }
}

