/*
 * Decompiled with CFR 0.152.
 */
package ext.module.dcmn.common;

import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.util.BcConditionElement;
import ext.lib.doc.util.DcfConstants;
import java.awt.Font;
import java.util.List;
import java.util.Properties;
import nlc.lib.doc.DcfBook;
import nlc.lib.doc.DcfPage;
import nlc.lib.doc.shape.DcfLineShape;
import nlc.lib.doc.shape.DcfShape;
import nlc.lib.doc.shape.DcfShapeGroup;
import nlc.lib.doc.shape.DcfTextShape;
import org.apache.commons.lang3.text.StrSubstitutor;

public final class DcmnDocumentUtil {
    public static String sep1 = StrSubstitutor.DEFAULT_PREFIX.toString();
    public static String sep2 = StrSubstitutor.DEFAULT_SUFFIX.toString();
    public static final double DEFAULT_HEADER_HEIGHT = 84.0;
    public static final double DEFAULT_FOOTER_HEIGHT = 28.0;

    private DcmnDocumentUtil() {
    }

    public static void replace(DcfBook ksclBook, Properties replaceProps) throws Exception {
        int i = 0;
        while (i < ksclBook.getPageCount()) {
            DcfPage page = ksclBook.getPage(i);
            DcmnDocumentUtil.replace(page, replaceProps, i + 1, ksclBook.getPageCount());
            ++i;
        }
    }

    public static void replace(DcfPage page, Properties replaceProps, int pageNo, int pageCount) throws Exception {
        DcfShapeGroup shapeGroup = null;
        DcfShape shape = null;
        int i = 0;
        while (i < page.getGroupCount()) {
            shapeGroup = page.getGroup(i);
            int j = 0;
            while (j < shapeGroup.getShapeCount()) {
                shape = shapeGroup.getShape(j);
                if (DcfTextShape.class.isAssignableFrom(shape.getClass())) {
                    DcmnDocumentUtil.replaceL3((DcfTextShape)shape, replaceProps, pageNo, pageCount);
                }
                ++j;
            }
            ++i;
        }
    }

    protected static void replaceL3(DcfTextShape textShape, Properties replaceProps, int pageNo, int pageCount) throws Exception {
        if (BcStringUtil.isEmpty(textShape.value)) {
            return;
        }
        textShape.value = BcStringUtil.replace((CharSequence)textShape.value, String.valueOf(sep1) + DcfConstants.DEGN_createDate + sep2, BcTimeUtil.toString(BcTimeUtil.createCalendar(), "yyyy/MM/dd")).toString();
        textShape.value = BcStringUtil.replace((CharSequence)textShape.value, String.valueOf(sep1) + DcfConstants.DEGN_createTime + sep2, BcTimeUtil.toString(BcTimeUtil.createCalendar(), "HH:mm:ss")).toString();
        textShape.value = BcStringUtil.replace((CharSequence)textShape.value, String.valueOf(sep1) + DcfConstants.DEGN_pageNo + sep2, Integer.toString(pageNo)).toString();
        textShape.value = BcStringUtil.replace((CharSequence)textShape.value, String.valueOf(sep1) + DcfConstants.DEGN_pageCount + sep2, Integer.toString(pageCount)).toString();
        textShape.value = BcStringUtil.replace((CharSequence)textShape.value, String.valueOf(sep1) + DcfConstants.DEGN_signatureSectionName + sep2, replaceProps.getProperty(DcfConstants.DEGN_signatureSectionName)).toString();
        textShape.value = BcStringUtil.replace((CharSequence)textShape.value, String.valueOf(sep1) + DcfConstants.DEGN_signaturePersonName + sep2, replaceProps.getProperty(DcfConstants.DEGN_signaturePersonName)).toString();
        if (textShape.value.indexOf(sep1) < 0) {
            return;
        }
        if (replaceProps == null) {
            return;
        }
        String tmp1 = null;
        int startIndex = 0;
        while ((tmp1 = BcStringUtil.extract(textShape.value, sep1, startIndex)) != null) {
            String tmp2 = replaceProps.getProperty(tmp1);
            if (tmp2 != null) {
                textShape.value = BcStringUtil.replace((CharSequence)textShape.value, String.valueOf(sep1) + tmp1 + sep2, tmp2).toString();
            }
            startIndex += tmp1.length();
        }
    }

    public static void setStandardHeader(DcfShapeGroup shapeGroup, double yOffset, String title, String subTitle, List<BcConditionElement> conditionList) throws Exception {
        DcfTextShape textShape = null;
        int fontSize = 8;
        boolean isBorder = false;
        textShape = new DcfTextShape();
        textShape.getRectangle().setRect(0.0, yOffset + 30.0, 230.0, 24.0);
        textShape.setLine(isBorder);
        textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 3, 14);
        textShape.value = title;
        shapeGroup.addShape(textShape);
        if (subTitle != null) {
            textShape = new DcfTextShape();
            textShape.getRectangle().setRect(4.0, yOffset + 54.0, 230.0, 20.0);
            textShape.setLine(isBorder);
            textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 3, 12);
            textShape.value = subTitle;
            shapeGroup.addShape(textShape);
        }
        if (conditionList == null) {
            return;
        }
        int rowMax = 4;
        int rowCount = 0;
        double nX = 240.0;
        double nW = 64.0;
        double sX = nX + nW;
        double sW = 8.0;
        double vX = nX + nW + sW;
        double vW = 120.0;
        double y = yOffset + 30.0;
        double h = 12.0;
        double vGap = 0.0;
        double hGap = 4.0;
        if (conditionList == null) {
            return;
        }
        BcConditionElement condition = null;
        int i = 0;
        while (i < conditionList.size()) {
            if (rowCount >= rowMax) {
                y = yOffset + 30.0;
                nX += nW + vW + sW + hGap;
                sX += nW + vW + sW + hGap;
                vX += nW + vW + sW + hGap;
                rowCount = 0;
            }
            ++rowCount;
            condition = conditionList.get(i);
            textShape = new DcfTextShape();
            textShape.getRectangle().setRect(nX, y, nW, h);
            textShape.setLine(isBorder);
            textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 2, fontSize);
            textShape.horizontalAlign = 4;
            textShape.value = condition.name;
            shapeGroup.addShape(textShape);
            textShape = new DcfTextShape();
            textShape.getRectangle().setRect(sX, y, sW, h);
            textShape.setLine(isBorder);
            textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 0, fontSize);
            textShape.value = ":";
            shapeGroup.addShape(textShape);
            textShape = new DcfTextShape();
            textShape.getRectangle().setRect(vX, y, vW, h);
            textShape.setLine(isBorder);
            textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 0, fontSize);
            textShape.value = condition.value;
            shapeGroup.addShape(textShape);
            y += h + vGap;
            ++i;
        }
    }

    public static void createPageFooterElement(DcfPage dcfPage, DcfShapeGroup shapeGroup) throws Exception {
        shapeGroup.setX(0.0);
        shapeGroup.setWidth(dcfPage.getPageFormat().getImageableWidth());
        shapeGroup.setHeight(28.0);
        DcfLineShape lineShape = new DcfLineShape("", 0.0, 0.0, 770.0, 0.0);
        lineShape.lineWidth = 1.0;
        shapeGroup.addShape(lineShape);
        DcfTextShape textShape = null;
        boolean isBorder = false;
        int fontSize = 8;
        textShape = new DcfTextShape();
        textShape.getRectangle().setRect(0.0, 4.0, 40.0, 12.0);
        textShape.setLine(isBorder);
        textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 2, fontSize);
        textShape.horizontalAlign = 4;
        textShape.value = "\u4f5c\u6210\u65e5\u6642";
        shapeGroup.addShape(textShape);
        textShape = new DcfTextShape();
        textShape.getRectangle().setRect(40.0, 4.0, 8.0, 12.0);
        textShape.setLine(isBorder);
        textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 0, fontSize);
        textShape.value = ":";
        shapeGroup.addShape(textShape);
        textShape = new DcfTextShape();
        textShape.getRectangle().setRect(48.0, 4.0, 100.0, 12.0);
        textShape.setLine(isBorder);
        textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 0, fontSize);
        textShape.value = String.valueOf(sep1) + DcfConstants.DEGN_createDate + sep2 + " " + sep1 + DcfConstants.DEGN_createTime + sep2;
        shapeGroup.addShape(textShape);
        textShape = new DcfTextShape();
        textShape.getRectangle().setRect(0.0, 16.0, 40.0, 12.0);
        textShape.setLine(isBorder);
        textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 2, fontSize);
        textShape.horizontalAlign = 4;
        textShape.value = "\u30da\u30fc\u30b8";
        shapeGroup.addShape(textShape);
        textShape = new DcfTextShape();
        textShape.getRectangle().setRect(40.0, 16.0, 8.0, 12.0);
        textShape.setLine(isBorder);
        textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 0, fontSize);
        textShape.value = ":";
        shapeGroup.addShape(textShape);
        textShape = new DcfTextShape();
        textShape.setName("pageNo");
        textShape.getRectangle().setRect(48.0, 16.0, 20.0, 12.0);
        textShape.setLine(isBorder);
        textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 0, fontSize);
        textShape.horizontalAlign = 4;
        textShape.value = String.valueOf(sep1) + DcfConstants.DEGN_pageNo + sep2;
        shapeGroup.addShape(textShape);
        textShape = new DcfTextShape();
        textShape.getRectangle().setRect(shapeGroup.getWidth() - 400.0, 4.0, 320.0, 12.0);
        textShape.setLine(isBorder);
        textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 0, fontSize);
        textShape.horizontalAlign = 4;
        textShape.value = String.valueOf(sep1) + DcfConstants.DEGN_signatureSectionName + sep2;
        shapeGroup.addShape(textShape);
        textShape = new DcfTextShape();
        textShape.getRectangle().setRect(shapeGroup.getWidth() - 400.0, 16.0, 320.0, 12.0);
        textShape.setLine(isBorder);
        textShape.font = new Font("\uff2d\uff33 \uff30\u660e\u671d", 0, fontSize);
        textShape.horizontalAlign = 4;
        textShape.value = String.valueOf(sep1) + DcfConstants.DEGN_signaturePersonName + sep2;
        shapeGroup.addShape(textShape);
    }
}

