/*
 * Decompiled with CFR 0.152.
 */
package ext.module.arcv.dao;

import ext.base.io.BcFileUtil;
import ext.base.io.BcStreamUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.orm.dao.OrmSequenceDAO;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.module.arcv.common.ArcvUtil;
import ext.module.arcv.dao.ArcvAbstractBinaryIndexDAO;
import ext.module.arcv.dao.ArcvAbstructBinaryGenerationDAO;
import ext.module.arcv.model.ArcvBinary;
import ext.module.arcv.model.ArcvBinaryGeneration;
import ext.module.arcv.model.ArcvBinaryIndex;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class ArcvAbstractBinaryDAO
extends OrmAbstractDAO<ArcvBinary> {
    protected ArcvAbstructBinaryGenerationDAO binaryGenerationDAO;
    protected ArcvAbstractBinaryIndexDAO binaryIndexDAO;
    private String binaryColumnName;
    protected int bufSize = 4096;

    public ArcvAbstractBinaryDAO() {
        super(new ArcvBinary[0]);
        this.setBinaryColumnName("binary_data");
    }

    public String getBinaryColumnName() {
        return this.binaryColumnName;
    }

    public void setBinaryColumnName(String binaryColumnName) {
        this.binaryColumnName = binaryColumnName;
    }

    protected DtsSession getDtsSession(DtsSession dtsSession, ArcvBinaryGeneration binaryGeneration) throws Exception {
        if (binaryGeneration == null) {
            throw new Exception("BinaryGeneration is null.");
        }
        DtsSession dtsSession2 = null;
        dtsSession2 = binaryGeneration.datasourceName.equals(dtsSession.getSessionFactory().getName()) ? dtsSession : DtsSessionFactoryManegaer.getInstance().createSession(binaryGeneration.datasourceName, this);
        return dtsSession2;
    }

    public void putBinary(DtsSession dtsSession, ArcvBinary binary, InputStream is, long length, ArcvBinaryIndex binaryIndex) throws Exception {
        if (binary.getDataId() <= 0) {
            long newId = OrmSequenceDAO.getInstance().generateNumber(dtsSession, String.valueOf(this.tableName) + ".id");
            binary.setDataId((int)newId);
        }
        ArcvBinaryGeneration binaryGeneration = this.binaryGenerationDAO.getByBinaryId_Cash(dtsSession, binary.getDataId());
        DtsSession dtsSession2 = this.getDtsSession(dtsSession, binaryGeneration);
        SqlContext sqlContext2 = dtsSession.getSqlContext();
        try {
            boolean existTable = sqlContext2.existTable(dtsSession2.getConnection(), binaryGeneration.tableName);
            if (!existTable) {
                this.createTable(dtsSession2, binaryGeneration.tableName);
            }
            this.getPersistenceProxy().putEntitys_3(dtsSession2, binaryGeneration.tableName, binary);
            if (is != null) {
                String whereClause = "id = " + binary.getDataId();
                sqlContext2.putBinary(dtsSession2.getConnection(), binaryGeneration.tableName, this.binaryColumnName, whereClause, is, (int)length);
                is.close();
            }
            if (dtsSession2.hashCode() != dtsSession.hashCode()) {
                dtsSession2.commit();
            }
        }
        finally {
            if (dtsSession2.hashCode() != dtsSession.hashCode()) {
                try {
                    dtsSession2.desturuct();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
        }
        binaryIndex.setDataId(binary.getDataId());
        if (this.binaryIndexDAO != null) {
            this.binaryIndexDAO.putEntity(dtsSession, binaryIndex);
        }
    }

    public void putBinary(DtsSession dtsSession, ArcvBinary binary, File file, ArcvBinaryIndex binaryIndex) throws Exception {
        if (file != null) {
            ArcvUtil.setFileInfo(binaryIndex, file);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            this.putBinary(dtsSession, binary, is, file.length(), binaryIndex);
            binaryIndex.binaryLength = file.length();
            binaryIndex.binaryType = 1;
            binaryIndex.binaryName = file.getName();
            binaryIndex.fileExtention = BcFileUtil.getExtention(file);
        } else {
            this.putBinary(dtsSession, binary, null, 0L, binaryIndex);
        }
    }

    public int deleteById(DtsSession dtsSession, long binaryId) throws Exception {
        ArcvBinaryGeneration binaryGeneration = this.binaryGenerationDAO.getByBinaryId_Cash(dtsSession, binaryId);
        DtsSession dtsSession2 = this.getDtsSession(dtsSession, binaryGeneration);
        int cnt = 0;
        try {
            ArcvBinary binary = new ArcvBinary();
            binary.setDataId((int)binaryId);
            cnt = this.getPersistenceProxy().deleteEntity(dtsSession2, binaryGeneration.tableName, binary);
            if (dtsSession2.hashCode() != dtsSession.hashCode()) {
                dtsSession2.commit();
            }
        }
        finally {
            if (dtsSession2.hashCode() != dtsSession.hashCode()) {
                try {
                    dtsSession2.desturuct();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
        }
        ArcvBinaryIndex binaryIndex = new ArcvBinaryIndex();
        binaryIndex.setDataId((int)binaryId);
        if (this.binaryIndexDAO != null) {
            this.binaryIndexDAO.deleteEntity(dtsSession, binaryIndex);
        }
        return cnt;
    }

    protected ArcvBinary getById(DtsSession dtsSession, String tableName, long binaryId) throws Exception {
        String query = "SELECT " + this.getPersistenceProxy().createSelectColumnPhrase(this.getEntityClass()) + " FROM " + tableName + " WHERE id = " + binaryId;
        return (ArcvBinary)this.getEntity(dtsSession, query);
    }

    public ArcvBinary getById(DtsSession dtsSession, long binaryId) throws Exception {
        ArcvBinaryGeneration binaryGeneration = this.binaryGenerationDAO.getByBinaryId_Cash(dtsSession, binaryId);
        DtsSession dtsSession2 = this.getDtsSession(dtsSession, binaryGeneration);
        ArcvBinary binary = null;
        try {
            binary = this.getById(dtsSession2, binaryGeneration.tableName, binaryId);
        }
        finally {
            if (dtsSession2.hashCode() != dtsSession.hashCode()) {
                try {
                    dtsSession2.desturuct();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
        }
        return binary;
    }

    public boolean outputById(DtsSession dtsSession, long binaryId, OutputStream os) throws Exception {
        ArcvBinaryHelper binaryHelper = null;
        try {
            binaryHelper = this.createBinaryHelper(dtsSession, binaryId);
            if (binaryHelper == null) {
                return false;
            }
            BcStreamUtil.transmit(binaryHelper.is, os, false, this.bufSize);
        }
        finally {
            if (binaryHelper != null) {
                try {
                    binaryHelper.rs.close();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
                try {
                    binaryHelper.stmt.close();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
        }
        return true;
    }

    protected ArcvBinaryHelper createBinaryHelper(DtsSession dtsSession, long binaryId) throws Exception {
        ArcvBinaryGeneration binaryGeneration = this.binaryGenerationDAO.getByBinaryId_Cash(dtsSession, binaryId);
        DtsSession dtsSession2 = this.getDtsSession(dtsSession, binaryGeneration);
        return this.createBinaryHelper(dtsSession2, binaryGeneration.tableName, binaryId);
    }

    protected ArcvBinaryHelper createBinaryHelper(DtsSession dtsSession, String tableName, long binaryId) throws Exception {
        String query = "SELECT " + this.getBinaryColumnName() + " FROM " + tableName + " WHERE id = " + binaryId;
        ArcvBinaryHelper binaryHelper = null;
        SqlStatement stmt = dtsSession.getConnection().createStatement();
        SqlResultSet rs = stmt.executeQuery(query);
        if (rs.next()) {
            binaryHelper = new ArcvBinaryHelper();
            binaryHelper.stmt = stmt;
            binaryHelper.rs = rs;
            binaryHelper.is = rs.getBinaryStream(1);
        } else {
            rs.close();
            stmt.close();
        }
        return binaryHelper;
    }

    public void createTable(DtsSession dtsSession, String tableName) throws Exception {
        String primaryKeyName = String.valueOf(tableName) + "__k01";
        String query = "CREATE TABLE " + tableName + " ( id BIGINT" + ",binary_data BYTEA" + " ,CONSTRAINT " + primaryKeyName + " PRIMARY KEY (id)" + ")";
        this.getLogger().info("query=" + query);
        SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    public class ArcvBinaryHelper {
        public SqlStatement stmt;
        public SqlResultSet rs;
        public InputStream is;
    }
}

