/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.person.common;

import ext.base.core.BcStringUtil;
import ext.base.util.BcAbstractWords;
import ext.libx.etc.util.EtcWordPack;
import ext.libx.person.common.PsnPersonConstants;
import java.io.Serializable;

public final class PsnPersonWords
extends BcAbstractWords
implements Serializable {
    private static final long serialVersionUID = 6103426069307341645L;
    public EtcWordPack age = new EtcWordPack("Age");
    public EtcWordPack birthday = new EtcWordPack("Birthday");
    public String female = "Female";
    public EtcWordPack fullName = new EtcWordPack("Full", "Name");
    public EtcWordPack fullNameKana = new EtcWordPack("Full Name", "Kana");
    public EtcWordPack fullNameRoman = new EtcWordPack("Full Name", "Roman");
    public String maidenName = "Maiden Name";
    public String male = "Male";
    public EtcWordPack sex = new EtcWordPack("Sex");

    private PsnPersonWords() {
        this.setDefault();
    }

    public static PsnPersonWords getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public void setJapanese() throws Exception {
        this.age.setData("\u5e74\u9f62");
        this.birthday.setData("\u751f\u5e74\u6708\u65e5");
        this.female = "\u5973";
        this.fullName.setData("\u6c0f\u540d");
        this.fullNameKana.setData("\u6c0f\u540d\u30ab\u30ca");
        this.fullNameRoman.setData("\u6c0f\u540d", "\u30ed\u30fc\u30de\u8aad");
        this.maidenName = "\u65e7\u59d3";
        this.male = "\u7537";
        this.sex.setData("\u6027", "\u5225");
    }

    public String toSexNameByCode(String sexCode) {
        if (BcStringUtil.equals(sexCode, PsnPersonConstants.Sex.male.code)) {
            return PsnPersonWords.getInstance().male;
        }
        if (BcStringUtil.equals(sexCode, PsnPersonConstants.Sex.female.code)) {
            return this.female;
        }
        if (BcStringUtil.isEmpty(sexCode)) {
            return "";
        }
        return "?";
    }

    /* synthetic */ PsnPersonWords(PsnPersonWords psnPersonWords) {
        this();
    }

    private static final class SingletonHolder {
        private static final PsnPersonWords instance = new PsnPersonWords(null);

        private SingletonHolder() {
        }
    }
}

