/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.fx;

import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.net.BcNetUtil;
import ext.lib.fx.util.FxImageHelper;
import ext.libx.fx.FxxNodeLocation;
import ext.libx.fx.media.FxxMediaPane;
import ext.libx.fx.viewer.FxxImageView;
import ext.libx.fx.viewer.FxxLayoutCondition;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.RotateEvent;
import javafx.scene.input.ZoomEvent;
import javafx.scene.layout.Region;
import javafx.scene.media.Media;

public final class FxxMouseEventUtil {
    static Map<Integer, FxxNodeLocation> map = new HashMap<Integer, FxxNodeLocation>();
    static double v1 = 4000.0;
    public static final String png = "png";
    public static final String jpg = "jpg";
    public static final String jpeg = "jpeg";
    public static final String gif = "gif";
    public static final String bmp = "bmp";
    public static final String[] imageExtentions = new String[]{"png", "jpg", "jpeg", "gif", "bmp"};
    public static final String mp3 = "mp3";
    public static final String mp4 = "mp4";
    public static final String avi = "avi";
    public static final String wav = "wav";
    public static final String flv = "flv";
    public static final String asf = "asf";
    public static final String wmv = "wmv";
    public static final String mov = "mov";
    public static final String fxm = "fxm";
    public static final String _3gp = "3gp";
    public static final String _3gpp = "3gpp";
    public static final String _3g2 = "3g2";
    public static final String _3gp2 = "3gp2";
    public static final String[] mediaExtentions = new String[]{"mp3", "mp4", "avi", "wav", "flv", "asf", "wmv", "mov", "fxm", "3gp", "3gpp", "3g2", "3gp2"};

    private FxxMouseEventUtil() {
    }

    public static void setMoveLotate(Node node) throws Exception {
        node.setOnMousePressed(ev -> FxxMouseEventUtil.mousePressed(ev));
        node.setOnMouseDragged(ev -> FxxMouseEventUtil.mouseDragged(ev));
        node.setOnMouseReleased(ev -> FxxMouseEventUtil.mouseReleased(ev));
        node.addEventHandler(ZoomEvent.ZOOM_STARTED, ev -> {
            Node node2 = (Node)ev.getSource();
            FxxNodeLocation nodeLocation = FxxMouseEventUtil.getLocation(node);
            nodeLocation.startScale = node2.getScaleX();
        });
        node.addEventHandler(ZoomEvent.ZOOM, ev -> {
            Node node2 = (Node)ev.getSource();
            node2.setScaleX(ev.getTotalZoomFactor());
            node2.setScaleY(ev.getTotalZoomFactor());
        });
        node.addEventHandler(RotateEvent.ROTATION_STARTED, ev -> {
            Node node2 = (Node)ev.getSource();
            FxxNodeLocation nodeLocation = FxxMouseEventUtil.getLocation(node);
            nodeLocation.startRotate = node2.getRotate();
        });
        node.addEventHandler(RotateEvent.ROTATE, ev -> {
            Node node2 = (Node)ev.getSource();
            node2.setRotate(ev.getTotalAngle());
        });
        node.setOnScroll(ev -> {
            FxxNodeLocation nodeLocation = FxxMouseEventUtil.getLocation(node);
            double scale = nodeLocation.startScale - ev.getDeltaY() / v1;
            node.setScaleX(scale);
            node.setScaleY(scale);
            nodeLocation.startScale = scale;
        });
    }

    protected static FxxNodeLocation getLocation(Node node) {
        FxxNodeLocation lcatioon = map.get(node.hashCode());
        if (lcatioon == null) {
            lcatioon = new FxxNodeLocation();
            map.put(node.hashCode(), lcatioon);
        }
        return lcatioon;
    }

    protected static FxxNodeLocation removeLocation(Node node) {
        FxxNodeLocation lcatioon = map.remove(node.hashCode());
        return lcatioon;
    }

    protected static void mousePressed(MouseEvent ev) {
        Node node = (Node)ev.getSource();
        FxxNodeLocation nodeLocation = FxxMouseEventUtil.getLocation(node);
        nodeLocation.lastX = ev.getX();
        nodeLocation.lastY = ev.getY();
        node.toFront();
        node.setCursor(Cursor.MOVE);
    }

    protected static void mouseDragged(MouseEvent ev) {
        Node node = (Node)ev.getSource();
        FxxNodeLocation nodeLocation = FxxMouseEventUtil.getLocation(node);
        double layoutX = node.getLayoutX() + (ev.getX() - nodeLocation.lastX) * node.getScaleX();
        double layoutY = node.getLayoutY() + (ev.getY() - nodeLocation.lastY) * node.getScaleY();
        node.setLayoutX(layoutX);
        node.setLayoutY(layoutY);
    }

    protected static void mouseReleased(MouseEvent ev) {
        Node node = (Node)ev.getSource();
        node.setCursor(Cursor.DEFAULT);
    }

    public static FxxMediaPane createMediaNode(URI uri) throws Exception {
        FxxMediaPane mediaPane = new FxxMediaPane();
        try {
            mediaPane.setUri(uri);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return mediaPane;
    }

    public static boolean isImageExtention(String extention) throws Exception {
        int i = 0;
        while (i < imageExtentions.length) {
            if (imageExtentions[i].equalsIgnoreCase(extention)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isImageExtention(URI uri) throws Exception {
        Path path = BcNetUtil.urlToPath(uri);
        String fileName = path.getFileName().toString();
        String extention = BcFileUtil.getExtention(fileName);
        return FxxMouseEventUtil.isImageExtention(extention);
    }

    public static boolean isMediaExtention(String extention) throws Exception {
        int i = 0;
        while (i < mediaExtentions.length) {
            if (mediaExtentions[i].equalsIgnoreCase(extention)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isMediaExtention(URI uri) throws Exception {
        Path path = BcNetUtil.urlToPath(uri);
        String fileName = path.getFileName().toString();
        String extention = BcFileUtil.getExtention(fileName);
        return FxxMouseEventUtil.isMediaExtention(extention);
    }

    public static Image createBaseImage(URI uri) throws Exception {
        boolean backgroundLoading = true;
        Image image = new Image(uri.toString(), backgroundLoading);
        return image;
    }

    public static Image createImageX(URI uri, int requestedWidth, int requestedHeight) throws Exception {
        boolean preserveRatio = true;
        boolean smooth = true;
        boolean backgroundLoading = true;
        Image image = new Image(uri.toString(), (double)requestedWidth, (double)requestedHeight, preserveRatio, smooth, backgroundLoading);
        return image;
    }

    public static Image createImageForView(URI uri, int requestedWidth, int requestedHeight) throws Exception {
        Image image = null;
        Path path = BcNetUtil.urlToPath(uri);
        if (BcNetUtil.isFile(uri) && Files.isDirectory(path, new LinkOption[0])) {
            image = FxImageHelper.getImage("deep_blue/folder_closed_256x256.png");
            return image;
        }
        String fileName = path.getFileName().toString();
        String extention = BcFileUtil.getExtention(fileName);
        BcLogUtil.debug("createImageForView:extention=" + extention);
        try {
            if (FxxMouseEventUtil.isImageExtention(extention)) {
                image = FxxMouseEventUtil.createImageX(uri, requestedWidth, requestedHeight);
            } else if (FxxMouseEventUtil.isMediaExtention(extention)) {
                Media media = new Media(uri.toString());
            }
        }
        catch (Exception ex) {
            BcLogUtil.error("\u753b\u50cf\u53d6\u5f97\u4f8b\u5916:uri=" + uri);
            BcLogUtil.error(ex);
        }
        if (image == null) {
            image = FxImageHelper.getImage("document_64x64.png");
        }
        return image;
    }

    public static Node createNode(URI uri, Image image) throws Exception {
        FxxImageView imageView = new FxxImageView(image);
        Tooltip tooltip = new Tooltip(uri.toString());
        Tooltip.install((Node)imageView, (Tooltip)tooltip);
        return imageView;
    }

    public static void layoutChildren(Region region, Node node, FxxLayoutCondition layoutCondition) {
        if (layoutCondition.x + layoutCondition.hSpace > region.getWidth()) {
            layoutCondition.x = layoutCondition.hSpace;
            layoutCondition.y += layoutCondition.vSpace + layoutCondition.cellWidth;
        }
        double cfr_ignored_0 = layoutCondition.y;
        double cfr_ignored_1 = layoutCondition.vSpace;
        region.getHeight();
        node.relocate(layoutCondition.x, layoutCondition.y);
        layoutCondition.x += layoutCondition.hSpace + layoutCondition.cellWidth;
    }

    public static void layoutChildren(Region region, Collection<? extends Node> nodeCollection, FxxLayoutCondition layoutCondition) {
        layoutCondition.clear();
        for (Node node : nodeCollection) {
            FxxMouseEventUtil.layoutChildren(region, node, layoutCondition);
        }
    }
}

