/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.fx;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.thread.BcMonitor;
import ext.base.util.BcWords;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxPasswordField;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import java.util.concurrent.BlockingQueue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public abstract class FxxAbstractLoginPane
extends FxDecoratePane {
    protected FxFlowPane centerPane = new FxFlowPane(11);
    protected FxTextField accountField = new InnerTextFiled();
    protected FxPasswordField passwordField = new InnerPasswordFieldd();
    public boolean accountFieldEnabed = true;
    protected Button loginButton;
    protected Button cancelButton;
    protected Stage stage;
    public int width = 360;
    public int height = 180;
    public String title;
    protected BcMonitor parentMonitor;
    protected BlockingQueue<Object> responsQueue;

    public FxxAbstractLoginPane(BlockingQueue<Object> responsQueue) throws Exception {
        this.title = BcWords.getInstance().login;
        this.responsQueue = responsQueue;
    }

    protected void setComponent() throws Exception {
        FxNodeUnit nodeUnit;
        this.loginButton = this.createButton(BcWords.getInstance().login);
        this.cancelButton = this.createButton(BcWords.getInstance().cancel);
        if (this.accountFieldEnabed) {
            this.accountField.setPrefColumnCount(24);
            nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().account), new Node[]{this.accountField});
            this.centerPane.addNodeUnit(nodeUnit);
        }
        this.passwordField.setPrefColumnCount(24);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().password), new Node[]{this.passwordField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setCenter((Node)this.centerPane);
        FxUtil.defaultInitialize((Node)this);
        this.passwordField.setStyle("-fx-echo-char: -;");
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.loginButton) {
            this.loginButtonAction();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void loginButtonAction() throws Exception {
        this.stage.close();
        this.unLockMonitor();
    }

    public void close() throws Exception {
        BcLogUtil.debug("close#2");
        this.stage.close();
        this.unLockMonitor();
    }

    public void unLockMonitor() throws Exception {
        if (this.parentMonitor != null) {
            this.parentMonitor.unLock();
        }
    }

    public void show(BcMonitor parentMonitor, Window ownerWindow) throws Exception {
        this.parentMonitor = parentMonitor;
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    FxxAbstractLoginPane.this.accountField.requestFocus();
                }
                catch (Exception ex) {
                    FxxAbstractLoginPane.this.handleException(ex);
                }
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    FxxAbstractLoginPane.this.close();
                }
                catch (Exception ex) {
                    FxxAbstractLoginPane.this.handleException(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth((double)this.width);
        this.stage.setHeight((double)this.height);
        this.stage.setResizable(false);
        if (!BcStringUtil.isEmpty(this.title)) {
            this.stage.setTitle(this.title);
        }
        FxImageHelper.setStageIcon(this.stage);
        this.stage.showAndWait();
    }

    class InnerPasswordFieldd
    extends FxPasswordField {
        @Override
        public void textEdited(String text) {
            try {
                FxxAbstractLoginPane.this.loginButtonAction();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                String msg = BcLogUtil.convertMessage(ex).toString();
                FxOptionPane.showMessageDialog((Window)FxxAbstractLoginPane.this.stage, (Object)msg, BcWords.getInstance().error, 0);
            }
        }
    }

    class InnerTextFiled
    extends FxTextField {
        @Override
        public void textEdited() {
            try {
                FxxAbstractLoginPane.this.passwordField.requestFocus();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                String msg = BcLogUtil.convertMessage(ex).toString();
                FxOptionPane.showMessageDialog((Window)FxxAbstractLoginPane.this.stage, (Object)msg, BcWords.getInstance().error, 0);
            }
        }
    }
}

