/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.business.general;

import ext.base.core.BcTimeUtil;
import java.util.Calendar;

public final class BsnTimeUtil {
    public static final int beginMonthIdDefault = 3;

    private BsnTimeUtil() {
    }

    public static int toHalfPeriodStart(int beginMonthId, int date) throws Exception {
        Calendar cal1 = BcTimeUtil.toCalendar(date);
        int fiscalYear = BcTimeUtil.toFiscalYear(cal1, beginMonthId);
        Calendar cal2 = BcTimeUtil.toFiscalYearStart(fiscalYear, beginMonthId);
        int halfId = BcTimeUtil.toHalfId(beginMonthId, cal2.get(2));
        if (halfId == 1) {
            cal2.add(2, 6);
        }
        int halfPeriodStart = BcTimeUtil.toYyyyMMdd(cal2);
        return halfPeriodStart;
    }

    public static int toHalfPeriodStart(int date) throws Exception {
        return BsnTimeUtil.toHalfPeriodStart(3, date);
    }

    public static int[] toHalfPeriod(int beginMonthId, int date) throws Exception {
        int halfPeriodStart = BsnTimeUtil.toHalfPeriodStart(beginMonthId, date);
        Calendar calendar = BcTimeUtil.toCalendar(halfPeriodStart);
        calendar.add(2, 5);
        BcTimeUtil.setMonthEnd(calendar);
        int halfPeriodEnd = BcTimeUtil.toYyyyMMdd(calendar);
        int[] res = new int[]{halfPeriodStart, halfPeriodEnd};
        return res;
    }

    public static int[] toHalfPeriod(int date) throws Exception {
        return BsnTimeUtil.toHalfPeriod(3, date);
    }

    public static int toFiscalYearStarYyyyMMdd(int year, int startMonthId) {
        Calendar calendar = BcTimeUtil.toFiscalYearStart(year, startMonthId);
        return BcTimeUtil.toYyyyMMdd(calendar);
    }

    public static int toFiscalYearStarYyyyMMdd(int year) {
        return BsnTimeUtil.toFiscalYearStarYyyyMMdd(year, 3);
    }

    public static int toFiscalYearEndYyyyMMdd(int year, int startMonthId) {
        Calendar calendar = BcTimeUtil.toFiscalYearEnd(year, startMonthId);
        return BcTimeUtil.toYyyyMMdd(calendar);
    }

    public static int toFiscalYearEndYyyyMMdd(int year) {
        return BsnTimeUtil.toFiscalYearEndYyyyMMdd(year, 3);
    }

    public static int getCurrentFscalYear(int startMonthId) {
        Calendar today = BcTimeUtil.createCalendar();
        Calendar calendar = BcTimeUtil.toFiscalYearStart(today.get(1), startMonthId);
        return calendar.get(1);
    }

    public static int getCurrentFscalYear() {
        return BsnTimeUtil.getCurrentFscalYear(3);
    }
}

