/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.task;

import ext.base.log.BcLogUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TskTaskManager {
    protected ExecutorService executorService;
    protected CompletionService<Object> completionService;
    protected ScheduledExecutorService scheduledExecutorServiceDummy = Executors.newSingleThreadScheduledExecutor();
    protected ScheduledFuture dummyFuture;

    private TskTaskManager() {
        this.executorService = Executors.newCachedThreadPool();
        this.completionService = new ExecutorCompletionService<Object>(this.executorService);
    }

    public static TskTaskManager getInstance() {
        return SingletonHolder.instance;
    }

    public CompletionService<Object> getCompletionService() {
        return this.completionService;
    }

    public Future startTask(Callable callable) {
        Future<Object> future = this.completionService.submit(callable);
        return future;
    }

    public void addDaily() {
        if (this.dummyFuture == null) {
            DummyRunnable dummyRunnable = new DummyRunnable();
            this.dummyFuture = this.scheduledExecutorServiceDummy.scheduleWithFixedDelay(dummyRunnable, 0L, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    /* synthetic */ TskTaskManager(TskTaskManager tskTaskManager) {
        this();
    }

    protected class DummyRunnable
    implements Runnable {
        @Override
        public void run() {
            BcLogUtil.debug("run -------");
        }
    }

    private static final class SingletonHolder {
        private static final TskTaskManager instance = new TskTaskManager(null);

        private SingletonHolder() {
        }
    }
}

