/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.task;

import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.base.thread.BcMonitor;
import ext.lib.task.TskTaskContext;
import ext.lib.task.TskTaskEventHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public abstract class TskAbstractCallable<T>
extends BcLoggableObject
implements Callable {
    protected TskTaskContext taskContext = new TskTaskContext();
    private BcMonitor monitor;
    private Throwable throwable;
    private List<TskTaskEventHandler> taskEventHandlerList = new ArrayList<TskTaskEventHandler>();

    public TskAbstractCallable() {
        this.setLogger(BcLogUtil.getDefaultLogger());
    }

    public TskTaskContext getTaskContext() {
        return this.taskContext;
    }

    public BcMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(BcMonitor monitor) {
        this.monitor = monitor;
    }

    public String getTitle() {
        return this.getClass().getName();
    }

    public final T call() throws Exception {
        T respons;
        block8: {
            this.throwable = null;
            this.taskStarted();
            respons = null;
            try {
                try {
                    respons = this.taskProcess();
                    this.taskFinished();
                }
                catch (Exception ex) {
                    this.throwable = ex;
                    this.taskError(ex);
                    if (this.monitor != null) {
                        this.monitor.unLock();
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (this.monitor != null) {
                    this.monitor.unLock();
                }
                throw throwable;
            }
            if (this.monitor != null) {
                this.monitor.unLock();
            }
        }
        return respons;
    }

    protected abstract T taskProcess() throws Exception;

    public void taskStarted() {
        this.taskContext.startTime = System.currentTimeMillis();
        TskTaskEventHandler[] taskEventHandlers = this.taskEventHandlerList.toArray(new TskTaskEventHandler[0]);
        int i = 0;
        while (i < taskEventHandlers.length) {
            try {
                taskEventHandlers[i].taskStarted();
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
            ++i;
        }
    }

    protected void taskFinished() {
        TskTaskEventHandler[] taskEventHandlers = this.taskEventHandlerList.toArray(new TskTaskEventHandler[0]);
        int i = 0;
        while (i < taskEventHandlers.length) {
            try {
                taskEventHandlers[i].taskFinished();
            }
            catch (Exception ex2) {
                this.getLogger().error(ex2);
            }
            ++i;
        }
    }

    protected void taskError(Throwable throwable) {
        this.throwable = throwable;
        TskTaskEventHandler[] taskEventHandlers = this.taskEventHandlerList.toArray(new TskTaskEventHandler[0]);
        int i = 0;
        while (i < taskEventHandlers.length) {
            try {
                taskEventHandlers[i].taskError(throwable);
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
            ++i;
        }
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void addTaskEventHandler(TskTaskEventHandler eventHandler) {
        this.taskEventHandlerList.add(eventHandler);
    }

    public boolean removeTaskEventHandler(TskTaskEventHandler eventHandler) {
        return this.taskEventHandlerList.remove(eventHandler);
    }
}

