/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.core.BcBooleanUtil;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdRenderingConverter;
import ext.base.mmd.MmdUtil;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableContext;
import ext.base.table.BcTableModel;
import ext.base.table.BcTableUtil;
import ext.base.util.BcCompareUtil;
import ext.base.util.BcConditionElement;
import ext.base.util.BcGeneralComparator;
import ext.lib.awt.AwtColorUtil;
import ext.lib.awt.AwtFontUtil;
import ext.lib.html.util.EtcHtmlUtil;
import ext.lib.swg.BcConditionTableView;
import ext.lib.swg.SwgNumberField;
import ext.lib.swg.SwgTableView;
import ext.lib.swg.SwgTextField;
import ext.lib.swg.lookAndFeel.SwgLafManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SwgTableViewUtil {
    public static int HEADER_HEIGHT;
    public static int COLUMN_MARGIN;
    public static int ROW_HEIGHT;
    public static int ROW_MARGIN;
    static double margin;
    static double minWidth;
    public static Dimension INTERCELL_SPACING;

    static {
        COLUMN_MARGIN = 1;
        ROW_MARGIN = 1;
        margin = 10.0;
        INTERCELL_SPACING = new Dimension(COLUMN_MARGIN, ROW_MARGIN);
        try {
            int textHeight = AwtFontUtil.getTextSize((Font)SwgLafManager.getInstance().font).height;
            int rowCount = 2;
            HEADER_HEIGHT = SwgTableViewUtil.calcHeaderHeight(textHeight, rowCount);
            ROW_HEIGHT = textHeight + 6;
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    private SwgTableViewUtil() throws Exception {
    }

    public static void setEditable(BcTableColumnModel tableColumnModel, boolean isEditable) {
        int i = 0;
        while (i < tableColumnModel.getColumnCount()) {
            BcTableColumn tableColumn = (BcTableColumn)tableColumnModel.getColumn(i);
            tableColumn.isEditable = isEditable;
            ++i;
        }
    }

    public static void setColumnWidth(BcTableColumn tableColumn, Font font) throws Exception {
        tableColumn.defaultWidth = SwgTableViewUtil.calcColumnWidth(tableColumn, font);
        tableColumn.setPreferredWidth((int)tableColumn.defaultWidth);
        tableColumn.setWidth((int)tableColumn.defaultWidth);
        if (tableColumn.defaultWidth <= 0.0) {
            tableColumn.setMinWidth(0);
            tableColumn.setMaxWidth(0);
        }
    }

    public static double calcColumnWidth(TableColumn tableColumn, Font font) throws Exception {
        MmdField mmdField = null;
        if (BcTableColumn.class.isAssignableFrom(tableColumn.getClass())) {
            BcTableColumn tableColumn2 = (BcTableColumn)tableColumn;
            mmdField = tableColumn2.getMmdField();
        }
        return SwgTableViewUtil.calcColumnWidth(mmdField, tableColumn.getHeaderValue(), font);
    }

    public static double calcColumnWidth(MmdField mmdField, Object headerValue, Font font) throws Exception {
        if (mmdField != null && mmdField.columnCount >= 0) {
            Dimension dim = AwtFontUtil.getTextSize(font, mmdField.columnCount);
            return (double)dim.width + margin;
        }
        double width1 = -1.0;
        if (headerValue != null && CharSequence.class.isAssignableFrom(headerValue.getClass())) {
            CharSequence charSequence = (CharSequence)headerValue;
            List<String> strList = EtcHtmlUtil.toStringList(charSequence);
            int i = 0;
            while (i < strList.size()) {
                String str = strList.get(i);
                Dimension dim = AwtFontUtil.getTextSize(font, str);
                width1 = Math.max(width1, (double)(dim.width + 4));
                ++i;
            }
        }
        double width2 = Math.max(width1, SwgTableViewUtil.getMinWidth(font));
        return width2;
    }

    public static double getMinWidth(Font font) {
        if (minWidth <= 0.0) {
            Dimension dim = AwtFontUtil.getTextSize(font, 16);
            minWidth = (double)dim.width + margin;
        }
        return minWidth;
    }

    public static int addRowSelection(JTable tableView, int[] indexs) {
        int cnt = 0;
        int[] nArray = indexs;
        int n = indexs.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index >= 0 && index <= tableView.getRowCount() - 1) {
                tableView.addRowSelectionInterval(index, index);
                ++cnt;
            }
            ++n2;
        }
        return cnt;
    }

    public static int addRowSelection(JTable tableView, int index1, int index2) {
        int cnt = 0;
        if (index1 >= 0 && index2 <= tableView.getRowCount() - 1) {
            tableView.addRowSelectionInterval(index1, index2);
            cnt += Math.abs(index1 - index2) + 1;
        }
        return cnt;
    }

    public static int addRowSelection(JTable tableView, int index1) {
        return SwgTableViewUtil.addRowSelection(tableView, index1, index1);
    }

    public static void setValueAllRow(JTable tableView, Object value, int ... columnIds) {
        int i = 0;
        while (i < tableView.getRowCount()) {
            int rowId = i;
            int j = 0;
            while (j < columnIds.length) {
                int columnId = columnIds[j];
                tableView.setValueAt(value, rowId, columnId);
                ++j;
            }
            ++i;
        }
        tableView.repaint();
    }

    public static List<List> getRowList(SwgTableView tableView, int[] rowIds, int[] columnIds) {
        TableModel tableModel = tableView.getModel();
        List<List> rowList = BcTableUtil.getValues(tableModel, rowIds, columnIds);
        return rowList;
    }

    public static List<List> getRowList(SwgTableView tableView, int[] rowIds, String ... tableColumnNames) throws Exception {
        BcTableColumnModel tableColumnModel = (BcTableColumnModel)tableView.getColumnModel();
        int[] columnIds = BcTableUtil.getColumnIds(tableColumnModel, true, tableColumnNames);
        return SwgTableViewUtil.getRowList(tableView, rowIds, columnIds);
    }

    public static List<List> getRowList(SwgTableView tableView, int rowId, String ... tableColumnNames) throws Exception {
        int[] rowIds = new int[]{rowId};
        return SwgTableViewUtil.getRowList(tableView, rowIds, tableColumnNames);
    }

    public static List<List> getSelectedRowList(SwgTableView tableView, int ... columnIds) throws Exception {
        int[] rowIds = tableView.getSelectedRows();
        return SwgTableViewUtil.getRowList(tableView, rowIds, columnIds);
    }

    public static List<List> getSelectedRowList(SwgTableView tableView, String ... tableColumnNames) throws Exception {
        BcTableColumnModel tableColumnModel = (BcTableColumnModel)tableView.getColumnModel();
        int[] columnIds = BcTableUtil.getColumnIds(tableColumnModel, true, tableColumnNames);
        return SwgTableViewUtil.getSelectedRowList(tableView, columnIds);
    }

    public static List getSelectedRowTop(SwgTableView tableView, String ... tableColumnNames) throws Exception {
        List<List> rowList = SwgTableViewUtil.getSelectedRowList(tableView, tableColumnNames);
        List row = null;
        if (rowList.size() > 0) {
            row = rowList.get(0);
        }
        return row;
    }

    public static List getSelectedValueList(SwgTableView tableView, String tableColumnName) throws Exception {
        List<List> rowList = SwgTableViewUtil.getSelectedRowList(tableView, tableColumnName);
        ArrayList valueList = new ArrayList();
        int i = 0;
        while (i < rowList.size()) {
            List row = rowList.get(i);
            valueList.add(row.get(0));
            ++i;
        }
        return valueList;
    }

    public static int[] selectSameValueRow(JTable tableView, int columnId, Collection<?> valueCollection, Comparator comparator) throws Exception {
        TableModel tableModel = tableView.getModel();
        List<Integer> rowIdList = BcTableUtil.getSameValueRowIndex(tableModel, columnId, valueCollection, comparator);
        int[] rowIds = BcNumberUtil.toIntArray(rowIdList);
        SwgTableViewUtil.addRowSelection(tableView, rowIds);
        return rowIds;
    }

    public static int[] selectSameValueRow(JTable tableView, int columnId, Collection<?> valueCollection) throws Exception {
        return SwgTableViewUtil.selectSameValueRow(tableView, columnId, valueCollection, BcGeneralComparator.getInstance());
    }

    public static int getSelectedCount(ListSelectionModel listSelectionModel) {
        int iMin = listSelectionModel.getMinSelectionIndex();
        int iMax = listSelectionModel.getMaxSelectionIndex();
        if (iMin == -1 || iMax == -1) {
            return 0;
        }
        int[] rvTmp = new int[1 + (iMax - iMin)];
        int cnt = 0;
        int i = iMin;
        while (i <= iMax) {
            if (listSelectionModel.isSelectedIndex(i)) {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    public static Component getCellComponent_Number(MmdField mmdField, Object cellValue, Class valueClass, boolean isEditor, MmdRenderingConverter renderingConverter, SwgNumberField decimalField, JLabel label) throws Exception {
        if (!Number.class.isAssignableFrom(valueClass)) {
            return null;
        }
        Number number = (Number)cellValue;
        if (isEditor) {
            if (BcNumberUtil.isIntegeraClass(mmdField.dataClass)) {
                decimalField.setDecimalPosition(0);
            } else if (BcNumberUtil.isFloatingaPointClass(mmdField.dataClass) || mmdField.dataClass.equals(BigDecimal.class)) {
                decimalField.setDecimalPosition(mmdField.decimalPosition);
                decimalField.setNullable(BcBooleanUtil.toBoolean(mmdField.nullable));
            }
            decimalField.setValue(number);
            decimalField.selectAll();
            return decimalField;
        }
        String text = renderingConverter.toString(mmdField, cellValue);
        label.setText(text);
        label.setHorizontalAlignment(MmdUtil.getHorizonalAlignment(mmdField));
        return label;
    }

    public static Component getCellComponent_Calendar(MmdField mmdField, Object cellValue, Class valueClass, boolean isEditor, SwgTextField textField, JLabel label) throws Exception {
        Calendar calendar = null;
        if (Calendar.class.isAssignableFrom(valueClass) || Date.class.isAssignableFrom(valueClass)) {
            if (Calendar.class.isAssignableFrom(valueClass)) {
                calendar = (Calendar)cellValue;
            } else if (Date.class.isAssignableFrom(valueClass)) {
                calendar = BcTimeUtil.toCalendar((Date)cellValue);
            }
        }
        if (calendar == null) {
            return null;
        }
        if (isEditor) {
            String str = BcTimeUtil.toString(calendar, mmdField.formatPatternWork);
            textField.setText(str);
            textField.selectAll();
            return textField;
        }
        String str = BcTimeUtil.toString(calendar, mmdField.formatPatternWork);
        label.setText(str);
        label.setHorizontalAlignment(MmdUtil.getHorizonalAlignment(mmdField));
        return label;
    }

    public static Component getCellComponent_Boolean(MmdField mmdField, Object cellValue, Class valueClass, boolean isEditor, boolean isEditable, JCheckBox checkBox, JLabel label) throws Exception {
        if (!Boolean.class.isAssignableFrom(valueClass)) {
            return null;
        }
        Boolean bool = (Boolean)cellValue;
        if (isEditor || isEditable) {
            checkBox.setSelected(bool);
            return checkBox;
        }
        label.setText(BcBooleanUtil.toYN(bool));
        label.setHorizontalAlignment(MmdUtil.getHorizonalAlignment(mmdField));
        return label;
    }

    public static Component getCellComponent_Text(MmdField mmdField, Object cellValue, Class valueClass, boolean isEditor, SwgTextField textField, JLabel label) throws Exception {
        if (isEditor) {
            textField.setText(cellValue.toString());
            textField.setHorizontalAlignment(MmdUtil.getHorizonalAlignment(mmdField));
            textField.selectAll();
            return textField;
        }
        label.setText(cellValue.toString());
        label.setHorizontalAlignment(MmdUtil.getHorizonalAlignment(mmdField));
        return label;
    }

    public static List getSelectedValueList(JTable tableView, int columnIndex, boolean isUnique, Comparator comparator) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        int tmpId = -1;
        int[] rowIds = tableView.getSelectedRows();
        if (rowIds.length > 0) {
            int i = 0;
            while (i < rowIds.length) {
                Object obj1 = tableView.getValueAt(rowIds[i], columnIndex);
                if (isUnique) {
                    tmpId = -1;
                    int j = 0;
                    while (j < valueList.size()) {
                        Object obj2 = valueList.get(j);
                        if (comparator.compare(obj1, obj2) == BcCompareUtil.Comparison.equals.value) {
                            tmpId = j;
                            break;
                        }
                        ++j;
                    }
                    if (tmpId < 0) {
                        valueList.add(obj1);
                    }
                } else {
                    valueList.add(obj1);
                }
                ++i;
            }
        }
        return valueList;
    }

    public static int calcHeaderHeight(int textHeight, int rowCount) {
        int topMargin = 6;
        int botomMargin = 6;
        int rowDiff = 6;
        int headerHeight = topMargin + botomMargin + textHeight * rowCount + rowDiff * (rowCount - 1);
        return headerHeight;
    }

    public static Rectangle scrollRectToVisible(JTable jTable, int rowId, int columnId) {
        Rectangle rectangle = jTable.getCellRect(rowId, columnId, true);
        jTable.scrollRectToVisible(rectangle);
        return rectangle;
    }

    public static List getSelectedValueList(JTable tableView, int columnIndex, boolean isUnique) {
        return SwgTableViewUtil.getSelectedValueList(tableView, columnIndex, isUnique, BcGeneralComparator.getInstance());
    }

    public static Color toGridColor(Color baseColor) {
        return AwtColorUtil.toColor(baseColor, -40);
    }

    public static Color toRowOddBg(Color baseColor) {
        return AwtColorUtil.toColor(baseColor, -15);
    }

    public static Color toRowEvenBg(Color baseColor) {
        return AwtColorUtil.toColor(baseColor, -25);
    }

    public static Color toRowSelectedBg(Color baseColor) {
        return AwtColorUtil.toSelectionColor(baseColor, -20);
    }

    public static Color toRowSelectedFg(Color baseColor) {
        return AwtColorUtil.toComplementaryColor(baseColor, 0);
    }

    public static void setHeaderHeight(JTable jTable, int height) throws Exception {
        Dimension dim = jTable.getTableHeader().getPreferredSize();
        dim.height = height;
        jTable.getTableHeader().setPreferredSize(dim);
    }

    public static int setHeaderRowCount(JTable jTable, int rowCount) throws Exception {
        int textHeight = AwtFontUtil.getTextSize((Font)SwgLafManager.getInstance().font).height;
        int height = SwgTableViewUtil.calcHeaderHeight(textHeight, rowCount);
        SwgTableViewUtil.setHeaderHeight(jTable, height);
        return height;
    }

    public static SwgTableView createConditionTableView(BcTableContext tableContext) throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        SwgTableViewUtil.createConditionTableColumnModel(tableColumnModel);
        BcTableModel tableModel = new BcTableModel(tableColumnModel);
        SwgTableViewUtil.createConditionTable(tableContext.getConditionList(), tableModel);
        BcConditionTableView tableView = new BcConditionTableView(tableModel, tableColumnModel);
        return tableView;
    }

    public static void createConditionTable(List<? extends BcConditionElement> conditionList, BcTableModel tableModel) {
        int i = 0;
        while (i < conditionList.size()) {
            BcConditionElement conditionElement = conditionList.get(i);
            ArrayList<String> row = new ArrayList<String>();
            row.add(conditionElement.name);
            row.add(":");
            row.add(conditionElement.value);
            tableModel.addRow(row);
            ++i;
        }
    }

    public static void createConditionTableColumnModel(BcTableColumnModel tableColumnModel) {
        BcTableColumn tableColumn = null;
        MmdField mmdField = null;
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.horizonalAlignment = 4;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumn.setMinWidth(140);
        tableColumn.setMaxWidth(140);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.horizonalAlignment = 0;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumn.setMinWidth(10);
        tableColumn.setMaxWidth(10);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.horizonalAlignment = 2;
        tableColumn.setMmdField(mmdField);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumn.setMinWidth(200);
        tableColumn.setMaxWidth(200);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
    }
}

