/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.swg.SwgDecoratePanel;
import ext.lib.swg.SwgFrame;
import ext.lib.swg.SwgTextArea;
import ext.lib.swg.SwgUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;

class EswgExceptionPanel
extends SwgDecoratePanel {
    protected SwgTextArea textArea = new SwgTextArea();
    protected Window window;

    public EswgExceptionPanel() throws Exception {
        this.setBorderSize(10, 40, 8, 8);
        this.setLine();
        this.setOkButton(BcWords.getInstance().completion);
        this.setCancelButton(BcWords.getInstance().cancel);
        String explanation = "\u4f8b\u5916\u306e\u5185\u5bb9\u3092\u5831\u544a\u3057\u307e\u3059\u3002";
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.textArea, "Center");
    }

    @Override
    protected void okButtonAction() throws Exception {
        this.close();
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        super.cancelButtonAction();
        this.close();
    }

    @Override
    public void close() {
        this.window.dispose();
    }

    public void showAsFrame() throws Exception {
        SwgFrame frame = new SwgFrame();
        frame.getContentPane().add((Component)this, "Center");
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    EswgExceptionPanel.this.cancelButtonAction();
                }
                catch (Exception ex) {
                    EswgExceptionPanel.this.handleException(ex);
                }
            }
        });
        frame.setResizable(true);
        frame.setTitle(BcWords.getInstance().exception);
        frame.setIconImage(AwtImageHelper.getWindowIconImage());
        this.window = frame;
        SwgUtil.setCenter(this.window, 780.0, 440.0);
        this.window.setVisible(true);
        this.window.toFront();
    }

    public void showAsDialog(Component parentComponent) throws Exception {
        JDialog dialog = new JDialog(SwgUtil.getWindow(parentComponent));
        dialog.getContentPane().add((Component)this, "Center");
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    EswgExceptionPanel.this.cancelButtonAction();
                }
                catch (Exception ex) {
                    EswgExceptionPanel.this.handleException(ex);
                }
            }
        });
        dialog.setResizable(true);
        dialog.setTitle(BcWords.getInstance().exception);
        dialog.setIconImage(AwtImageHelper.getWindowIconImage());
        this.window = dialog;
        SwgUtil.setCenter(this.window, 780.0, 440.0);
        this.window.setVisible(true);
        this.window.toFront();
    }
}

