/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.base.core.BcStringUtil;
import ext.base.io.BcStreamUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdModel;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlResultSet_SQLServer;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.context.SqlTableMetadata;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SqlContext_SQLServer
extends SqlContext {
    public static final String DRIVER_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String[] DRIVER_NAMES = new String[]{"com.microsoft.sqlserver.jdbc.SQLServerDriver"};
    public static final int PORT_DEFAULT = 1433;

    public SqlContext_SQLServer(SqlConstants.DatabaseProduct productName) {
        super(productName);
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_NAMES;
    }

    @Override
    public int getDefaultPort() {
        return 1433;
    }

    @Override
    public void setTransactionIsolation(SqlConnection dbCon) throws Exception {
        dbCon.setTransactionIsolation(2);
    }

    @Override
    protected void getTableMetadata(ResultSet rs, SqlTableMetadata tableMetadata) throws Exception {
        tableMetadata.TABLE_CAT = rs.getString("TABLE_CAT");
        tableMetadata.TABLE_SCHEM = rs.getString("TABLE_SCHEM");
        tableMetadata.TABLE_NAME = rs.getString("TABLE_NAME");
        tableMetadata.TABLE_TYPE = rs.getString("TABLE_TYPE");
        tableMetadata.REMARKS = rs.getString("REMARKS");
    }

    @Override
    public String type_TINYINT() {
        return this.type_SMALLINT();
    }

    @Override
    public String type_BIGINT() {
        return "MONEY";
    }

    @Override
    public String type_NUMERIC(int precision, int scale) {
        return "DECIMAL(" + precision + ", " + scale + ")";
    }

    @Override
    public String type_CHAR(int size) {
        if (size <= 255) {
            return "CHAR(" + size + ")";
        }
        return this.type_CLOB();
    }

    @Override
    public String type_VARCHAR(int size) {
        if (size <= 255) {
            return "VARCHAR(" + size + ")";
        }
        return this.type_CLOB();
    }

    @Override
    public String type_CLOB() {
        return "LONGTEXT";
    }

    @Override
    public String type_BLOB() {
        return this.type_LONGVARBINARY();
    }

    @Override
    public String escapEncode(String srcStr) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (srcStr == null) {
            return sb.toString();
        }
        char curChar = '\u0000';
        int i = 0;
        while (i < srcStr.length()) {
            curChar = srcStr.charAt(i);
            switch (curChar) {
                case '\'': {
                    sb.append("''");
                    break;
                }
                default: {
                    sb.append(curChar);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String setLimit(String srcSql, int limit, int offset) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql.length() + 20);
        if (limit > 0) {
            String tmpStr = srcSql.toString().toUpperCase();
            int index = tmpStr.indexOf("SELECT");
            sb.append(srcSql.subSequence(0, index + 6));
            sb.append(" TOP " + limit);
            sb.append(srcSql.subSequence(index + 6, srcSql.length()));
        }
        if (offset > 0) {
            throw new Exception("not suported 'OFFSET'");
        }
        return sb.toString();
    }

    @Override
    public String getDateFormatForCondition() {
        return "yyyy/MM/dd";
    }

    @Override
    public void setNull_LONGVARBINARY(PreparedStatement ppst, int colmunIndex) throws Exception {
        SqlConstants.SqlType[] sqlTypeArray = SqlConstants.SqlType.values();
        int n = sqlTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SqlConstants.SqlType sqlType = sqlTypeArray[n2];
            try {
                BcLogUtil.warning("colmunIndex=" + colmunIndex + "  sqlType=" + (Object)((Object)sqlType));
                ppst.setNull(colmunIndex, sqlType.id);
                break;
            }
            catch (Exception exception) {
                ++n2;
            }
        }
    }

    @Override
    public void set_BLOB(PreparedStatement ppst, int colmunIndex, Blob blob) throws Exception {
        if (blob == null) {
            this.setNull_BLOB(ppst, colmunIndex);
            return;
        }
        InputStream is = blob.getBinaryStream();
        if (is == null) {
            this.setNull_BLOB(ppst, colmunIndex);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BcStreamUtil.transmit(is, byteArrayOutputStream, 1024);
        is.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        if (byteArrayOutputStream.size() > 0) {
            ppst.setBinaryStream(colmunIndex, (InputStream)byteArrayInputStream, byteArrayOutputStream.size());
        } else {
            this.setNull_BLOB(ppst, colmunIndex);
        }
    }

    @Override
    public void setNull_BLOB(PreparedStatement ppst, int colmunIndex) throws Exception {
        SqlConstants.SqlType[] sqlTypeArray = SqlConstants.SqlType.values();
        int n = sqlTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SqlConstants.SqlType sqlType = sqlTypeArray[n2];
            try {
                BcLogUtil.warning("colmunIndex=" + colmunIndex + "  sqlType=" + (Object)((Object)sqlType));
                ppst.setNull(colmunIndex, sqlType.id);
                break;
            }
            catch (Exception exception) {
                ++n2;
            }
        }
    }

    @Override
    public int dropView(SqlConnection dbCon, String viewName) throws Exception {
        String query = "DROP TABLE " + viewName;
        BcLogUtil.info("query=" + query);
        return SqlUtil.executeUpdate(dbCon, query);
    }

    @Override
    public boolean isSelectForUpdateEnabled() throws Exception {
        return false;
    }

    @Override
    public MmdModel convertReservedWord(MmdModel mmdModel) throws Exception {
        MmdModel mmdModel2 = (MmdModel)mmdModel.clone();
        int i = 0;
        while (i < mmdModel2.getFieldCount()) {
            MmdField mmdField = mmdModel2.getField(i);
            if (BcStringUtil.equalsIgnoreCase(mmdField.columnName, "note")) {
                mmdField.columnName = "note_";
                mmdField.tableColumnName = BcStringUtil.replace((CharSequence)mmdField.tableColumnName, "note", "note_").toString();
            }
            ++i;
        }
        return mmdModel2;
    }

    @Override
    public String escapeForPatternMatch(String pattern) throws Exception {
        StringBuilder sb = new StringBuilder(pattern.length() + 20);
        int i = 0;
        while (i < pattern.length()) {
            char curChar = pattern.charAt(i);
            switch (curChar) {
                case '%': 
                case '[': 
                case '_': {
                    sb.append('[');
                    sb.append(curChar);
                    sb.append(']');
                    break;
                }
                default: {
                    sb.append(curChar);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("SUBSTRING(");
        sb.append(columnName);
        if (length > 0) {
            sb.append("," + length);
        }
        if (length > 0) {
            sb.append("," + length);
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex) throws Exception {
        return this.func_substring(columnName, startIndex, -1);
    }

    @Override
    public SqlResultSet convToSqlResultSet(ResultSet rs) throws SQLException {
        return new SqlResultSet_SQLServer(rs, this);
    }
}

