/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdIndexElement;
import ext.base.mmd.MmdModel;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.context.SqlContext;

public class SqlContext_MySQL
extends SqlContext {
    public static final String DRIVER_NAME = "com.mysql.jdbc.Driver";
    public static final String[] DRIVER_NAMES = new String[]{"com.mysql.jdbc.Driver"};
    public static final int PORT_DEFAULT = 3306;

    public SqlContext_MySQL(SqlConstants.DatabaseProduct databaseProduct) {
        super(databaseProduct);
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_NAMES;
    }

    @Override
    public int getDefaultPort() {
        return 3306;
    }

    @Override
    public String type_TINYINT() {
        return this.type_SMALLINT();
    }

    @Override
    public String type_NUMERIC(int precision, int scale) {
        return "NUMERIC(" + precision + ", " + scale + ")";
    }

    @Override
    public String type_CHAR(int size) {
        if (size <= 255) {
            return "CHAR(" + size + ")";
        }
        return this.type_CLOB();
    }

    @Override
    public String type_VARCHAR(int size) {
        if (size <= 255) {
            return "VARCHAR(" + size + ")";
        }
        return this.type_CLOB();
    }

    @Override
    public String type_LONGVARCHAR() {
        return "TEXT";
    }

    @Override
    public String type_CLOB() {
        return this.type_LONGVARCHAR();
    }

    @Override
    public String getTimestampFormatForUpdate() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    @Override
    public String getDateFormatForCondition() {
        return "yyyy-MM-dd";
    }

    @Override
    public String reformForMetadata(CharSequence objectName) throws Exception {
        if (objectName == null) {
            return null;
        }
        return objectName.toString().toLowerCase();
    }

    @Override
    public String setLimit(String srcSql, int limit, int offset) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql.length() + 20);
        sb.append(srcSql);
        if (limit > 0) {
            sb.append(" LIMIT " + limit);
        }
        if (offset > 0) {
            sb.append(" OFFSET " + offset);
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("MID(");
        sb.append(columnName);
        if (length > 0) {
            sb.append("," + length);
        }
        if (length > 0) {
            sb.append("," + length);
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex) throws Exception {
        return this.func_substring(columnName, startIndex, -1);
    }

    @Override
    public String createCreateTableSql_primaryKey(MmdModel mmdModel, String lineSep) throws Exception {
        StringBuilder sb = new StringBuilder();
        MmdIndex primaryKey = mmdModel.getPrimaryIndex();
        if (primaryKey != null) {
            sb.append("PRIMARY KEY");
            sb.append(" (");
            int i = 0;
            while (i < primaryKey.indexElementList.size()) {
                MmdIndexElement indexElement = primaryKey.indexElementList.get(i);
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(indexElement.columnName);
                ++i;
            }
            sb.append(")");
            sb.append(lineSep);
        }
        return sb.toString();
    }
}

