/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.lib.sql.SqlConstants;
import ext.lib.sql.context.SqlContext;

public class SqlContext_HSQLDB
extends SqlContext {
    public static final String DRIVER_NAME = "org.hsqldb.jdbcDriver";
    public static final String[] DRIVER_NAMES = new String[]{"org.hsqldb.jdbcDriver"};

    public SqlContext_HSQLDB(SqlConstants.DatabaseProduct databaseProduct) {
        super(databaseProduct);
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_NAMES;
    }

    @Override
    public String type_CHAR(int size) {
        if (size <= 255) {
            return "CHAR(" + size + ")";
        }
        return this.type_CLOB();
    }

    @Override
    public String type_VARCHAR(int size) {
        if (size <= 255) {
            return "VARCHAR(" + size + ")";
        }
        return this.type_CLOB();
    }

    @Override
    public String type_CLOB() {
        return "VARCHAR";
    }

    @Override
    public String getTimestampFormatForUpdate() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    @Override
    public String getDateFormatForCondition() {
        return "yyyy-MM-dd";
    }

    @Override
    public String setLimit(String srcSql, int limit, int offset) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql.length() + 20);
        sb.append(srcSql);
        if (limit > 0) {
            sb.append(" LIMIT " + limit);
        }
        if (offset > 0) {
            sb.append(" OFFSET " + offset);
        }
        return sb.toString();
    }

    @Override
    public boolean isSelectForUpdateEnabled() throws Exception {
        return false;
    }
}

