/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.base.core.BcStringUtil;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.context.SqlContext;
import java.util.Map;

public class SqlContext_H2
extends SqlContext {
    public static final String DRIVER_NAME = "org.h2.Driver";
    public static final String[] DRIVER_NAMES = new String[]{"org.h2.Driver"};

    public SqlContext_H2(SqlConstants.DatabaseProduct databaseProduct) {
        super(databaseProduct);
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_NAMES;
    }

    @Override
    public int getSqlType(SqlConnection dbCon, String tableName, String columnName) throws Exception {
        String tableName2 = tableName.toUpperCase();
        String columnName2 = columnName.toUpperCase();
        return super.getSqlType(dbCon, tableName2, columnName2);
    }

    @Override
    public String getTimestampFormatForUpdate() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    @Override
    public String setLimit(String srcSql, int limit, int offset) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql.length() + 20);
        sb.append(srcSql);
        if (limit > 0) {
            sb.append(" LIMIT " + limit);
        }
        if (offset > 0) {
            sb.append(" OFFSET " + offset);
        }
        return sb.toString();
    }

    @Override
    public String convertSql(String srcSql, Map<String, String> paramMap, SqlContext baseSqlContext) throws Exception {
        StringBuilder newSql = new StringBuilder(srcSql);
        newSql = BcStringUtil.replace(newSql, "without time zone", "", false);
        newSql = BcStringUtil.replace(newSql, "USING btree", "", false);
        newSql = BcStringUtil.replace(newSql, "ALTER TABLE ONLY", "ALTER TABLE", false);
        return newSql.toString();
    }

    public static String cretaeUrl(Protocol protocol, String databaseName, boolean ifExists, boolean dbCloseOnExit) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(protocol.value);
        sb.append(databaseName);
        if (ifExists) {
            sb.append(";IFEXISTS=" + ifExists);
        }
        if (dbCloseOnExit) {
            sb.append(";DB_CLOSE_ON_EXIT=" + dbCloseOnExit);
        }
        return sb.toString();
    }

    public static String cretaeUrlFile(String dbPath) throws Exception {
        return SqlContext_H2.cretaeUrl(Protocol.file, dbPath, true, true);
    }

    public static enum Protocol {
        file("jdbc:h2:file:"),
        mem("jdbc:h2:mem:"),
        tcp("jdbc:h2:tcp:");

        public final String value;

        private Protocol(String value) {
            this.value = value;
        }
    }
}

