/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.lib.sql.SqlConstants;
import ext.lib.sql.context.SqlContext;

public class SqlContext_DB2
extends SqlContext {
    public static final String DRIVER_NAME = "com.ibm.db2.jcc.DB2Driver";
    public static final String[] DRIVER_NAMES = new String[]{"com.ibm.db2.jcc.DB2Driver"};
    public static final int PORT_DEFAULT = 50000;

    public SqlContext_DB2(SqlConstants.DatabaseProduct databaseProduct) {
        super(databaseProduct);
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_NAMES;
    }

    @Override
    public int getDefaultPort() {
        return 50000;
    }

    @Override
    public String type_BIT() {
        return "SMALLINT";
    }

    @Override
    public String type_CLOB() {
        return "TEXT";
    }

    @Override
    public String type_BLOB() {
        return "bytea";
    }

    @Override
    public String setLimit(String srcSql, int limit, int offset) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql.length() + 20);
        sb.append(srcSql);
        if (limit > 0) {
            sb.append(" LIMIT " + limit);
        }
        if (offset > 0) {
            sb.append(" OFFSET " + offset);
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("SUBSTR(");
        sb.append(columnName);
        if (length > 0) {
            sb.append("," + length);
        }
        if (length > 0) {
            sb.append("," + length);
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex) throws Exception {
        return this.func_substring(columnName, startIndex, -1);
    }
}

