/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.io.BcStreamUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdModel;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlResultSet_Access;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.context.SqlTableMetadata;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class SqlContext_Access
extends SqlContext {
    public static final String DRIVER_NAME = "sun.jdbc.odbc.JdbcOdbcDriver";
    public static final String[] DRIVER_NAMES = new String[]{"sun.jdbc.odbc.JdbcOdbcDriver"};
    public static final String URL_PREFIX = "jdbc:odbc:Driver";
    public static final String DBQ = "DBQ";

    public SqlContext_Access(SqlConstants.DatabaseProduct databaseProduct) {
        super(databaseProduct);
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_NAMES;
    }

    @Override
    public void setTransactionIsolation(SqlConnection dbCon) throws Exception {
    }

    @Override
    public String func_substring(String columnName, int startIndex) throws Exception {
        return this.func_substring(columnName, startIndex, -1);
    }

    @Override
    public SqlStatement createStatementForScroll(SqlConnection sqlConnection) throws Exception {
        SqlStatement stmt = sqlConnection.createStatement(1003, 1007);
        return stmt;
    }

    @Override
    public String getEncoding() throws Exception {
        return "SJIS";
    }

    @Override
    protected void getTableMetadata(ResultSet rs, SqlTableMetadata tableMetadata) throws Exception {
        tableMetadata.TABLE_CAT = rs.getString("TABLE_CAT");
        tableMetadata.TABLE_SCHEM = rs.getString("TABLE_SCHEM");
        tableMetadata.TABLE_NAME = rs.getString("TABLE_NAME");
        tableMetadata.TABLE_TYPE = rs.getString("TABLE_TYPE");
        tableMetadata.REMARKS = rs.getString("REMARKS");
    }

    @Override
    public String type_BIGINT() {
        return "MONEY";
    }

    @Override
    public String type_NUMERIC(int precision, int scale) {
        return "MONEY";
    }

    @Override
    public String type_CHAR(int size) {
        if (size <= 255) {
            return "CHAR(" + size + ")";
        }
        return this.type_CLOB();
    }

    @Override
    public String type_VARCHAR(int size) {
        if (size <= 255) {
            return "VARCHAR(" + size + ")";
        }
        return this.type_LONGVARCHAR();
    }

    @Override
    public String type_LONGVARCHAR() {
        return "LONGTEXT";
    }

    @Override
    public String type_CLOB() {
        return this.type_LONGVARCHAR();
    }

    @Override
    public String type_LONGVARBINARY() {
        return "LONGBINARY";
    }

    @Override
    public String type_BLOB() {
        return this.type_LONGVARBINARY();
    }

    @Override
    public void setNull_LONGVARBINARY(PreparedStatement ppst, int colmunIndex) throws Exception {
        SqlConstants.SqlType[] sqlTypeArray = SqlConstants.SqlType.values();
        int n = sqlTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SqlConstants.SqlType sqlType = sqlTypeArray[n2];
            try {
                BcLogUtil.warning("colmunIndex=" + colmunIndex + "  sqlType=" + (Object)((Object)sqlType));
                ppst.setNull(colmunIndex, sqlType.id);
                break;
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                ++n2;
            }
        }
    }

    @Override
    public void set_BLOB(PreparedStatement ppst, int colmunIndex, Blob blob) throws Exception {
        if (blob == null) {
            this.setNull_BLOB(ppst, colmunIndex);
            return;
        }
        InputStream is = blob.getBinaryStream();
        if (is == null) {
            this.setNull_BLOB(ppst, colmunIndex);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BcStreamUtil.transmit(is, byteArrayOutputStream, 1024);
        is.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        if (byteArrayOutputStream.size() > 0) {
            ppst.setBinaryStream(colmunIndex, (InputStream)byteArrayInputStream, byteArrayOutputStream.size());
        } else {
            this.setNull_BLOB(ppst, colmunIndex);
        }
    }

    @Override
    public void setNull_BLOB(PreparedStatement ppst, int colmunIndex) throws Exception {
        SqlConstants.SqlType[] sqlTypeArray = SqlConstants.SqlType.values();
        int n = sqlTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SqlConstants.SqlType sqlType = sqlTypeArray[n2];
            try {
                BcLogUtil.warning("colmunIndex=" + colmunIndex + "  sqlType=" + (Object)((Object)sqlType));
                ppst.setNull(colmunIndex, sqlType.id);
                break;
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                ++n2;
            }
        }
    }

    @Override
    public int convSqlType(int sqlType) {
        switch (sqlType) {
            case -5: {
                return 2;
            }
        }
        return sqlType;
    }

    @Override
    public Object toJdbcValue(Object src) throws Exception {
        if (src == null) {
            return null;
        }
        Object jdbcValue = null;
        if (Long.class.isAssignableFrom(src.getClass())) {
            jdbcValue = BigDecimal.valueOf((Long)src);
        } else if (Calendar.class.isAssignableFrom(src.getClass())) {
            Calendar calendar = (Calendar)src;
            jdbcValue = new Timestamp(calendar.getTimeInMillis());
        } else {
            jdbcValue = super.toJdbcValue(src);
        }
        return jdbcValue;
    }

    @Override
    public String escapEncode(String srcStr) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (srcStr == null) {
            return sb.toString();
        }
        char curChar = '\u0000';
        int i = 0;
        while (i < srcStr.length()) {
            curChar = srcStr.charAt(i);
            switch (curChar) {
                case '\'': {
                    sb.append('\'');
                    sb.append('\'');
                    break;
                }
                default: {
                    sb.append(curChar);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String setLimit(String srcQuery, int limit, int offset) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (limit > 0) {
            String tmpStr = srcQuery.toString().toUpperCase();
            int pos = tmpStr.indexOf("SELECT");
            sb.append(srcQuery.subSequence(0, pos + 6));
            sb.append(" TOP " + limit);
            sb.append(srcQuery.subSequence(pos + 6, srcQuery.length()));
        }
        if (offset > 0) {
            throw new Exception("not suported 'OFFSET'");
        }
        return sb.toString();
    }

    @Override
    public String getDateFormatForCondition() {
        return "MM-dd-yyyy";
    }

    @Override
    public String toCondition_timestamp(Calendar calendar) {
        return "#" + BcTimeUtil.toString(calendar, this.getTimestampFormatForCondition()) + "#";
    }

    @Override
    public String toCondition_datetime(Calendar calendar) {
        return "#" + BcTimeUtil.toString(calendar, this.getDateTimeFormatForCondition()) + "#";
    }

    @Override
    public String toCondition_date(Calendar calendar) {
        return "#" + BcTimeUtil.toString(calendar, this.getDateFormatForCondition()) + "#";
    }

    @Override
    public int dropView(SqlConnection dbCon, String viewName) throws Exception {
        String sql = "DROP TABLE " + viewName;
        this.getLogger().info("sql=" + sql);
        return SqlUtil.executeUpdate(dbCon, sql);
    }

    @Override
    public boolean isSelectForUpdateEnabled() throws Exception {
        return false;
    }

    @Override
    public boolean inputStreamAvailableEnabled() throws Exception {
        return false;
    }

    @Override
    public MmdModel convertReservedWord(MmdModel mmdModel) throws Exception {
        MmdModel mmdModel2 = (MmdModel)mmdModel.clone();
        int i = 0;
        while (i < mmdModel2.getFieldCount()) {
            MmdField mmdField = mmdModel2.getField(i);
            if (BcStringUtil.equalsIgnoreCase(mmdField.columnName, "note")) {
                mmdField.columnName = "note_";
                mmdField.tableColumnName = BcStringUtil.replace((CharSequence)mmdField.tableColumnName, "note", "note_").toString();
            }
            ++i;
        }
        return mmdModel2;
    }

    @Override
    public String func_toChar(String columnName, String format) throws Exception {
        String formatStr;
        int idx;
        StringBuilder sb = new StringBuilder();
        sb.append("STR(");
        sb.append(columnName);
        int decimal = -1;
        int length = -1;
        if (!BcStringUtil.isEmpty(format) && (idx = (formatStr = format.toString()).indexOf(46)) >= 0) {
            decimal = formatStr.substring(idx).length();
        }
        if (length > 0) {
            sb.append("," + length);
        }
        if (decimal > 0) {
            sb.append("," + decimal);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String func_toChar(String columnName) throws Exception {
        return this.func_toChar(columnName, null);
    }

    @Override
    public String func_substring(String columnName, int startIndex, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("MID(");
        sb.append(columnName);
        if (startIndex > 0) {
            sb.append("," + startIndex);
        }
        if (length > 0) {
            sb.append("," + length);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String func_clockTimestamp() throws Exception {
        return "Now()";
    }

    @Override
    public boolean isScrollSupport() throws Exception {
        return false;
    }

    @Override
    public int truncateTable(SqlConnection dbCon, String tableName) throws Exception {
        return this.deleteAllRow(dbCon, tableName);
    }

    @Override
    public MmdIndex getPrimaryKey(SqlConnection sqlCon, String tableName) throws Exception {
        return null;
    }

    @Override
    public String getPrimaryKeyName(SqlConnection sqlCon, String tableName) throws Exception {
        return null;
    }

    @Override
    public String convertSql(String srcSql, Map<String, String> paramMap, SqlContext baseSqlContext) throws Exception {
        String tableName;
        BcLogUtil.debug("convertQuery:srcSql=" + srcSql);
        BcLogUtil.debug("convertQuery:paramMap=" + paramMap);
        StringBuilder sb = new StringBuilder(srcSql);
        sb = BcStringUtil.replace(sb, " BIGINT ", " MONEY ", false);
        sb = BcStringUtil.replace(sb, " CHARACTER(", " VARCHAR(", false);
        sb = BcStringUtil.replace(sb, " TEXT ", " LONGTEXT ", false);
        sb = BcStringUtil.replace(sb, " BYTEA ", " LONGBINARY ", false);
        sb = BcStringUtil.replace(sb, "DROP VIEW", "DROP TABLE", false);
        if (srcSql.toUpperCase().indexOf("DROP INDEX") >= 0 && !BcStringUtil.isEmpty(tableName = paramMap.get("$TABLE_NAME"))) {
            sb.append(" ON " + tableName);
        }
        sb = BcStringUtil.replace(sb, "without time zone", "", false);
        sb = BcStringUtil.replace(sb, "USING btree", "", false);
        sb = BcStringUtil.replace(sb, "ALTER TABLE ONLY", "ALTER TABLE", false);
        sb = this.conv1(sb.toString(), "DECIMAL", "MONEY");
        return sb.toString();
    }

    public StringBuilder conv1(CharSequence src, CharSequence rep1, CharSequence rep2) throws Exception {
        String tmpStr = src.toString();
        int idx1;
        while ((idx1 = tmpStr.toUpperCase().indexOf(" " + rep1 + "(")) >= 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(tmpStr.substring(0, idx1));
            String rest = tmpStr.substring(idx1);
            int idx2 = rest.indexOf(")");
            sb.append(" " + rep2);
            sb.append(rest.substring(idx2 + 1));
            tmpStr = sb.toString();
        }
        return new StringBuilder(tmpStr);
    }

    public static String createJdbcUrl(CharSequence filePath) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:odbc:Driver=");
        sb.append("{Microsoft Access Driver (*.mdb)}");
        sb.append(";");
        sb.append("DBQ=");
        sb.append(filePath);
        return sb.toString();
    }

    public static String extractDBQ(String jdbcUrl) throws Exception {
        int idx1 = jdbcUrl.indexOf(DBQ);
        if (idx1 <= 0) {
            return null;
        }
        String tmp1 = jdbcUrl.substring(idx1 + DBQ.length()).trim();
        String filePath = tmp1.substring(1);
        BcLogUtil.debug("filePath=" + filePath);
        return filePath;
    }

    @Override
    public SqlResultSet convToSqlResultSet(ResultSet rs) throws SQLException {
        return new SqlResultSet_Access(rs, this);
    }
}

