/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql;

import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.lib.sql.SqlCallableStatement;
import ext.lib.sql.SqlPreparedStatement;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.context.SqlContext;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class SqlConnection
extends BcLoggableObject
implements Connection {
    private Connection dbCon;
    private SqlContext sqlContext;
    protected long connectedTime;
    protected long statementTimeout;
    protected long lendinglTimeout;
    protected long lendingStartTime;
    protected long lendinglTimeoutTime;
    private long responseLogTime;
    private Object owner;
    private List<SqlStatement> statementList = new ArrayList<SqlStatement>();

    public SqlConnection(Connection dbCon, SqlContext sqlContext) throws Exception {
        this.dbCon = dbCon;
        this.sqlContext = sqlContext;
        this.clear();
    }

    public long getResponseLogTime() {
        return this.responseLogTime;
    }

    public void setResponseLogTime(long responseLogTime) {
        this.responseLogTime = responseLogTime;
    }

    @Override
    public SqlStatement createStatement() throws SQLException {
        SqlStatement stmt = this.createStatement(this.dbCon.createStatement());
        return stmt;
    }

    @Override
    public SqlPreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement ppst1 = this.dbCon.prepareStatement(sql);
        SqlPreparedStatement ppst2 = new SqlPreparedStatement(this, ppst1, this.sqlContext);
        ppst2.setLogger(this.getLogger());
        this.statementList.add(ppst2);
        return ppst2;
    }

    @Override
    public SqlCallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement callableStmt1 = this.dbCon.prepareCall(sql);
        SqlCallableStatement callableStmt2 = new SqlCallableStatement(this, callableStmt1, this.sqlContext);
        callableStmt2.setLogger(this.getLogger());
        this.statementList.add(callableStmt2);
        return callableStmt2;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.dbCon.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.dbCon.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.dbCon.getAutoCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        SqlConnection sqlConnection = this;
        synchronized (sqlConnection) {
            this.dbCon.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        SqlConnection sqlConnection = this;
        synchronized (sqlConnection) {
            this.dbCon.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        SqlConnection sqlConnection = this;
        synchronized (sqlConnection) {
            this.dbCon.close();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.dbCon.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.dbCon.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.dbCon.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.dbCon.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.dbCon.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.dbCon.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.dbCon.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.dbCon.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.dbCon.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.dbCon.clearWarnings();
    }

    @Override
    public SqlStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt1 = this.dbCon.createStatement(resultSetType, resultSetConcurrency);
        SqlStatement stmt2 = this.createStatement(stmt1);
        return stmt2;
    }

    @Override
    public SqlPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement ppstWk = this.dbCon.prepareStatement(sql, resultSetType, resultSetConcurrency);
        SqlPreparedStatement ppst = new SqlPreparedStatement(this, ppstWk, this.sqlContext);
        ppst.setLogger(this.getLogger());
        return ppst;
    }

    @Override
    public SqlCallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement callableStmt1 = this.dbCon.prepareCall(sql, resultSetType, resultSetConcurrency);
        SqlCallableStatement callableStmt2 = new SqlCallableStatement(this, callableStmt1, this.sqlContext);
        callableStmt2.setLogger(this.getLogger());
        return callableStmt2;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.dbCon.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.dbCon.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.dbCon.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.dbCon.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.dbCon.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.dbCon.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.dbCon.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.dbCon.releaseSavepoint(savepoint);
    }

    @Override
    public SqlStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stmt1 = this.dbCon.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        SqlStatement stmt2 = this.createStatement(stmt1);
        return stmt2;
    }

    @Override
    public SqlPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement ppst1 = this.dbCon.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        SqlPreparedStatement ppst2 = new SqlPreparedStatement(this, ppst1, this.sqlContext);
        ppst2.setLogger(this.getLogger());
        return ppst2;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement callableStmt1 = this.dbCon.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        SqlCallableStatement callableStmt2 = new SqlCallableStatement(this, callableStmt1, this.sqlContext);
        callableStmt2.setLogger(this.getLogger());
        return callableStmt2;
    }

    @Override
    public SqlPreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement ppst1 = this.dbCon.prepareStatement(sql, autoGeneratedKeys);
        SqlPreparedStatement ppst2 = new SqlPreparedStatement(this, ppst1, this.sqlContext);
        ppst2.setLogger(this.getLogger());
        return ppst2;
    }

    @Override
    public SqlPreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement ppst1 = this.dbCon.prepareStatement(sql, columnIndexes);
        SqlPreparedStatement ppst2 = new SqlPreparedStatement(this, ppst1, this.sqlContext);
        ppst2.setLogger(this.getLogger());
        return ppst2;
    }

    @Override
    public SqlPreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement ppst1 = this.dbCon.prepareStatement(sql, columnNames);
        SqlPreparedStatement ppst2 = new SqlPreparedStatement(this, ppst1, this.sqlContext);
        ppst2.setLogger(this.getLogger());
        return ppst2;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.dbCon.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.dbCon.getClientInfo();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.dbCon.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.dbCon.setClientInfo(properties);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.dbCon.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.dbCon.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.dbCon.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.dbCon.createSQLXML();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.dbCon.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.dbCon.createStruct(typeName, attributes);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.dbCon.isValid(timeout);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dbCon.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dbCon.unwrap(iface);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.dbCon.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.dbCon.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.dbCon.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.dbCon.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.dbCon.getNetworkTimeout();
    }

    public void clear() throws Exception {
        this.setStatementTimeout(-1L);
        this.setLendinglTimeout(-1L);
        this.setLendingStartTime(-1L);
        this.setLendinglTimeoutTime(-1L);
        this.lendinglTimeoutDisabled();
        this.setOwner(null);
    }

    public SqlContext getSqlContext() {
        return this.sqlContext;
    }

    public long getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(long connectedTime) {
        this.connectedTime = connectedTime;
    }

    public long getStatementTimeout() {
        return this.statementTimeout;
    }

    public void setStatementTimeout(long statementTimeout) {
        this.statementTimeout = statementTimeout;
    }

    public long getLendinglTimeout() {
        return this.lendinglTimeout;
    }

    public void setLendinglTimeout(long lendinglTimeout) {
        this.lendinglTimeout = lendinglTimeout;
    }

    public long getLendingStartTime() {
        return this.lendingStartTime;
    }

    public void setLendingStartTime(long lendingStartTime) {
        this.lendingStartTime = lendingStartTime;
    }

    public void lendinglTimeoutDisabled() {
        this.lendinglTimeout = -1L;
    }

    public long getLendinglTimeoutTime() {
        return this.lendinglTimeoutTime;
    }

    public void setLendinglTimeoutTime(long lendinglTimeoutTime) {
        this.lendinglTimeoutTime = lendinglTimeoutTime;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public boolean removeStatement(SqlStatement statement) throws SQLException {
        return this.statementList.remove(statement);
    }

    public void cancelStatement() throws SQLException {
        BcLogUtil.debug("cancelStatement...");
        SqlStatement[] statements = this.statementList.toArray(new SqlStatement[0]);
        int i = 0;
        while (i < statements.length) {
            SqlStatement statement = statements[i];
            statement.cancel();
            statement.close();
            ++i;
        }
    }

    public SqlStatement createStatement(Statement stmt1) throws SQLException {
        SqlStatement stmt2 = this.sqlContext.createStatement(this, stmt1);
        stmt2.setLogger(this.getLogger());
        stmt2.setTimeout(this.getStatementTimeout());
        stmt2.setResponseLogTime(this.responseLogTime);
        this.statementList.add(stmt2);
        return stmt2;
    }
}

