/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.rmi.server;

import ext.base.log.BcLogUtil;
import ext.base.net.BcAddressPort;
import ext.base.net.BcNetUtil;
import ext.base.thread.BcThread;
import ext.lib.rmi.agent.RmiAgentContext;
import ext.lib.rmi.server.RmiAcceptThread;
import ext.lib.rmi.server.RmiLogHandler;
import ext.lib.rmi.server.RmiRedirector;
import ext.lib.rmi.server.RmiRemoteAgent;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

class RmiAcceptThread_L2
extends BcThread {
    private RmiAcceptThread acceptThread;
    private Socket socket;

    public RmiAcceptThread_L2(RmiAcceptThread acceptThread, Socket socket) throws Exception {
        this.acceptThread = acceptThread;
        this.socket = socket;
        this.setPriority(1);
        this.startThread();
    }

    @Override
    protected void run2() throws Exception {
        this.stopThread();
        ObjectInputStream objis = new ObjectInputStream(this.socket.getInputStream());
        String protocolVersion = (String)objis.readObject();
        BcLogUtil.debug("protocolVersion=" + protocolVersion);
        if (protocolVersion.equals("rmix_100")) {
            this.clientType_rmixClient(this.socket);
        } else if (protocolVersion.equals("logger_100")) {
            RmiLogHandler logHandler = this.acceptThread.rmiServer.logHandler;
            logHandler.loggerClientAccepted(this.socket, objis);
        } else {
            ObjectOutputStream objos = new ObjectOutputStream(this.socket.getOutputStream());
            objos.writeObject(2);
            objos.writeObject("\u30d7\u30ed\u30c8\u30b3\u30eb\u30d0\u30fc\u30b8\u30e7\u30f3 " + protocolVersion + " \u306b\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
            objos.flush();
            objos.reset();
        }
    }

    protected void clientType_rmixClient(Socket socket) throws Exception {
        BcAddressPort redirectAddressPort = null;
        RmiRedirector redirector = this.acceptThread.rmiServer.getRedirector();
        if (redirector != null) {
            BcAddressPort remoteAddressPort = BcNetUtil.parseAddressPort(socket.getRemoteSocketAddress().toString());
            BcAddressPort exclusionAddressPort = new BcAddressPort();
            exclusionAddressPort.address = socket.getLocalAddress().getHostAddress();
            exclusionAddressPort.port = socket.getLocalPort();
            redirectAddressPort = redirector.getRedirect(remoteAddressPort.address, exclusionAddressPort);
        }
        ObjectOutputStream objos = new ObjectOutputStream(socket.getOutputStream());
        if (redirectAddressPort == null) {
            objos.writeObject(1);
            objos.flush();
            RmiAgentContext agentContext = new RmiAgentContext();
            RmiRemoteAgent remoteAgent = new RmiRemoteAgent(agentContext);
            remoteAgent.setSocket(socket);
            this.acceptThread.rmiServer.addRemoteAgent(remoteAgent);
        } else {
            String redirectUrl = String.valueOf(redirectAddressPort.address) + ":" + redirectAddressPort.port;
            BcLogUtil.debug("redirectUrl=" + redirectUrl);
            objos.writeObject(71);
            objos.writeObject(redirectUrl);
            objos.flush();
        }
    }
}

