/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.rmi.server;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.net.BcNetUtil;
import ext.base.thread.BcThread;
import ext.lib.rmi.server.RmiAcceptThread_L2;
import ext.lib.rmi.server.RmiServer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;

public class RmiAcceptThread
extends BcThread {
    protected RmiServer rmiServer;
    public ServerSocket serverSocket;
    public InetAddress inetAddress;

    public RmiAcceptThread(RmiServer rmiServer) throws Exception {
        this.rmiServer = rmiServer;
        this.setPriority(1);
    }

    public void startAccept(String address, int port, int backlogCount) throws Exception {
        if (!BcStringUtil.isEmpty(address)) {
            this.inetAddress = InetAddress.getByName(address);
            this.serverSocket = new ServerSocket(port, backlogCount, this.inetAddress);
        } else {
            List<InetAddress> localHostAddressList = BcNetUtil.getLocalHostAddressList();
            this.inetAddress = localHostAddressList.get(0);
            this.serverSocket = new ServerSocket(port, backlogCount, this.inetAddress);
        }
        BcLogUtil.info("accept started.");
        BcLogUtil.info("localHostAddress=" + this.inetAddress.getHostAddress());
        BcLogUtil.info("localHostName=" + this.inetAddress.getHostName());
        BcLogUtil.info("localPort=" + this.serverSocket.getLocalPort());
        BcLogUtil.info("backlog=" + backlogCount);
        this.startThread();
    }

    @Override
    protected void run2() throws Exception {
        Socket socket = this.serverSocket.accept();
        RmiAcceptThread_L2 acceptThread_L2 = new RmiAcceptThread_L2(this, socket);
    }
}

