/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.poi;

import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SSTRecord;

public class PoiBookParser
implements HSSFListener {
    protected SSTRecord sstRecord;

    public void processRecord(Record record) {
        switch (record.getSid()) {
            case 2057: {
                BOFRecord bof = (BOFRecord)record;
                if (bof.getType() == 5) {
                    System.out.println("Encountered workbook");
                    break;
                }
                if (bof.getType() != 16) break;
                System.out.println("Encountered sheet reference");
                break;
            }
            case 133: {
                BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
                System.out.println("New sheet named: " + boundSheetRecord.getSheetname());
                break;
            }
            case 520: {
                RowRecord rowRecord = (RowRecord)record;
                System.out.println("Row found, first column at " + rowRecord.getFirstCol() + " last column at " + rowRecord.getLastCol());
                break;
            }
            case 515: {
                NumberRecord numberRecord = (NumberRecord)record;
                System.out.println("Cell found with value " + numberRecord.getValue() + " at row " + numberRecord.getRow() + " and column " + numberRecord.getColumn());
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                int k = 0;
                while (k < this.sstRecord.getNumUniqueStrings()) {
                    System.out.println("String table value " + k + " = " + this.sstRecord.getString(k));
                    ++k;
                }
                break;
            }
            case 253: {
                LabelSSTRecord labelSSTRecord = (LabelSSTRecord)record;
                System.out.println("String cell found with value " + this.sstRecord.getString(labelSSTRecord.getSSTIndex()));
            }
        }
    }
}

