/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.orm.persistence;

import ext.base.core.BcInteger;
import ext.base.core.BcLangUtil;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.base.log.BcLogger;
import ext.base.mmd.MmdField;
import ext.base.reflect.BcReflectUtil;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcObjectConvertor;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.entity.OrmAddOnly;
import ext.lib.orm.entity.OrmAddition;
import ext.lib.orm.entity.OrmDataId;
import ext.lib.orm.entity.OrmGeneralData;
import ext.lib.orm.entity.OrmObjectId;
import ext.lib.orm.entity.OrmOverwrite;
import ext.lib.orm.persistence.OrmEntityContext;
import ext.lib.orm.persistence.OrmEntityContextManager;
import ext.lib.orm.persistence.OrmPersistence;
import ext.lib.orm.persistence.OrmPersistenceAddOnly;
import ext.lib.orm.persistence.OrmPersistenceAddition;
import ext.lib.orm.persistence.OrmPersistenceApplyPeriodDate;
import ext.lib.orm.persistence.OrmPersistenceApplyPeriodTimestamp;
import ext.lib.orm.persistence.OrmPersistenceDataId;
import ext.lib.orm.persistence.OrmPersistenceDomain;
import ext.lib.orm.persistence.OrmPersistenceObjectId;
import ext.lib.orm.persistence.OrmPersistenceOverwrite;
import ext.lib.orm.persistence.OrmPersistenceTreeNode;
import ext.lib.orm.persistence.OrmPersistenceUtil;
import ext.lib.sql.SqlPreparedStatement;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlUpdateSql;
import ext.lib.sql.model.SqlWhereElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OrmPersistenceProxy
extends BcLoggableObject {
    protected List<OrmPersistence> persistenceList;
    protected OrmPersistenceAddition persistenceAddition = new OrmPersistenceAddition();
    protected OrmPersistenceDataId persistenceDataId = new OrmPersistenceDataId();
    protected OrmPersistenceAddOnly persistenceAddOnly = new OrmPersistenceAddOnly();
    protected OrmPersistenceOverwrite persistenceOverwrite = new OrmPersistenceOverwrite();
    public boolean logEnabled = false;

    private OrmPersistenceProxy() {
        this.persistenceList = new ArrayList<OrmPersistence>();
        this.persistenceList.add(new OrmPersistenceObjectId());
        this.persistenceList.add(this.persistenceDataId);
        this.persistenceList.add(this.persistenceAddition);
        this.persistenceList.add(new OrmPersistenceAddOnly());
        this.persistenceList.add(new OrmPersistenceOverwrite());
        this.persistenceList.add(new OrmPersistenceApplyPeriodTimestamp());
        this.persistenceList.add(new OrmPersistenceApplyPeriodDate());
        this.persistenceList.add(new OrmPersistenceTreeNode());
        this.persistenceList.add(new OrmPersistenceDomain());
    }

    public static OrmPersistenceProxy getInstance() {
        return SingletonHolder.instance;
    }

    protected void log(BcLogger logger, Object log) {
        if (this.logEnabled) {
            logger.debug(log);
        }
    }

    public int logicalDeleteByDataId(BcLogger logger, DtsSession dtsSession, String tableName, int dataId) throws Exception {
        int objectId = this.getObjectIdNewest(dtsSession, tableName, dataId);
        BcLogUtil.debug("logicalDeleteByDataId:objectId = " + objectId);
        return OrmPersistenceAddition.logicalDeleted(logger, dtsSession, tableName, objectId);
    }

    public int logicalDeleteByDataId(DtsSession dtsSession, String tableName, int dataId) throws Exception {
        return this.logicalDeleteByDataId(BcLogUtil.getDefaultLogger(), dtsSession, tableName, dataId);
    }

    public int logicalDeleteByObjectId(BcLogger logger, DtsSession dtsSession, String tableName, long objectId, int userId) throws Exception {
        BcLogUtil.debug("logicalDeleteByObjectId:objectId = " + objectId);
        return OrmPersistenceAddition.logicalDeleted(logger, dtsSession, tableName, objectId, userId);
    }

    public int physicalDeleteByObjectId(DtsSession dtsSession, String tableName, long objectId) throws Exception {
        boolean deletedCount = false;
        String sql = "DELETE FROM " + tableName + " WHERE " + "sy_oid" + "=" + objectId;
        return SqlUtil.executeUpdate(dtsSession.getConnection(), sql);
    }

    public int physicalDeleteByDataId(DtsSession dtsSession, String tableName, long dataId) throws Exception {
        boolean deletedCount = false;
        String sql = "DELETE FROM " + tableName + " WHERE " + "id" + "=" + dataId;
        return SqlUtil.executeUpdate(dtsSession.getConnection(), sql);
    }

    public StringBuilder createCommonSetPhrase(SqlContext sqlContext, Object entity) throws Exception {
        ArrayList<String> phraseList = new ArrayList<String>();
        int i = 0;
        while (i < this.persistenceList.size()) {
            OrmPersistence persistence = this.persistenceList.get(i);
            persistence.setSetClause(sqlContext, phraseList, entity);
            ++i;
        }
        StringBuilder sb = new StringBuilder(256);
        int i2 = 0;
        while (i2 < phraseList.size()) {
            if (i2 == 0) {
                sb.append(" ");
            } else {
                sb.append(",");
            }
            sb.append((String)phraseList.get(i2));
            ++i2;
        }
        return sb;
    }

    public void createCommonSetPhrase(SqlUpdateSql updateSql, Object entity) throws Exception {
        int i = 0;
        while (i < this.persistenceList.size()) {
            OrmPersistence persistence = this.persistenceList.get(i);
            persistence.setSetClause(updateSql, entity);
            ++i;
        }
    }

    public StringBuilder createCommonSelectPhrase(Class javaClassType, String tableAlias) throws Exception {
        ArrayList<String> columnNameList = new ArrayList<String>();
        int i = 0;
        while (i < this.persistenceList.size()) {
            OrmPersistence persistence = this.persistenceList.get(i);
            persistence.getSelectColumnName(columnNameList, tableAlias, javaClassType);
            ++i;
        }
        StringBuilder sb = new StringBuilder(256);
        int i2 = 0;
        while (i2 < columnNameList.size()) {
            if (i2 == 0) {
                sb.append(' ');
            } else {
                sb.append(',');
            }
            sb.append((String)columnNameList.get(i2));
            ++i2;
        }
        return sb;
    }

    public StringBuilder createCommonSelectPhrase(Class entityClass) throws Exception {
        return this.createCommonSelectPhrase(entityClass, null);
    }

    public void transResultset(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, Object entity) throws Exception {
        int i = 0;
        while (i < this.persistenceList.size()) {
            OrmPersistence persistence = this.persistenceList.get(i);
            persistence.setResultSet(dtsSession, rs, columnIndex, entity);
            ++i;
        }
    }

    public String createObjectIdWhereClause(long objectId) throws Exception {
        return " WHERE sy_oid=" + objectId;
    }

    public String createWhereClause(OrmObjectId objectIdentity) throws Exception {
        return this.createObjectIdWhereClause(objectIdentity.getObjectId());
    }

    public String createDataIdWhereClause(int dataId) throws Exception {
        return " WHERE id=" + dataId;
    }

    public String createDataIdWhereClause(OrmDataId etdmDataId) throws Exception {
        return this.createDataIdWhereClause(etdmDataId.getDataId());
    }

    public void createWhereClause(OrmGeneralData generalData, SqlUpdateSql updateSql) throws Exception {
        int i = 0;
        while (i < generalData.getModel().getFieldCount()) {
            MmdField mmdField = generalData.getModel().getField(i);
            if (mmdField.columnName.equals("sy_oid")) {
                Object valueObject = generalData.getValue(i);
                SqlWhereElement whereElement = new SqlWhereElement();
                whereElement.setLogical_AND();
                whereElement.setFormula("sy_oid" + SqlUtil.toWhere("=", valueObject, mmdField.sqlTypeId));
                updateSql.addWhereElement(whereElement);
            }
            ++i;
        }
    }

    public int putEntity(DtsSession dtsSession, int userId, String tableName, List<String> columnList, List<Object> valueList, Object entity, boolean isInsertCheck) throws Exception {
        Class<?> entityClass = entity.getClass();
        int updateCount = 0;
        if (OrmAddition.class.isAssignableFrom(entityClass)) {
            updateCount = this.persistenceAddition.putEntity(dtsSession, this, tableName, columnList, valueList, entity, isInsertCheck);
        } else if (OrmDataId.class.isAssignableFrom(entityClass)) {
            updateCount = this.persistenceDataId.putEntity(dtsSession, this, tableName, columnList, valueList, entity, isInsertCheck);
        }
        return updateCount;
    }

    public int putEntity(DtsSession dtsSession, int userId, String tableName, List<String> columnList, List<Object> valueList, Object entity) throws Exception {
        return this.putEntity(dtsSession, userId, tableName, columnList, valueList, entity, true);
    }

    public int putEntity(DtsSession dtsSession, String tableName, List<String> columnList, List<Object> valueList, Object entity) throws Exception {
        return this.putEntity(dtsSession, -1, tableName, columnList, valueList, entity);
    }

    public int putEntitys_1(DtsSession dtsSession, int userId, String tableName, int manipulationPolicy, BcLogger logger, Object ... entitys) throws Exception {
        if (entitys.length <= 0) {
            logger.warning("putEntity:entitys.length=" + entitys.length);
            return 0;
        }
        SqlContext sqlContext = dtsSession.getSqlContext();
        Class<?> entityClass = entitys[0].getClass();
        OrmEntityContext entityContext = OrmEntityContextManager.getInstance().getEntityContext(entityClass);
        List<Integer> sqlTypeList1 = entityContext.getSqlTypeList(dtsSession, tableName);
        SqlUpdateSql updateSql = entityContext.getUpdateSql(sqlContext, tableName);
        String updateSqlStr = null;
        SqlStatement ppstUpdate = null;
        boolean duUpdate = true;
        if (manipulationPolicy == 1) {
            duUpdate = false;
        } else if (BcCollectionUtil.isEmpty(updateSql.getWhereElementList())) {
            duUpdate = false;
        }
        if (duUpdate) {
            updateSqlStr = sqlContext.buildUpdateSqlForPrepareStatement(updateSql);
            this.log(logger, "updateSqlStr=" + updateSqlStr);
            ppstUpdate = dtsSession.getConnection().prepareStatement(updateSqlStr);
        }
        String insertSqlStr = null;
        SqlStatement ppstInsert = null;
        List<Object> valueList = null;
        int updateSummaryCount = 0;
        try {
            try {
                int i = 0;
                while (i < entitys.length) {
                    Object entity = entitys[i];
                    if (manipulationPolicy != 1) {
                        entityContext.autoSequence(dtsSession, tableName, entity);
                        if (OrmAddition.class.isAssignableFrom(entityClass)) {
                            this.persistenceAddition.preTrans(dtsSession, userId, tableName, entity);
                        } else if (OrmDataId.class.isAssignableFrom(entityClass)) {
                            if (OrmAddOnly.class.isAssignableFrom(entityClass)) {
                                this.persistenceAddOnly.preTrans(dtsSession, userId, tableName, entity);
                            }
                            if (OrmOverwrite.class.isAssignableFrom(entityClass)) {
                                this.persistenceOverwrite.preTrans(dtsSession, userId, tableName, entity);
                            }
                            this.persistenceDataId.preTrans(dtsSession, tableName, entity);
                        }
                    }
                    BcInteger typeIndex = new BcInteger();
                    ArrayList<Integer> sqlTypeList2 = new ArrayList<Integer>();
                    valueList = entityContext.createValueList(entity, true, sqlTypeList1, sqlTypeList2, typeIndex, null);
                    this.log(logger, "valueList=" + valueList);
                    int updateCount = 0;
                    if (ppstUpdate != null) {
                        updateCount = this.putEntity_update(dtsSession, entityContext, sqlTypeList2, valueList, tableName, (SqlPreparedStatement)ppstUpdate, entity, logger);
                        this.log(logger, "updateCount#1=" + updateCount);
                    }
                    if (updateCount <= 0) {
                        if (ppstInsert == null) {
                            insertSqlStr = entityContext.getInsertSqlText(sqlContext, tableName);
                            this.log(logger, "insertSqlStr=" + insertSqlStr);
                            ppstInsert = dtsSession.getConnection().prepareStatement(insertSqlStr);
                        }
                        updateCount = this.putEntity_insert(dtsSession, sqlTypeList2, valueList, (SqlPreparedStatement)ppstInsert, logger);
                        this.log(logger, "putEntity:updateCount#2=" + updateCount);
                    }
                    updateSummaryCount += updateCount;
                    if ((i + 1) % 100 == 0) {
                        logger.info("putEntity:" + tableName + " [" + (i + 1) + "/" + entitys.length + "]");
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                logger.error("updateSqlStr=" + updateSqlStr);
                logger.error("insertSqlStr=" + insertSqlStr);
                logger.error("valueList=" + valueList);
                throw ex;
            }
        }
        finally {
            if (ppstUpdate != null) {
                ppstUpdate.close();
            }
            if (ppstInsert != null) {
                ppstInsert.close();
            }
        }
        return updateSummaryCount;
    }

    public int putEntitys_1(DtsSession dtsSession, int userId, String tableName, boolean insertOnly, Object ... entitys) throws Exception {
        int manipulationPolicy = 0;
        if (insertOnly) {
            manipulationPolicy = 1;
        }
        return this.putEntitys_1(dtsSession, userId, tableName, manipulationPolicy, BcLogUtil.getDefaultLogger(), entitys);
    }

    public int putEntitys_2(DtsSession dtsSession, int userId, String tableName, Object ... entitys) throws Exception {
        return this.putEntitys_1(dtsSession, userId, tableName, false, entitys);
    }

    public int putEntitys_3(DtsSession dtsSession, String tableName, Object ... entitys) throws Exception {
        return this.putEntitys_2(dtsSession, -1, tableName, entitys);
    }

    public int putEntityCollection(DtsSession dtsSession, int userId, String tableName, boolean insertOnly, Collection entityCollection) throws Exception {
        return this.putEntitys_1(dtsSession, userId, tableName, insertOnly, entityCollection.toArray());
    }

    public int putEntityCollection(DtsSession dtsSession, int userId, String tableName, Collection entityCollection) throws Exception {
        return this.putEntityCollection(dtsSession, userId, tableName, false, entityCollection);
    }

    public int putEntityCollection(DtsSession dtsSession, String tableName, Collection entityCollection) throws Exception {
        return this.putEntityCollection(dtsSession, -1, tableName, entityCollection);
    }

    protected int putEntity_update(DtsSession dtsSession, OrmEntityContext entityContext, List<Integer> sqlTypeList, List<Object> valueList, String tableName, SqlPreparedStatement ppstUpdate, Object entity, BcLogger logger) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        sqlContext.setPreStmtValues(ppstUpdate, valueList, sqlTypeList);
        BcInteger primaryKeyOffset = new BcInteger();
        primaryKeyOffset.value = valueList.size();
        entityContext.setPrimaryKeyValue(dtsSession, ppstUpdate, tableName, primaryKeyOffset, entity);
        return ppstUpdate.executeUpdate();
    }

    protected int putEntity_insert(DtsSession dtsSession, List<Integer> sqlTypeList, List<Object> valueList, SqlPreparedStatement ppstInsert, BcLogger logger) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        sqlContext.setPreStmtValues(ppstInsert, valueList, sqlTypeList);
        return ppstInsert.executeUpdate();
    }

    public int deleteEntity(DtsSession dtsSession, String tableName, Object entity) throws Exception {
        Class<?> entityClass = entity.getClass();
        OrmEntityContext entityContext = OrmEntityContextManager.getInstance().getEntityContext(entityClass);
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlUpdateSql updateSql = entityContext.getUpdateSql(sqlContext, tableName);
        String sql = sqlContext.buildDeleteSql(updateSql);
        this.log(BcLogUtil.getDefaultLogger(), "sql=" + sql);
        int updateCount = 0;
        try (SqlPreparedStatement ppst = dtsSession.getConnection().prepareStatement(sql);){
            entityContext.setPrimaryKeyValue(dtsSession, ppst, tableName, entity);
            updateCount = ppst.executeUpdate();
        }
        return updateCount;
    }

    public String createSelectColumnPhrase(Class entityClass, String tableAlias) throws Exception {
        OrmEntityContext entityContext = OrmEntityContextManager.getInstance().getEntityContext(entityClass);
        return entityContext.getSelectColumnPhrase(tableAlias);
    }

    public String createSelectColumnPhrase(Class entityClass) throws Exception {
        return this.createSelectColumnPhrase(entityClass, null);
    }

    public boolean getEntity(DtsSession dtsSession, String tableName, Object entity) throws Exception {
        Class<?> entityClass = entity.getClass();
        OrmEntityContext entityContext = OrmEntityContextManager.getInstance().getEntityContext(entityClass);
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectSql selectSql = entityContext.getSelectSql(sqlContext, tableName);
        String query = sqlContext.buildSelectSql(selectSql);
        boolean dataExits = false;
        try (SqlPreparedStatement ppst1 = dtsSession.getConnection().prepareStatement(query);){
            entityContext.setPrimaryKeyValue(dtsSession, ppst1, tableName, entity);
            SqlResultSet rs = ppst1.executeQuery();
            if (rs.next()) {
                this.getEntity(dtsSession, rs, entity);
                dataExits = true;
            }
        }
        return dataExits;
    }

    protected void getEntity_ArrayFiled(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, Object array) throws Exception {
        Class<?> componentType = array.getClass().getComponentType();
        int arrayLength = Array.getLength(array);
        int i = 0;
        while (i < arrayLength) {
            this.getEntity_ArrayFiled_L2(dtsSession, rs, columnIndex, array, componentType, i);
            ++i;
        }
    }

    protected void getEntity_ArrayFiled_L2(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, Object array, Class componentType, int index) throws Exception {
        if (componentType.isPrimitive()) {
            this.setPrimitiveAyrrayValue(rs, columnIndex, array, componentType, index);
        } else if (BcLangUtil.isWrapperClass(componentType) || componentType.equals(String.class)) {
            Object value1 = rs.getObject(columnIndex);
            Object value2 = BcObjectConvertor.objectConvert(value1, componentType);
            Array.set(array, index, value2);
        } else {
            Object arrayElement = Array.get(array, index);
            if (arrayElement != null) {
                if (arrayElement.getClass().isArray()) {
                    this.getEntity_ArrayFiled(dtsSession, rs, columnIndex, arrayElement);
                } else {
                    this.getEntity(dtsSession, rs, columnIndex, arrayElement);
                }
            } else {
                this.getEntity(dtsSession, rs, columnIndex, arrayElement);
            }
        }
    }

    protected void setPrimitiveAyrrayValue(SqlResultSet rs, BcInteger columnIndex, Object array, Class componentType, int index) throws Exception {
        if (Integer.TYPE.isAssignableFrom(componentType)) {
            Array.setInt(array, index, rs.getInt(columnIndex));
        } else if (Short.TYPE.isAssignableFrom(componentType)) {
            Array.setShort(array, index, rs.getShort(columnIndex));
        } else if (Long.TYPE.isAssignableFrom(componentType)) {
            Array.setLong(array, index, rs.getLong(columnIndex));
        } else if (Byte.TYPE.isAssignableFrom(componentType)) {
            Array.setByte(array, index, rs.getByte(columnIndex));
        } else if (Double.TYPE.isAssignableFrom(componentType)) {
            Array.setDouble(array, index, rs.getDouble(columnIndex));
        } else if (Float.TYPE.isAssignableFrom(componentType)) {
            Array.setFloat(array, index, rs.getFloat(columnIndex));
        } else if (Character.TYPE.isAssignableFrom(componentType)) {
            Array.setChar(array, index, rs.getChar(columnIndex));
        } else if (Boolean.TYPE.isAssignableFrom(componentType)) {
            Array.setBoolean(array, index, rs.getBoolean(columnIndex));
        } else {
            throw new Exception(String.valueOf(componentType.getName()) + " is not primitive.");
        }
    }

    protected void getEntity_field(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, Object entity, Field field) throws Exception {
        if (!OrmPersistenceUtil.isPersistence(field)) {
            return;
        }
        Class<?> fieldType = field.getType();
        if (fieldType.isArray()) {
            Object array = field.get(entity);
            this.getEntity_ArrayFiled(dtsSession, rs, columnIndex, array);
        } else if (OrmPersistenceUtil.isPersistence(fieldType)) {
            Object value1 = null;
            value1 = BigDecimal.class.isAssignableFrom(field.getType()) ? rs.getBigDecimal(columnIndex) : rs.getObject(columnIndex);
            Object value2 = null;
            try {
                value2 = dtsSession.getSqlContext().objectConvert(value1, fieldType);
            }
            catch (Exception ex) {
                throw new Exception("field.getName()=" + field.getName(), ex);
            }
            BcReflectUtil.setFieldValue(field, entity, value2);
        } else {
            Object entity2 = BcReflectUtil.getFieldValue(field, entity);
            OrmEntityContext entityContext2 = OrmEntityContextManager.getInstance().getEntityContext(fieldType);
            List<Field> fieldList2 = entityContext2.getFieldList();
            int i = 0;
            while (i < fieldList2.size()) {
                Field field2 = fieldList2.get(i);
                this.getEntity_field(dtsSession, rs, columnIndex, entity2, field2);
                ++i;
            }
        }
    }

    protected void getEntity(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, Object entity) throws Exception {
        Class<?> entityClass = entity.getClass();
        OrmEntityContext entityContext = OrmEntityContextManager.getInstance().getEntityContext(entityClass);
        int i = 0;
        while (i < entityContext.getFieldList().size()) {
            Field field = entityContext.getFieldList().get(i);
            this.getEntity_field(dtsSession, rs, columnIndex, entity, field);
            ++i;
        }
        i = 0;
        while (i < entityContext.getSetterMethodList().size()) {
            Method setterMehtod = entityContext.getSetterMethodList().get(i);
            Object value = rs.getObject(columnIndex);
            value = dtsSession.getSqlContext().objectConvert(value, setterMehtod.getParameterTypes()[0]);
            setterMehtod.invoke(entity, value);
            ++i;
        }
    }

    public void getEntity(DtsSession dtsSession, SqlResultSet rs, Object entity) throws Exception {
        BcInteger columnIndex = new BcInteger();
        this.getEntity(dtsSession, rs, columnIndex, entity);
    }

    public int getObjectIdNewest(DtsSession dtsSession, String tableName, String columnName, long dataId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        int objectId = -1;
        String query = "SELECT sy_oid FROM " + tableName + " WHERE " + columnName + "=" + sqlContext.toSet(dataId) + " AND " + "sy_noid" + "=" + -1 + " ORDER BY " + "sy_oid" + " DESC";
        query = sqlContext.setLimit(query, 1, -1).toString();
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                objectId = rs.getInt(1);
            }
            rs.close();
        }
        return objectId;
    }

    public int getObjectIdNewest(DtsSession dtsSession, String tableName, int dataId) throws Exception {
        return this.getObjectIdNewest(dtsSession, tableName, "id", dataId);
    }

    /* synthetic */ OrmPersistenceProxy(OrmPersistenceProxy ormPersistenceProxy) {
        this();
    }

    private static final class SingletonHolder {
        private static final OrmPersistenceProxy instance = new OrmPersistenceProxy(null);

        private SingletonHolder() {
        }
    }
}

